/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.InternalFileType;
import com.intellij.openapi.vfs.VirtualFile;

public class ProjectCoreUtil {
    public static final String DIRECTORY_BASED_PROJECT_DIR = ".idea";

    public static boolean isProjectOrWorkspaceFile(VirtualFile file) {
        return ProjectCoreUtil.isProjectOrWorkspaceFile(file, file.getFileType());
    }

    public static boolean isProjectOrWorkspaceFile(VirtualFile file, FileType fileType) {
        if (fileType instanceof InternalFileType) {
            return true;
        }
        for (VirtualFile parent = file.getParent(); parent != null; parent = parent.getParent()) {
            if (!DIRECTORY_BASED_PROJECT_DIR.equals(parent.getName())) continue;
            return true;
        }
        return false;
    }
}

