/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;

public class PsiConcatenationUtil {
    public static void buildFormatString(PsiExpression expression, StringBuilder formatString, List<PsiExpression> formatParameters, boolean printfFormat) {
        if (expression instanceof PsiLiteralExpression) {
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)expression;
            String text = String.valueOf(literalExpression.getValue());
            String formatText = printfFormat ? StringUtil.escapeStringCharacters((String)text).replace("%", "%%").replace("\\'", "'") : StringUtil.escapeStringCharacters((String)text).replace("'", "''").replaceAll("((\\{|})+)", "'$1'");
            formatString.append(formatText);
        } else if (expression instanceof PsiPolyadicExpression) {
            PsiType type = expression.getType();
            if (type != null && type.equalsToText("java.lang.String")) {
                boolean stringStarted;
                PsiPolyadicExpression binaryExpression = (PsiPolyadicExpression)expression;
                PsiExpression[] operands = binaryExpression.getOperands();
                PsiType left = operands[0].getType();
                boolean bl = stringStarted = left != null && left.equalsToText("java.lang.String");
                if (stringStarted) {
                    PsiConcatenationUtil.buildFormatString(operands[0], formatString, formatParameters, printfFormat);
                }
                for (int i = 1; i < operands.length; ++i) {
                    PsiExpression op = operands[i];
                    PsiType optype = op.getType();
                    PsiType r = TypeConversionUtil.calcTypeForBinaryExpression(left, optype, binaryExpression.getOperationTokenType(), true);
                    if (r != null && r.equalsToText("java.lang.String") && !stringStarted) {
                        stringStarted = true;
                        PsiElement element = binaryExpression.getTokenBeforeOperand(op);
                        if (element.getPrevSibling() instanceof PsiWhiteSpace) {
                            element = element.getPrevSibling();
                        }
                        String text = binaryExpression.getText().substring(0, element.getStartOffsetInParent());
                        PsiExpression subExpression = JavaPsiFacade.getInstance(binaryExpression.getProject()).getElementFactory().createExpressionFromText(text, binaryExpression);
                        PsiConcatenationUtil.addFormatParameter(subExpression, formatString, formatParameters, printfFormat);
                    }
                    if (stringStarted) {
                        if (optype != null && (optype.equalsToText("java.lang.String") || optype == PsiType.CHAR)) {
                            PsiConcatenationUtil.buildFormatString(op, formatString, formatParameters, printfFormat);
                        } else {
                            PsiConcatenationUtil.addFormatParameter(op, formatString, formatParameters, printfFormat);
                        }
                    }
                    left = r;
                }
            } else {
                PsiConcatenationUtil.addFormatParameter(expression, formatString, formatParameters, printfFormat);
            }
        } else {
            PsiConcatenationUtil.addFormatParameter(expression, formatString, formatParameters, printfFormat);
        }
    }

    private static void addFormatParameter(PsiExpression expression, StringBuilder formatString, List<PsiExpression> formatParameters, boolean printfFormat) {
        PsiType type = expression.getType();
        if (!printfFormat) {
            formatString.append("{").append(formatParameters.size()).append("}");
        } else if (type != null && (type.equalsToText("long") || type.equalsToText("int") || type.equalsToText("java.lang.Long") || type.equalsToText("java.lang.Integer"))) {
            formatString.append("%d");
        } else {
            formatString.append("%s");
        }
        formatParameters.add(PsiConcatenationUtil.getBoxedArgument(expression));
    }

    private static PsiExpression getBoxedArgument(PsiExpression arg) throws IncorrectOperationException {
        arg = PsiUtil.deparenthesizeExpression(arg);
        assert (arg != null);
        if (PsiUtil.isLanguageLevel5OrHigher(arg)) {
            return arg;
        }
        PsiType type = arg.getType();
        if (!(type instanceof PsiPrimitiveType) || type.equals(PsiType.NULL)) {
            return arg;
        }
        PsiPrimitiveType primitiveType = (PsiPrimitiveType)type;
        String boxedQName = primitiveType.getBoxedTypeName();
        if (boxedQName == null) {
            return arg;
        }
        GlobalSearchScope resolveScope = arg.getResolveScope();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory(arg.getProject());
        PsiJavaCodeReferenceElement ref = factory.createReferenceElementByFQClassName(boxedQName, resolveScope);
        PsiNewExpression newExpr = (PsiNewExpression)factory.createExpressionFromText("new A(b)", null);
        PsiJavaCodeReferenceElement classRef = newExpr.getClassReference();
        assert (classRef != null);
        classRef.replace(ref);
        PsiExpressionList argumentList = newExpr.getArgumentList();
        assert (argumentList != null);
        argumentList.getExpressions()[0].replace(arg);
        return newExpr;
    }
}

