/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Function;
import com.intellij.util.PlatformIcons;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.testAssistant.TestDataGuessByExistingFilesUtil;
import org.jetbrains.idea.devkit.testAssistant.TestDataNavigationHandler;
import org.jetbrains.idea.devkit.testAssistant.TestDataReferenceCollector;
import org.jetbrains.idea.devkit.util.PsiUtil;

public class TestDataLineMarkerProvider
implements LineMarkerProvider {
    public static final String TEST_DATA_PATH_ANNOTATION_QUALIFIED_NAME = "com.intellij.testFramework.TestDataPath";
    public static final String CONTENT_ROOT_VARIABLE = "$CONTENT_ROOT";
    public static final String PROJECT_ROOT_VARIABLE = "$PROJECT_ROOT";

    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/devkit/testAssistant/TestDataLineMarkerProvider", "getLineMarkerInfo"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        if (!(element instanceof PsiMethod) && !(element instanceof PsiClass)) {
            return null;
        }
        if (!PsiUtil.isPluginProject(element.getProject())) {
            return null;
        }
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (file == null || !ProjectFileIndex.SERVICE.getInstance((Project)element.getProject()).isInTestSourceContent(file)) {
            return null;
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            if (TestDataLineMarkerProvider.isTestMethod(method)) {
                return new LineMarkerInfo((PsiElement)method, method.getModifierList().getTextRange(), PlatformIcons.TEST_SOURCE_FOLDER, 4, null, (GutterIconNavigationHandler)new TestDataNavigationHandler(), GutterIconRenderer.Alignment.LEFT);
            }
        } else {
            final PsiClass psiClass = (PsiClass)element;
            final String basePath = TestDataLineMarkerProvider.getTestDataBasePath(psiClass);
            if (basePath != null) {
                PsiModifierList modifierList = psiClass.getModifierList();
                assert (modifierList != null);
                return new LineMarkerInfo((PsiElement)psiClass, modifierList.getTextRange(), PlatformIcons.TEST_SOURCE_FOLDER, 4, (Function)new TooltipProvider(basePath), (GutterIconNavigationHandler)new GutterIconNavigationHandler<PsiClass>(){

                    public void navigate(MouseEvent e, PsiClass elt) {
                        VirtualFile baseDir = VfsUtil.findFileByIoFile((File)new File(basePath), (boolean)true);
                        if (baseDir != null) {
                            new OpenFileDescriptor(psiClass.getProject(), baseDir).navigate(true);
                        }
                    }
                }, GutterIconRenderer.Alignment.LEFT);
            }
        }
        return null;
    }

    private static boolean isTestMethod(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/idea/devkit/testAssistant/TestDataLineMarkerProvider", "isTestMethod"));
        }
        if (TestDataLineMarkerProvider.isTestMethodWithAnnotation(method)) {
            return true;
        }
        List<String> files = TestDataGuessByExistingFilesUtil.collectTestDataByExistingFiles(method);
        return files != null && !files.isEmpty();
    }

    private static boolean isTestMethodWithAnnotation(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/idea/devkit/testAssistant/TestDataLineMarkerProvider", "isTestMethodWithAnnotation"));
        }
        String name = method.getName();
        if (!name.startsWith("test")) {
            return false;
        }
        String testDataPath = TestDataLineMarkerProvider.getTestDataBasePath(method.getContainingClass());
        if (testDataPath == null) {
            return false;
        }
        List<String> fileNames = new TestDataReferenceCollector(testDataPath, TestDataGuessByExistingFilesUtil.getTestName(name)).collectTestDataReferences(method);
        return fileNames != null && !fileNames.isEmpty();
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/idea/devkit/testAssistant/TestDataLineMarkerProvider", "collectSlowLineMarkers"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/idea/devkit/testAssistant/TestDataLineMarkerProvider", "collectSlowLineMarkers"));
        }
    }

    @Nullable
    public static String getTestDataBasePath(PsiClass psiClass) {
        Project project;
        PsiConstantEvaluationHelper evaluationHelper;
        Object constantValue;
        PsiAnnotationMemberValue value;
        PsiAnnotation annotation = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)psiClass, Collections.singleton(TEST_DATA_PATH_ANNOTATION_QUALIFIED_NAME));
        if (annotation != null && (value = annotation.findAttributeValue("value")) instanceof PsiExpression && (constantValue = (evaluationHelper = JavaPsiFacade.getInstance((Project)(project = value.getProject())).getConstantEvaluationHelper()).computeConstantExpression((PsiElement)value, false)) instanceof String) {
            String path = (String)constantValue;
            if (path.contains(CONTENT_ROOT_VARIABLE)) {
                ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
                VirtualFile file = psiClass.getContainingFile().getVirtualFile();
                if (file == null) {
                    return null;
                }
                VirtualFile contentRoot = fileIndex.getContentRootForFile(file);
                if (contentRoot == null) {
                    return null;
                }
                path = path.replace(CONTENT_ROOT_VARIABLE, contentRoot.getPath());
            }
            if (path.contains(PROJECT_ROOT_VARIABLE)) {
                VirtualFile baseDir = project.getBaseDir();
                if (baseDir == null) {
                    return null;
                }
                path = path.replace(PROJECT_ROOT_VARIABLE, baseDir.getPath());
            }
            return path;
        }
        return null;
    }

    private static class TooltipProvider
    implements Function<PsiClass, String> {
        @NotNull
        private final String myBasePath;

        public TooltipProvider(@NotNull String basePath) {
            if (basePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "basePath", "org/jetbrains/idea/devkit/testAssistant/TestDataLineMarkerProvider$TooltipProvider", "<init>"));
            }
            this.myBasePath = basePath;
        }

        public String fun(PsiClass aClass) {
            return this.myBasePath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TooltipProvider)) {
                return false;
            }
            TooltipProvider provider = (TooltipProvider)o;
            return this.myBasePath.equals(provider.myBasePath);
        }

        public int hashCode() {
            return this.myBasePath.hashCode();
        }
    }
}

