/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.descriptors;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.FxmlConstants;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxPropertyAttributeDescriptor;

public class JavaFxDefaultAttributeDescriptor
extends JavaFxPropertyAttributeDescriptor {
    private static final Logger LOG = Logger.getInstance((String)("#" + JavaFxDefaultAttributeDescriptor.class.getName()));
    private String myDefaultPropertyName = null;

    public JavaFxDefaultAttributeDescriptor(String name, PsiClass psiClass) {
        super(name, psiClass);
    }

    public JavaFxDefaultAttributeDescriptor(String name, String defaultPropertyName) {
        super(name, null);
        this.myDefaultPropertyName = defaultPropertyName;
    }

    @Override
    public boolean hasIdType() {
        return this.getName().equals("fx:id");
    }

    @Override
    public boolean isEnumerated() {
        return this.getName().equals("fx:constant");
    }

    @Override
    public boolean isRequired() {
        List<String> requiredAttrs;
        return this.myDefaultPropertyName != null && (requiredAttrs = FxmlConstants.FX_REQUIRED_ELEMENT_ATTRIBUTES.get(this.myDefaultPropertyName)) != null && requiredAttrs.contains(this.getName());
    }

    @Override
    protected PsiClass getEnum() {
        return this.isEnumerated() ? this.getPsiClass() : null;
    }

    @Override
    protected boolean isConstant(PsiField field) {
        return field.hasModifierProperty("static") && field.hasModifierProperty("final") && field.hasModifierProperty("public");
    }

    @Override
    @Nullable
    public String validateValue(XmlElement context, String value) {
        PsiMethod method;
        PsiClass tagClass;
        XmlAttribute attribute;
        String attributeName;
        PsiElement parent;
        if (context instanceof XmlAttributeValue && (parent = context.getParent()) instanceof XmlAttribute && "fx:value".equals(attributeName = (attribute = (XmlAttribute)parent).getName()) && (tagClass = JavaFxPsiUtil.getTagClass((XmlAttributeValue)context)) != null && (method = JavaFxPsiUtil.findValueOfMethod(tagClass)) == null) {
            return "Unable to coerce '" + value + "' to " + tagClass.getQualifiedName() + ".";
        }
        return super.validateValue(context, value);
    }
}

