/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.ListStack;

public class IfExprent
extends Exprent {
    public static final int IF_EQ = 0;
    public static final int IF_NE = 1;
    public static final int IF_LT = 2;
    public static final int IF_GE = 3;
    public static final int IF_GT = 4;
    public static final int IF_LE = 5;
    public static final int IF_NULL = 6;
    public static final int IF_NONNULL = 7;
    public static final int IF_ICMPEQ = 8;
    public static final int IF_ICMPNE = 9;
    public static final int IF_ICMPLT = 10;
    public static final int IF_ICMPGE = 11;
    public static final int IF_ICMPGT = 12;
    public static final int IF_ICMPLE = 13;
    public static final int IF_ACMPEQ = 14;
    public static final int IF_ACMPNE = 15;
    public static final int IF_CAND = 16;
    public static final int IF_COR = 17;
    public static final int IF_NOT = 18;
    public static final int IF_VALUE = 19;
    private static final int[] functypes = new int[]{42, 43, 44, 45, 46, 47, 42, 43, 42, 43, 44, 45, 46, 47, 42, 43, 48, 49, 12, -1};
    private Exprent condition;

    public IfExprent(int iftype, ListStack<Exprent> stack) {
        this.type = 7;
        if (iftype <= 5) {
            stack.push(new ConstExprent(0, true));
        } else if (iftype <= 7) {
            stack.push(new ConstExprent(VarType.VARTYPE_NULL, null));
        }
        this.condition = iftype == 19 ? stack.pop() : new FunctionExprent(functypes[iftype], stack);
    }

    private IfExprent(Exprent condition) {
        this.type = 7;
        this.condition = condition;
    }

    @Override
    public Exprent copy() {
        return new IfExprent(this.condition.copy());
    }

    @Override
    public List<Exprent> getAllExprents() {
        ArrayList<Exprent> lst = new ArrayList<Exprent>();
        lst.add(this.condition);
        return lst;
    }

    @Override
    public String toJava(int indent, BytecodeMappingTracer tracer) {
        tracer.addMapping(this.bytecode);
        return "if(" + this.condition.toJava(indent, tracer) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof IfExprent)) {
            return false;
        }
        IfExprent ie = (IfExprent)o;
        return InterpreterUtil.equalObjects(this.condition, ie.getCondition());
    }

    @Override
    public void replaceExprent(Exprent oldexpr, Exprent newexpr) {
        if (oldexpr == this.condition) {
            this.condition = newexpr;
        }
    }

    public IfExprent negateIf() {
        this.condition = new FunctionExprent(12, Arrays.asList(this.condition));
        return this;
    }

    public Exprent getCondition() {
        return this.condition;
    }

    public void setCondition(Exprent condition) {
        this.condition = condition;
    }
}

