/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.gen;

import org.jetbrains.java.decompiler.struct.gen.VarType;

public class FieldDescriptor {
    public static final FieldDescriptor INTEGER_DESCRIPTOR = FieldDescriptor.parseDescriptor("Ljava/lang/Integer;");
    public static final FieldDescriptor LONG_DESCRIPTOR = FieldDescriptor.parseDescriptor("Ljava/lang/Long;");
    public static final FieldDescriptor FLOAT_DESCRIPTOR = FieldDescriptor.parseDescriptor("Ljava/lang/Float;");
    public static final FieldDescriptor DOUBLE_DESCRIPTOR = FieldDescriptor.parseDescriptor("Ljava/lang/Double;");
    public VarType type;
    public String descriptorString;

    private FieldDescriptor() {
    }

    public static FieldDescriptor parseDescriptor(String descr) {
        FieldDescriptor fd = new FieldDescriptor();
        fd.type = new VarType(descr);
        fd.descriptorString = descr;
        return fd;
    }

    public String getDescriptor() {
        return this.type.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof FieldDescriptor)) {
            return false;
        }
        FieldDescriptor fd = (FieldDescriptor)o;
        return this.type.equals(fd.type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }
}

