/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundleManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nullable;

public interface BundleNameEvaluator {
    public static final BundleNameEvaluator DEFAULT = new BundleNameEvaluator(){

        @Override
        @Nullable
        public String evaluateBundleName(PsiFile psiFile) {
            PsiDirectory directory = psiFile.getParent();
            if (directory == null) {
                return null;
            }
            String packageQualifiedName = PropertiesUtil.getPackageQualifiedName(directory);
            if (packageQualifiedName != null) {
                StringBuilder qName = new StringBuilder(packageQualifiedName);
                if (qName.length() > 0) {
                    qName.append(".");
                }
                qName.append(ResourceBundleManager.getInstance(psiFile.getProject()).getBaseName(psiFile));
                return qName.toString();
            }
            return null;
        }
    };

    @Nullable
    public String evaluateBundleName(PsiFile var1);
}

