/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.customizeActions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleManager;
import com.intellij.lang.properties.editor.ResourceBundleAsVirtualFile;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nullable;

public class DissociateResourceBundleAction
extends AnAction {
    private static final String PRESENTATION_TEXT_TEMPLATE = "Dissociate Resource Bundle '%s'";

    public DissociateResourceBundleAction() {
        super(null, null, AllIcons.FileTypes.Properties);
    }

    public void actionPerformed(AnActionEvent e) {
        ResourceBundle resourceBundle = DissociateResourceBundleAction.extractResourceBundle(e);
        assert (resourceBundle != null);
        Project project = resourceBundle.getProject();
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        fileEditorManager.closeFile((VirtualFile)new ResourceBundleAsVirtualFile(resourceBundle));
        for (PropertiesFile propertiesFile : resourceBundle.getPropertiesFiles()) {
            fileEditorManager.closeFile(propertiesFile.getVirtualFile());
        }
        ResourceBundleManager.getInstance(e.getProject()).dissociateResourceBundle(resourceBundle);
        ProjectView.getInstance((Project)project).refresh();
    }

    public void update(AnActionEvent e) {
        ResourceBundle resourceBundle = DissociateResourceBundleAction.extractResourceBundle(e);
        if (resourceBundle != null) {
            e.getPresentation().setText(String.format(PRESENTATION_TEXT_TEMPLATE, resourceBundle.getBaseName()), false);
            e.getPresentation().setVisible(true);
        } else {
            e.getPresentation().setVisible(false);
        }
    }

    @Nullable
    private static ResourceBundle extractResourceBundle(AnActionEvent event) {
        ResourceBundle[] data = (ResourceBundle[])event.getData(ResourceBundle.ARRAY_DATA_KEY);
        if (data != null && data.length == 1 && data[0].getPropertiesFiles().size() > 1) {
            return data[0];
        }
        PropertiesFile propertiesFile = PropertiesImplUtil.getPropertiesFile((PsiFile)event.getData(PlatformDataKeys.PSI_FILE));
        if (propertiesFile == null) {
            return null;
        }
        ResourceBundle resourceBundle = propertiesFile.getResourceBundle();
        return resourceBundle.getPropertiesFiles().size() > 1 ? resourceBundle : null;
    }
}

