/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.changes;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.internal.changedetection.changes.StatefulIncrementalTaskInputs;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChanges;
import org.gradle.api.internal.changedetection.state.FilesSnapshotSet;
import org.gradle.api.tasks.incremental.InputFileDetails;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangesOnlyIncrementalTaskInputs
extends StatefulIncrementalTaskInputs {
    private final TaskStateChanges inputFilesState;
    private List<InputFileDetails> removedFiles = new ArrayList<InputFileDetails>();

    public ChangesOnlyIncrementalTaskInputs(TaskStateChanges inputFilesState, FilesSnapshotSet inputFilesSnapshot) {
        super(inputFilesSnapshot);
        this.inputFilesState = inputFilesState;
    }

    @Override
    public boolean isIncremental() {
        return true;
    }

    @Override
    protected void doOutOfDate(Action<? super InputFileDetails> outOfDateAction) {
        for (TaskStateChange change : this.inputFilesState) {
            InputFileDetails fileChange = (InputFileDetails)((Object)change);
            if (fileChange.isRemoved()) {
                this.removedFiles.add(fileChange);
                continue;
            }
            outOfDateAction.execute((Object)fileChange);
        }
    }

    @Override
    protected void doRemoved(Action<? super InputFileDetails> removedAction) {
        for (InputFileDetails removedFile : this.removedFiles) {
            removedAction.execute((Object)removedFile);
        }
    }
}

