/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.push;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.PushTargetPanel;
import com.intellij.dvcs.push.VcsError;
import com.intellij.dvcs.push.ui.PushTargetTextField;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TextFieldWithAutoCompletion;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.push.HgTarget;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgUtil;

public class HgPushTargetPanel
extends PushTargetPanel<HgTarget> {
    private static final String ENTER_REMOTE = "Enter Remote";
    private final HgRepository myRepository;
    private final TextFieldWithAutoCompletion<String> myDestTargetPanel;
    private String myOldText;

    public HgPushTargetPanel(@NotNull HgRepository repository, @Nullable HgTarget defaultTarget) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/push/HgPushTargetPanel", "<init>"));
        }
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.myRepository = repository;
        List<String> targetVariants = HgUtil.getTargetNames(repository);
        this.myOldText = defaultTarget != null ? defaultTarget.getPresentation() : "";
        this.myDestTargetPanel = new PushTargetTextField(repository.getProject(), targetVariants, this.myOldText);
        this.add((Component)this.myDestTargetPanel, "Center");
    }

    public void render(@NotNull ColoredTreeCellRenderer renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "org/zmlx/hg4idea/push/HgPushTargetPanel", "render"));
        }
        String targetText = this.myDestTargetPanel.getText();
        if (StringUtil.isEmptyOrSpaces((String)targetText)) {
            renderer.append(ENTER_REMOTE, SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES, (Object)this);
        }
        renderer.append(targetText, SimpleTextAttributes.SYNTHETIC_ATTRIBUTES, (Object)this);
    }

    @NotNull
    public HgTarget getValue() {
        HgTarget hgTarget = this.createValidPushTarget();
        if (hgTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/push/HgPushTargetPanel", "getValue"));
        }
        return hgTarget;
    }

    @NotNull
    private HgTarget createValidPushTarget() {
        HgTarget hgTarget = new HgTarget(this.myDestTargetPanel.getText());
        if (hgTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/push/HgPushTargetPanel", "createValidPushTarget"));
        }
        return hgTarget;
    }

    public void fireOnCancel() {
        this.myDestTargetPanel.setText(this.myOldText);
    }

    public void fireOnChange() {
        this.myOldText = this.myDestTargetPanel.getText();
    }

    @Nullable
    public ValidationInfo verify() {
        if (StringUtil.isEmptyOrSpaces((String)this.myDestTargetPanel.getText())) {
            return new ValidationInfo(VcsError.createEmptyTargetError((String)DvcsUtil.getShortRepositoryName((Repository)this.myRepository)).getText(), (JComponent)((Object)this));
        }
        return null;
    }

    public void setFireOnChangeAction(@NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "org/zmlx/hg4idea/push/HgPushTargetPanel", "setFireOnChangeAction"));
        }
    }
}

