/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiVariable;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class SideEffectWarningDialog
extends DialogWrapper {
    private final PsiVariable myVariable;
    private final String myBeforeText;
    private final String myAfterText;
    private final boolean myCanCopeWithSideEffects;
    private AbstractAction myRemoveAllAction;
    private AbstractAction myCancelAllAction;

    public SideEffectWarningDialog(Project project, boolean canBeParent, PsiVariable variable, String beforeText, String afterText, boolean canCopeWithSideEffects) {
        super(project, canBeParent);
        this.myVariable = variable;
        this.myBeforeText = beforeText;
        this.myAfterText = afterText;
        this.myCanCopeWithSideEffects = canCopeWithSideEffects;
        this.setTitle(QuickFixBundle.message("side.effects.warning.dialog.title", new Object[0]));
        this.init();
    }

    @NotNull
    protected Action[] createActions() {
        ArrayList<AbstractAction> actions = new ArrayList<AbstractAction>();
        this.myRemoveAllAction = new AbstractAction(){
            {
                UIUtil.setActionNameAndMnemonic((String)QuickFixBundle.message("side.effect.action.remove", new Object[0]), (Action)this);
                this.putValue("DefaultAction", this);
            }

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/daemon/impl/quickfix/SideEffectWarningDialog$1", "actionPerformed"));
                }
                SideEffectWarningDialog.this.close(2);
            }
        };
        actions.add(this.myRemoveAllAction);
        if (this.myCanCopeWithSideEffects) {
            AbstractAction makeStmtAction = new AbstractAction(){
                {
                    UIUtil.setActionNameAndMnemonic((String)QuickFixBundle.message("side.effect.action.transform", new Object[0]), (Action)this);
                }

                @Override
                public void actionPerformed(@NotNull ActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/daemon/impl/quickfix/SideEffectWarningDialog$2", "actionPerformed"));
                    }
                    SideEffectWarningDialog.this.close(1);
                }
            };
            actions.add(makeStmtAction);
        }
        this.myCancelAllAction = new AbstractAction(){
            {
                UIUtil.setActionNameAndMnemonic((String)QuickFixBundle.message("side.effect.action.cancel", new Object[0]), (Action)this);
            }

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/daemon/impl/quickfix/SideEffectWarningDialog$3", "actionPerformed"));
                }
                SideEffectWarningDialog.this.doCancelAction();
            }
        };
        actions.add(this.myCancelAllAction);
        Action[] actionArray = actions.toArray(new Action[actions.size()]);
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/SideEffectWarningDialog", "createActions"));
        }
        return actionArray;
    }

    @NotNull
    protected Action getCancelAction() {
        AbstractAction abstractAction = this.myCancelAllAction;
        if (abstractAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/SideEffectWarningDialog", "getCancelAction"));
        }
        return abstractAction;
    }

    @NotNull
    protected Action getOKAction() {
        AbstractAction abstractAction = this.myRemoveAllAction;
        if (abstractAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/SideEffectWarningDialog", "getOKAction"));
        }
        return abstractAction;
    }

    public void doCancelAction() {
        this.close(0);
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        String text = this.sideEffectsDescription();
        JLabel label = new JLabel(text);
        label.setIcon(Messages.getWarningIcon());
        panel.add((Component)label, "North");
        return panel;
    }

    protected String sideEffectsDescription() {
        if (this.myCanCopeWithSideEffects) {
            String format = "<html>\n<body>\nThere are possible side effects found in expressions assigned to the variable ''{0}''<br>\nYou can:\n<br>\n\u2014&nbsp;<b>Remove</b> variable usages along with all expressions involved, or<br>\n\u2014&nbsp;<b>Transform</b> expressions assigned to variable into the statements on their own.<br>\n<div style=\"padding-left: 0.6cm;\">\n  That is,<br>\n  <table border=\"0\">\n    <tr>\n      <td><code>{1} {0} = {2};</code></td>\n    </tr>\n  </table>\n  becomes: <br>\n  <table border=\"0\">\n    <tr>\n      <td><code>{3};</code></td>\n    </tr>\n  </table>\n</div>\n</body>\n</html>";
            return MessageFormat.format(format, this.myVariable.getName(), this.myVariable.getType().getPresentableText(), this.myBeforeText, this.myAfterText);
        }
        return QuickFixBundle.message("side.effect.message1", this.myVariable.getName());
    }
}

