/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class CutHandler
extends EditorWriteActionHandler {
    private final EditorActionHandler myOriginalHandler;

    public CutHandler(EditorActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    public void executeWriteAction(final Editor editor, Caret caret, DataContext dataContext) {
        assert (caret == null) : "Invocation of 'cut' operation for specific caret is not supported";
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)editor.getContentComponent()));
        if (project == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor, null, dataContext);
            }
            return;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor, null, dataContext);
            }
            return;
        }
        final SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasSelection(true) && !selectionModel.hasBlockSelection()) {
            if (Registry.is((String)"editor.skip.copy.and.cut.for.empty.selection")) {
                return;
            }
            editor.getCaretModel().runForEachCaret(new CaretAction(){

                public void perform(Caret caret) {
                    selectionModel.selectLineAtCaret();
                }
            });
            if (!selectionModel.hasSelection(true)) {
                return;
            }
        }
        int start = selectionModel.getSelectionStart();
        int end = selectionModel.getSelectionEnd();
        final ArrayList selections = new ArrayList();
        if (editor.getCaretModel().supportsMultipleCarets()) {
            editor.getCaretModel().runForEachCaret(new CaretAction(){

                public void perform(Caret caret) {
                    selections.add(new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd()));
                }
            });
        }
        EditorActionManager.getInstance().getActionHandler("EditorCopy").execute(editor, null, dataContext);
        if (editor.getCaretModel().supportsMultipleCarets()) {
            Collections.reverse(selections);
            final Iterator it = selections.iterator();
            editor.getCaretModel().runForEachCaret(new CaretAction(){

                public void perform(Caret caret) {
                    TextRange range = (TextRange)it.next();
                    editor.getCaretModel().moveToOffset(range.getStartOffset());
                    selectionModel.removeSelection();
                    editor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
                }
            });
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        } else if (start != end) {
            editor.getDocument().deleteString(start, end);
        } else {
            EditorModificationUtil.deleteSelectedText((Editor)editor);
        }
    }
}

