/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.ui;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.generation.GenerateEqualsHelper;
import com.intellij.codeInsight.generation.ui.AbstractGenerateEqualsWizard;
import com.intellij.ide.wizard.Step;
import com.intellij.ide.wizard.StepAdapter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.classMembers.AbstractMemberInfoModel;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoTooltipManager;
import com.intellij.refactoring.ui.AbstractMemberSelectionPanel;
import com.intellij.refactoring.ui.MemberSelectionPanel;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.util.containers.HashMap;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class GenerateEqualsWizard
extends AbstractGenerateEqualsWizard<PsiClass, PsiMember, MemberInfo> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.generation.ui.GenerateEqualsWizard");
    private static final MyMemberInfoFilter MEMBER_INFO_FILTER = new MyMemberInfoFilter();

    public GenerateEqualsWizard(Project project, PsiClass aClass, boolean needEquals, boolean needHashCode) {
        super(project, new JavaGenerateEqualsWizardBuilder(aClass, needEquals, needHashCode));
    }

    public PsiField[] getEqualsFields() {
        if (this.myEqualsPanel != null) {
            return GenerateEqualsWizard.memberInfosToFields(this.myEqualsPanel.getTable().getSelectedMemberInfos());
        }
        return null;
    }

    public PsiField[] getHashCodeFields() {
        if (this.myHashCodePanel != null) {
            return GenerateEqualsWizard.memberInfosToFields(this.myHashCodePanel.getTable().getSelectedMemberInfos());
        }
        return null;
    }

    public PsiField[] getNonNullFields() {
        return GenerateEqualsWizard.memberInfosToFields(this.myNonNullPanel.getTable().getSelectedMemberInfos());
    }

    private static PsiField[] memberInfosToFields(Collection<MemberInfo> infos) {
        ArrayList<PsiField> list = new ArrayList<PsiField>();
        for (MemberInfo info : infos) {
            list.add((PsiField)info.getMember());
        }
        return list.toArray(new PsiField[list.size()]);
    }

    @Override
    protected String getHelpID() {
        return "editing.altInsert.equals";
    }

    private void equalsFieldsSelected() {
        Collection selectedMemberInfos = this.myEqualsPanel.getTable().getSelectedMemberInfos();
        this.updateHashCodeMemberInfos(selectedMemberInfos);
        this.updateNonNullMemberInfos(selectedMemberInfos);
    }

    @Override
    protected void doOKAction() {
        if (this.myEqualsPanel != null) {
            this.equalsFieldsSelected();
        }
        super.doOKAction();
    }

    protected int getNextStep(int step) {
        if (step + 1 == this.getNonNullStepCode()) {
            for (MemberInfo classField : this.myClassFields) {
                PsiField field;
                if (!classField.isChecked() || (field = (PsiField)classField.getMember()).getType() instanceof PsiPrimitiveType) continue;
                return this.getNonNullStepCode();
            }
            return step;
        }
        return super.getNextStep(step);
    }

    @Override
    protected void addSteps() {
        if (this.myEqualsPanel != null) {
            this.addStep((Step)new InstanceofOptionStep(((PsiClass)this.myClass).hasModifierProperty("final")));
        }
        super.addSteps();
    }

    private static class InstanceofOptionStep
    extends StepAdapter {
        private final JComponent myPanel;

        private InstanceofOptionStep(boolean isFinal) {
            NonFocusableCheckBox checkbox = new NonFocusableCheckBox(CodeInsightBundle.message((String)"generate.equals.hashcode.accept.sublcasses", (Object[])new Object[0]));
            checkbox.setSelected(!isFinal && CodeInsightSettings.getInstance().USE_INSTANCEOF_ON_EQUALS_PARAMETER);
            checkbox.setEnabled(!isFinal);
            checkbox.addActionListener(new ActionListener((JCheckBox)checkbox){
                final /* synthetic */ JCheckBox val$checkbox;
                {
                    this.val$checkbox = jCheckBox;
                }

                @Override
                public void actionPerformed(@NotNull ActionEvent M) {
                    if (M == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "M", "com/intellij/codeInsight/generation/ui/GenerateEqualsWizard$InstanceofOptionStep$1", "actionPerformed"));
                    }
                    CodeInsightSettings.getInstance().USE_INSTANCEOF_ON_EQUALS_PARAMETER = this.val$checkbox.isSelected();
                }
            });
            this.myPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
            this.myPanel.add((Component)checkbox);
            this.myPanel.add(new JLabel(CodeInsightBundle.message((String)"generate.equals.hashcode.accept.sublcasses.explanation", (Object[])new Object[0])));
        }

        public JComponent getComponent() {
            return this.myPanel;
        }
    }

    private static class HashCodeMemberInfoModel
    extends AbstractMemberInfoModel<PsiMember, MemberInfo> {
        private final MemberInfoTooltipManager<PsiMember, MemberInfo> myTooltipManager = new MemberInfoTooltipManager<PsiMember, MemberInfo>(new MemberInfoTooltipManager.TooltipProvider<PsiMember, MemberInfo>(){

            @Override
            public String getTooltip(MemberInfo memberInfo) {
                if (HashCodeMemberInfoModel.this.isMemberEnabled(memberInfo)) {
                    return null;
                }
                if (!(memberInfo.getMember() instanceof PsiField)) {
                    return CodeInsightBundle.message((String)"generate.equals.hashcode.internal.error", (Object[])new Object[0]);
                }
                PsiType type = ((PsiField)memberInfo.getMember()).getType();
                if (!(type instanceof PsiArrayType)) {
                    return null;
                }
                return CodeInsightBundle.message((String)"generate.equals.hashcode.warning.hashcode.for.arrays.is.not.supported", (Object[])new Object[0]);
            }
        });

        private HashCodeMemberInfoModel() {
        }

        public boolean isMemberEnabled(MemberInfo member) {
            PsiMember psiMember = (PsiMember)member.getMember();
            return psiMember instanceof PsiField;
        }

        public String getTooltipText(MemberInfo member) {
            return this.myTooltipManager.getTooltip(member);
        }
    }

    private static class EqualsMemberInfoModel
    extends AbstractMemberInfoModel<PsiMember, MemberInfo> {
        MemberInfoTooltipManager<PsiMember, MemberInfo> myTooltipManager = new MemberInfoTooltipManager<PsiMember, MemberInfo>(new MemberInfoTooltipManager.TooltipProvider<PsiMember, MemberInfo>(){

            @Override
            public String getTooltip(MemberInfo memberInfo) {
                if (EqualsMemberInfoModel.this.checkForProblems(memberInfo) == 0) {
                    return null;
                }
                if (!(memberInfo.getMember() instanceof PsiField)) {
                    return CodeInsightBundle.message((String)"generate.equals.hashcode.internal.error", (Object[])new Object[0]);
                }
                PsiType type = ((PsiField)memberInfo.getMember()).getType();
                if (GenerateEqualsHelper.isNestedArray(type)) {
                    return CodeInsightBundle.message((String)"generate.equals.warning.equals.for.nested.arrays.not.supported", (Object[])new Object[0]);
                }
                if (GenerateEqualsHelper.isArrayOfObjects(type)) {
                    return CodeInsightBundle.message((String)"generate.equals.warning.generated.equals.could.be.incorrect", (Object[])new Object[0]);
                }
                return null;
            }
        });

        private EqualsMemberInfoModel() {
        }

        public boolean isMemberEnabled(MemberInfo member) {
            if (!(member.getMember() instanceof PsiField)) {
                return false;
            }
            PsiType type = ((PsiField)member.getMember()).getType();
            return !GenerateEqualsHelper.isNestedArray(type);
        }

        public int checkForProblems(@NotNull MemberInfo member) {
            if (member == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/codeInsight/generation/ui/GenerateEqualsWizard$EqualsMemberInfoModel", "checkForProblems"));
            }
            if (!(member.getMember() instanceof PsiField)) {
                return 2;
            }
            PsiType type = ((PsiField)member.getMember()).getType();
            if (GenerateEqualsHelper.isNestedArray(type)) {
                return 2;
            }
            if (GenerateEqualsHelper.isArrayOfObjects(type)) {
                return 1;
            }
            return 0;
        }

        public String getTooltipText(MemberInfo member) {
            return this.myTooltipManager.getTooltip(member);
        }
    }

    private static class MyMemberInfoFilter
    implements MemberInfoBase.Filter<PsiMember> {
        private MyMemberInfoFilter() {
        }

        public boolean includeMember(PsiMember element) {
            return element instanceof PsiField && !element.hasModifierProperty("static");
        }
    }

    public static class JavaGenerateEqualsWizardBuilder
    extends AbstractGenerateEqualsWizard.Builder<PsiClass, PsiMember, MemberInfo> {
        private final PsiClass myClass;
        private final MemberSelectionPanel myEqualsPanel;
        private final MemberSelectionPanel myHashCodePanel;
        private final MemberSelectionPanel myNonNullPanel;
        private final HashMap<PsiMember, MemberInfo> myFieldsToHashCode;
        private final HashMap<PsiMember, MemberInfo> myFieldsToNonNull;
        private final List<MemberInfo> myClassFields;

        private JavaGenerateEqualsWizardBuilder(PsiClass aClass, boolean needEquals, boolean needHashCode) {
            LOG.assertTrue(needEquals || needHashCode);
            this.myClass = aClass;
            this.myClassFields = MemberInfo.extractClassMembers(this.myClass, MEMBER_INFO_FILTER, false);
            for (MemberInfo myClassField : this.myClassFields) {
                myClassField.setChecked(true);
            }
            if (needEquals) {
                this.myEqualsPanel = new MemberSelectionPanel(CodeInsightBundle.message((String)"generate.equals.hashcode.equals.fields.chooser.title", (Object[])new Object[0]), this.myClassFields, null);
                this.myEqualsPanel.getTable().setMemberInfoModel(new EqualsMemberInfoModel());
            } else {
                this.myEqualsPanel = null;
            }
            if (needHashCode) {
                List<MemberInfo> hashCodeMemberInfos;
                if (needEquals) {
                    this.myFieldsToHashCode = this.createFieldToMemberInfoMap(true);
                    hashCodeMemberInfos = Collections.emptyList();
                } else {
                    hashCodeMemberInfos = this.myClassFields;
                    this.myFieldsToHashCode = null;
                }
                this.myHashCodePanel = new MemberSelectionPanel(CodeInsightBundle.message((String)"generate.equals.hashcode.hashcode.fields.chooser.title", (Object[])new Object[0]), hashCodeMemberInfos, null);
                this.myHashCodePanel.getTable().setMemberInfoModel(new HashCodeMemberInfoModel());
                if (needEquals) {
                    this.updateHashCodeMemberInfos((Collection<MemberInfo>)this.myClassFields);
                }
            } else {
                this.myHashCodePanel = null;
                this.myFieldsToHashCode = null;
            }
            this.myNonNullPanel = new MemberSelectionPanel(CodeInsightBundle.message((String)"generate.equals.hashcode.non.null.fields.chooser.title", (Object[])new Object[0]), Collections.<MemberInfo>emptyList(), null);
            this.myFieldsToNonNull = this.createFieldToMemberInfoMap(false);
            for (Map.Entry entry : this.myFieldsToNonNull.entrySet()) {
                ((MemberInfo)((Object)entry.getValue())).setChecked(NullableNotNullManager.isNotNull((PsiModifierListOwner)((PsiModifierListOwner)entry.getKey())));
            }
        }

        @Override
        protected List<MemberInfo> getClassFields() {
            return this.myClassFields;
        }

        @Override
        protected HashMap<PsiMember, MemberInfo> getFieldsToHashCode() {
            return this.myFieldsToHashCode;
        }

        @Override
        protected HashMap<PsiMember, MemberInfo> getFieldsToNonNull() {
            return this.myFieldsToNonNull;
        }

        @Override
        protected AbstractMemberSelectionPanel<PsiMember, MemberInfo> getEqualsPanel() {
            return this.myEqualsPanel;
        }

        @Override
        protected AbstractMemberSelectionPanel<PsiMember, MemberInfo> getHashCodePanel() {
            return this.myHashCodePanel;
        }

        @Override
        protected AbstractMemberSelectionPanel<PsiMember, MemberInfo> getNonNullPanel() {
            return this.myNonNullPanel;
        }

        @Override
        protected PsiClass getPsiClass() {
            return this.myClass;
        }

        @Override
        protected void updateHashCodeMemberInfos(Collection<MemberInfo> equalsMemberInfos) {
            if (this.myHashCodePanel == null) {
                return;
            }
            ArrayList<Object> hashCodeFields = new ArrayList<Object>();
            for (MemberInfo equalsMemberInfo : equalsMemberInfos) {
                hashCodeFields.add(this.myFieldsToHashCode.get((Object)equalsMemberInfo.getMember()));
            }
            this.myHashCodePanel.getTable().setMemberInfos(hashCodeFields);
        }

        @Override
        protected void updateNonNullMemberInfos(Collection<MemberInfo> equalsMemberInfos) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (MemberInfo equalsMemberInfo : equalsMemberInfos) {
                PsiField field = (PsiField)equalsMemberInfo.getMember();
                if (field.getType() instanceof PsiPrimitiveType) continue;
                list.add(this.myFieldsToNonNull.get((Object)equalsMemberInfo.getMember()));
            }
            this.myNonNullPanel.getTable().setMemberInfos(list);
        }

        private HashMap<PsiMember, MemberInfo> createFieldToMemberInfoMap(boolean checkedByDefault) {
            List<MemberInfo> memberInfos = MemberInfo.extractClassMembers(this.myClass, MEMBER_INFO_FILTER, false);
            HashMap result = new HashMap();
            for (MemberInfo memberInfo : memberInfos) {
                memberInfo.setChecked(checkedByDefault);
                result.put((Object)memberInfo.getMember(), (Object)memberInfo);
            }
            return result;
        }
    }
}

