/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.postfix.templates.StringBasedPostfixTemplate;
import com.intellij.codeInsight.template.postfix.util.JavaPostfixTemplatesUtils;
import com.intellij.openapi.util.Condition;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwitchStatementPostfixTemplate
extends StringBasedPostfixTemplate {
    private static final Condition<PsiElement> SWITCH_TYPE = new Condition<PsiElement>(){

        public boolean value(PsiElement expression) {
            LanguageLevel level;
            PsiFile containingFile;
            PsiClass psiClass;
            if (!(expression instanceof PsiExpression)) {
                return false;
            }
            PsiType type = ((PsiExpression)expression).getType();
            if (type == null) {
                return false;
            }
            if (PsiType.INT.isAssignableFrom(type)) {
                return true;
            }
            if (type instanceof PsiClassType && (psiClass = ((PsiClassType)type).resolve()) != null && psiClass.isEnum()) {
                return true;
            }
            return type.equalsToText("java.lang.String") && (containingFile = expression.getContainingFile()) instanceof PsiJavaFile && (level = ((PsiJavaFile)containingFile).getLanguageLevel()).isAtLeast(LanguageLevel.JDK_1_7);
        }
    };

    public SwitchStatementPostfixTemplate() {
        super("switch", "switch (expr)", JavaPostfixTemplatesUtils.JAVA_PSI_INFO, SWITCH_TYPE);
    }

    @Override
    @Nullable
    public String getTemplateString(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/template/postfix/templates/SwitchStatementPostfixTemplate", "getTemplateString"));
        }
        return "switch ($expr$){\n$END$\n}";
    }
}

