/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ControlFlow;
import com.intellij.codeInspection.dataFlow.instructions.ConditionalGotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FinishElementInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FlushVariableInstruction;
import com.intellij.codeInspection.dataFlow.instructions.GotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ReturnInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Queue;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiveVariablesAnalyzer {
    private final DfaValueFactory myFactory;
    private final Instruction[] myInstructions;
    private final MultiMap<Instruction, Instruction> myForwardMap;
    private final MultiMap<Instruction, Instruction> myBackwardMap;

    public LiveVariablesAnalyzer(ControlFlow flow, DfaValueFactory factory) {
        this.myFactory = factory;
        this.myInstructions = flow.getInstructions();
        this.myForwardMap = this.calcForwardMap();
        this.myBackwardMap = this.calcBackwardMap();
    }

    private List<Instruction> getSuccessors(Instruction i) {
        if (i instanceof GotoInstruction) {
            return Arrays.asList(this.myInstructions[((GotoInstruction)i).getOffset()]);
        }
        int index = i.getIndex();
        if (i instanceof ConditionalGotoInstruction) {
            return Arrays.asList(this.myInstructions[((ConditionalGotoInstruction)i).getOffset()], this.myInstructions[index + 1]);
        }
        if (i instanceof ReturnInstruction) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.myInstructions[index + 1]);
    }

    private MultiMap<Instruction, Instruction> calcBackwardMap() {
        MultiMap result = MultiMap.create();
        for (Instruction instruction : this.myInstructions) {
            for (Instruction next : this.myForwardMap.get((Object)instruction)) {
                result.putValue((Object)next, (Object)instruction);
            }
        }
        return result;
    }

    private MultiMap<Instruction, Instruction> calcForwardMap() {
        MultiMap result = MultiMap.create();
        for (Instruction instruction : this.myInstructions) {
            if (!this.isInterestingInstruction(instruction)) continue;
            block1: for (Instruction next : this.getSuccessors(instruction)) {
                while (true) {
                    if (this.isInterestingInstruction(next)) {
                        result.putValue((Object)instruction, (Object)next);
                        continue block1;
                    }
                    if (next.getIndex() + 1 >= this.myInstructions.length) continue block1;
                    next = this.myInstructions[next.getIndex() + 1];
                }
            }
        }
        return result;
    }

    private boolean isInterestingInstruction(Instruction instruction) {
        if (instruction == this.myInstructions[0]) {
            return true;
        }
        if (instruction instanceof PushInstruction) {
            return ((PushInstruction)instruction).getValue() instanceof DfaVariableValue;
        }
        return instruction instanceof FinishElementInstruction || instruction instanceof FlushVariableInstruction || instruction instanceof GotoInstruction || instruction instanceof ConditionalGotoInstruction || instruction instanceof ReturnInstruction;
    }

    @Nullable
    private Map<FinishElementInstruction, BitSet> findLiveVars() {
        final HashMap result = ContainerUtil.newHashMap();
        boolean ok = this.runDfa(false, new PairFunction<Instruction, BitSet, BitSet>(){

            public BitSet fun(Instruction instruction, BitSet liveVars) {
                block6: {
                    DfaVariableValue variable;
                    block5: {
                        DfaValue value;
                        block7: {
                            if (instruction instanceof FinishElementInstruction) {
                                BitSet set = (BitSet)result.get(instruction);
                                if (set != null) {
                                    set.or(liveVars);
                                    return set;
                                }
                                result.put((FinishElementInstruction)instruction, liveVars);
                            }
                            if (!(instruction instanceof PushInstruction)) break block5;
                            value = ((PushInstruction)instruction).getValue();
                            if (!(value instanceof DfaVariableValue)) break block6;
                            if (!((PushInstruction)instruction).isReferenceWrite()) break block7;
                            liveVars = (BitSet)liveVars.clone();
                            liveVars.clear(value.getID());
                            for (DfaVariableValue var : LiveVariablesAnalyzer.this.myFactory.getVarFactory().getAllQualifiedBy((DfaVariableValue)value)) {
                                liveVars.clear(var.getID());
                            }
                            break block6;
                        }
                        if (liveVars.get(value.getID())) break block6;
                        liveVars = (BitSet)liveVars.clone();
                        liveVars.set(value.getID());
                        break block6;
                    }
                    if (instruction instanceof FlushVariableInstruction && (variable = ((FlushVariableInstruction)instruction).getVariable()) != null) {
                        liveVars = (BitSet)liveVars.clone();
                        liveVars.clear(variable.getID());
                        for (DfaVariableValue var : LiveVariablesAnalyzer.this.myFactory.getVarFactory().getAllQualifiedBy(variable)) {
                            liveVars.clear(var.getID());
                        }
                    }
                }
                return liveVars;
            }
        });
        return ok ? result : null;
    }

    void flushDeadVariablesOnStatementFinish() {
        final Map<FinishElementInstruction, BitSet> liveVars = this.findLiveVars();
        if (liveVars == null) {
            return;
        }
        final MultiMap toFlush = MultiMap.createSet();
        boolean ok = this.runDfa(true, new PairFunction<Instruction, BitSet, BitSet>(){

            @NotNull
            public BitSet fun(Instruction instruction, @NotNull BitSet prevLiveVars) {
                if (prevLiveVars == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prevLiveVars", "com/intellij/codeInspection/dataFlow/LiveVariablesAnalyzer$2", "fun"));
                }
                if (instruction instanceof FinishElementInstruction) {
                    int setBit;
                    BitSet currentlyLive = (BitSet)liveVars.get(instruction);
                    if (currentlyLive == null) {
                        BitSet bitSet = new BitSet();
                        if (bitSet == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/LiveVariablesAnalyzer$2", "fun"));
                        }
                        return bitSet;
                    }
                    int index = 0;
                    while ((setBit = prevLiveVars.nextSetBit(index)) >= 0) {
                        if (!currentlyLive.get(setBit)) {
                            toFlush.putValue((Object)((FinishElementInstruction)instruction), (Object)((DfaVariableValue)LiveVariablesAnalyzer.this.myFactory.getValue(setBit)));
                        }
                        index = setBit + 1;
                    }
                    BitSet bitSet = currentlyLive;
                    if (bitSet == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/LiveVariablesAnalyzer$2", "fun"));
                    }
                    return bitSet;
                }
                BitSet bitSet = prevLiveVars;
                if (bitSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/LiveVariablesAnalyzer$2", "fun"));
                }
                return bitSet;
            }
        });
        if (ok) {
            for (FinishElementInstruction instruction : toFlush.keySet()) {
                instruction.getVarsToFlush().addAll(toFlush.get((Object)instruction));
            }
        }
    }

    private boolean runDfa(boolean forward, PairFunction<Instruction, BitSet, BitSet> handleState) {
        HashSet entryPoints = ContainerUtil.newHashSet();
        if (forward) {
            entryPoints.add(this.myInstructions[0]);
        } else {
            entryPoints.addAll(ContainerUtil.findAll((Object[])this.myInstructions, (Condition)FilteringIterator.instanceOf(ReturnInstruction.class)));
        }
        Queue queue = new Queue(10);
        for (Instruction i : entryPoints) {
            queue.addLast((Object)new InstructionState(i, new BitSet()));
        }
        int limit = this.myForwardMap.size() * 20;
        HashSet processed = ContainerUtil.newHashSet();
        while (!queue.isEmpty()) {
            int steps = processed.size();
            if (steps > limit) {
                return false;
            }
            if (steps % 1024 == 0) {
                ProgressManager.checkCanceled();
            }
            InstructionState state = (InstructionState)((Object)queue.pullFirst());
            Instruction instruction = (Instruction)state.first;
            Collection nextInstructions = forward ? this.myForwardMap.get((Object)instruction) : this.myBackwardMap.get((Object)instruction);
            BitSet nextVars = (BitSet)handleState.fun((Object)instruction, state.second);
            for (Instruction next : nextInstructions) {
                InstructionState nextState = new InstructionState(next, nextVars);
                if (!processed.add(nextState)) continue;
                queue.addLast((Object)nextState);
            }
        }
        return true;
    }

    private static class InstructionState
    extends Pair<Instruction, BitSet> {
        public InstructionState(Instruction first, BitSet second) {
            super((Object)first, (Object)second);
        }
    }
}

