/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.CommonBundle;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.VMDisconnectedException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PopFrameAction
extends DebuggerAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/actions/PopFrameAction", "actionPerformed"));
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        JavaStackFrame stackFrame = PopFrameAction.getStackFrame(e);
        if (stackFrame == null) {
            return;
        }
        try {
            List<PsiStatement> statements;
            DebuggerContextImpl debuggerContext = DebuggerAction.getDebuggerContext(e.getDataContext());
            DebugProcessImpl debugProcess = debuggerContext.getDebugProcess();
            if (debugProcess == null) {
                return;
            }
            if (!"EvaluateFinallyNever".equals(DebuggerSettings.getInstance().EVALUATE_FINALLY_ON_POP_FRAME) && !(statements = PopFrameAction.getFinallyStatements(debuggerContext.getSourcePosition())).isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (PsiStatement statement : statements) {
                    sb.append("\n").append(statement.getText());
                }
                if ("EvaluateFinallyAlways".equals(DebuggerSettings.getInstance().EVALUATE_FINALLY_ON_POP_FRAME)) {
                    PopFrameAction.evaluateAndPop(project, stackFrame, debuggerContext, debugProcess, sb);
                    return;
                }
                int res = ((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.yesNoCancel((String)UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"Debugger.PopFrame")), (String)(DebuggerBundle.message((String)"warning.finally.block.detected", (Object[])new Object[0]) + sb)).project(project)).icon(Messages.getWarningIcon())).yesText(DebuggerBundle.message((String)"button.execute.finally", (Object[])new Object[0]))).noText(DebuggerBundle.message((String)"button.drop.anyway", (Object[])new Object[0]))).cancelText(CommonBundle.message((String)"button.cancel", (Object[])new Object[0])).doNotAsk(new DialogWrapper.DoNotAskOption(){

                    public boolean isToBeShown() {
                        return !"EvaluateFinallyAlways".equals(DebuggerSettings.getInstance().EVALUATE_FINALLY_ON_POP_FRAME) && !"EvaluateFinallyNever".equals(DebuggerSettings.getInstance().EVALUATE_FINALLY_ON_POP_FRAME);
                    }

                    public void setToBeShown(boolean value, int exitCode) {
                        DebuggerSettings.getInstance().EVALUATE_FINALLY_ON_POP_FRAME = !value ? (exitCode == 0 ? "EvaluateFinallyAlways" : "EvaluateFinallyNever") : "EvaluateFinallyAsk";
                    }

                    public boolean canBeHidden() {
                        return true;
                    }

                    public boolean shouldSaveOptionsOnCancel() {
                        return false;
                    }

                    @NotNull
                    public String getDoNotShowMessage() {
                        String string = CommonBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]);
                        if (string == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/actions/PopFrameAction$1", "getDoNotShowMessage"));
                        }
                        return string;
                    }
                })).show();
                switch (res) {
                    case 2: {
                        return;
                    }
                    case 1: {
                        break;
                    }
                    case 0: {
                        PopFrameAction.evaluateAndPop(project, stackFrame, debuggerContext, debugProcess, sb);
                        return;
                    }
                }
            }
            debugProcess.getManagerThread().schedule(debugProcess.createPopFrameCommand(debuggerContext, stackFrame.getStackFrameProxy()));
        }
        catch (NativeMethodException e2) {
            Messages.showMessageDialog((Project)project, (String)DebuggerBundle.message((String)"error.native.method.exception", (Object[])new Object[0]), (String)UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"Debugger.PopFrame")), (Icon)Messages.getErrorIcon());
        }
        catch (InvalidStackFrameException ignored) {
        }
        catch (VMDisconnectedException ignored) {
            // empty catch block
        }
    }

    private static void evaluateAndPop(final Project project, final JavaStackFrame stackFrame, final DebuggerContextImpl debuggerContext, final DebugProcessImpl debugProcess, StringBuilder sb) {
        XDebuggerEvaluator evaluator = stackFrame.getEvaluator();
        if (evaluator != null) {
            evaluator.evaluate((XExpression)XExpressionImpl.fromText(sb.toString(), EvaluationMode.CODE_FRAGMENT), new XDebuggerEvaluator.XEvaluationCallback(){

                public void evaluated(@NotNull XValue result) {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/debugger/actions/PopFrameAction$2", "evaluated"));
                    }
                    debugProcess.getManagerThread().schedule(debugProcess.createPopFrameCommand(debuggerContext, stackFrame.getStackFrameProxy()));
                }

                public void errorOccurred(final @NotNull String errorMessage) {
                    if (errorMessage == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/debugger/actions/PopFrameAction$2", "errorOccurred"));
                    }
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Messages.showMessageDialog((Project)project, (String)DebuggerBundle.message((String)"error.executing.finally", (Object[])new Object[]{errorMessage}), (String)UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"Debugger.PopFrame")), (Icon)Messages.getErrorIcon());
                        }
                    });
                }
            }, stackFrame.getSourcePosition());
        } else {
            Messages.showMessageDialog((Project)project, (String)XDebuggerBundle.message((String)"xdebugger.evaluate.stack.frame.has.not.evaluator", (Object[])new Object[0]), (String)UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"Debugger.PopFrame")), (Icon)Messages.getErrorIcon());
        }
    }

    private static List<PsiStatement> getFinallyStatements(SourcePosition position) {
        ArrayList<PsiStatement> res = new ArrayList<PsiStatement>();
        PsiElement element = position.getFile().findElementAt(position.getOffset());
        PsiTryStatement tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTryStatement.class);
        while (tryStatement != null) {
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (finallyBlock != null) {
                ContainerUtil.addAll(res, (Object[])finallyBlock.getStatements());
            }
            tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)tryStatement, PsiTryStatement.class);
        }
        return res;
    }

    private static JavaStackFrame getStackFrame(AnActionEvent e) {
        StackFrameDescriptorImpl descriptor = PopFrameAction.getSelectedStackFrameDescriptor(e);
        if (descriptor != null) {
            if (descriptor.getFrameProxy().isBottom()) {
                return null;
            }
            return new JavaStackFrame(descriptor, false);
        }
        return PopFrameAction.getSelectedStackFrame(e);
    }

    private static StackFrameProxyImpl getStackFrameProxy(AnActionEvent e) {
        StackFrameDescriptorImpl descriptor = PopFrameAction.getSelectedStackFrameDescriptor(e);
        if (descriptor != null) {
            if (descriptor.getFrameProxy().isBottom()) {
                return null;
            }
            return descriptor.getFrameProxy();
        }
        JavaStackFrame stackFrame = PopFrameAction.getSelectedStackFrame(e);
        if (stackFrame != null) {
            return stackFrame.getStackFrameProxy();
        }
        return null;
    }

    @Nullable
    private static StackFrameDescriptorImpl getSelectedStackFrameDescriptor(AnActionEvent e) {
        NodeDescriptorImpl descriptor;
        DebuggerTreeNodeImpl selectedNode = PopFrameAction.getSelectedNode(e.getDataContext());
        if (selectedNode != null && (descriptor = selectedNode.getDescriptor()) instanceof StackFrameDescriptorImpl) {
            return (StackFrameDescriptorImpl)descriptor;
        }
        return null;
    }

    @Nullable
    private static JavaStackFrame getSelectedStackFrame(AnActionEvent e) {
        Project project = e.getProject();
        if (project != null) {
            XStackFrame frame;
            XDebugSession session = (XDebugSession)e.getData(XDebugSession.DATA_KEY);
            if (session == null) {
                session = XDebuggerManager.getInstance((Project)project).getCurrentSession();
            }
            if (session != null && (frame = session.getCurrentStackFrame()) instanceof JavaStackFrame) {
                StackFrameProxyImpl proxy = ((JavaStackFrame)frame).getStackFrameProxy();
                return !proxy.isBottom() ? (JavaStackFrame)frame : null;
            }
        }
        return null;
    }

    private static boolean isAtBreakpoint(AnActionEvent e) {
        DebuggerTreeNodeImpl parent;
        DebuggerTreeNodeImpl selectedNode = PopFrameAction.getSelectedNode(e.getDataContext());
        if (selectedNode != null && selectedNode.getDescriptor() instanceof StackFrameDescriptorImpl && (parent = selectedNode.getParent()) != null) {
            return ((ThreadDescriptorImpl)parent.getDescriptor()).isAtBreakpoint();
        }
        DebuggerContextImpl debuggerContext = DebuggerAction.getDebuggerContext(e.getDataContext());
        SuspendContextImpl suspendContext = debuggerContext.getSuspendContext();
        return suspendContext != null && debuggerContext.getThreadProxy() == suspendContext.getThread();
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/actions/PopFrameAction", "update"));
        }
        boolean enable = false;
        StackFrameProxyImpl proxy = PopFrameAction.getStackFrameProxy(e);
        if (proxy != null && PopFrameAction.isAtBreakpoint(e)) {
            enable = proxy.getVirtualMachine().canPopFrames();
        }
        if (ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace()) || "DebuggerToolbar".equals(e.getPlace())) {
            e.getPresentation().setEnabled(enable);
        } else {
            e.getPresentation().setVisible(enable);
        }
    }
}

