/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.apiAdapters;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import com.sun.jdi.connect.spi.TransportService;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class TransportServiceWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.apiAdapters.TransportService");
    private final TransportService myTransport;
    private final Class<? extends TransportService> myDelegateClass;
    private static final String SOCKET_TRANSPORT_CLASS = "com.sun.tools.jdi.SocketTransportService";
    private static final String SHMEM_TRANSPORT_CLASS = "com.sun.tools.jdi.SharedMemoryTransportService";

    private TransportServiceWrapper(Class<? extends TransportService> delegateClass) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        this.myDelegateClass = delegateClass;
        Constructor<? extends TransportService> constructor = delegateClass.getDeclaredConstructor(ArrayUtil.EMPTY_CLASS_ARRAY);
        constructor.setAccessible(true);
        this.myTransport = constructor.newInstance(ArrayUtil.EMPTY_OBJECT_ARRAY);
    }

    public TransportService.ListenKey startListening() throws IOException {
        return this.myTransport.startListening();
    }

    public void stopListening(TransportService.ListenKey address) throws IOException {
        this.myTransport.stopListening(address);
    }

    public String transportId() {
        if (SOCKET_TRANSPORT_CLASS.equals(this.myDelegateClass.getName())) {
            return "dt_socket";
        }
        if (SHMEM_TRANSPORT_CLASS.equals(this.myDelegateClass.getName())) {
            return "dt_shmem";
        }
        LOG.error("Unknown service");
        return "<unknown>";
    }

    public static TransportServiceWrapper getTransportService(boolean forceSocketTransport) throws ExecutionException {
        TransportServiceWrapper transport;
        block5: {
            try {
                try {
                    if (forceSocketTransport) {
                        transport = new TransportServiceWrapper(Class.forName(SOCKET_TRANSPORT_CLASS));
                        break block5;
                    }
                    transport = new TransportServiceWrapper(Class.forName(SHMEM_TRANSPORT_CLASS));
                }
                catch (UnsatisfiedLinkError ignored) {
                    transport = new TransportServiceWrapper(Class.forName(SOCKET_TRANSPORT_CLASS));
                }
            }
            catch (Exception e) {
                throw new ExecutionException(e.getClass().getName() + " : " + e.getMessage());
            }
        }
        return transport;
    }
}

