/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.sun.jdi.BooleanValue;

public class IfStatementEvaluator
implements Evaluator {
    private final Evaluator myConditionEvaluator;
    private final Evaluator myThenEvaluator;
    private final Evaluator myElseEvaluator;
    private Modifier myModifier;

    public IfStatementEvaluator(Evaluator conditionEvaluator, Evaluator thenEvaluator, Evaluator elseEvaluator) {
        this.myConditionEvaluator = new DisableGC(conditionEvaluator);
        this.myThenEvaluator = new DisableGC(thenEvaluator);
        this.myElseEvaluator = elseEvaluator == null ? null : new DisableGC(elseEvaluator);
    }

    @Override
    public Modifier getModifier() {
        return this.myModifier;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        Object value = this.myConditionEvaluator.evaluate(context);
        if (!(value instanceof BooleanValue)) {
            throw EvaluateExceptionUtil.BOOLEAN_EXPECTED;
        }
        if (((BooleanValue)value).booleanValue()) {
            value = this.myThenEvaluator.evaluate(context);
            this.myModifier = this.myThenEvaluator.getModifier();
        } else if (this.myElseEvaluator != null) {
            value = this.myElseEvaluator.evaluate(context);
            this.myModifier = this.myElseEvaluator.getModifier();
        } else {
            value = context.getDebugProcess().getVirtualMachineProxy().mirrorOf();
            this.myModifier = null;
        }
        return value;
    }
}

