/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.dupLocator.ExternalizableDuplocatorState;
import com.intellij.lang.Language;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="MultiLanguageDuplocatorSettings", storages={@Storage(file="$APP_CONFIG$/duplocatorSettings.xml")})
public class MultilanguageDuplocatorSettings
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.dupLocator.MultiLanguageDuplocatorSettings");
    private final Map<String, ExternalizableDuplocatorState> mySettingsMap = new HashMap();

    public static MultilanguageDuplocatorSettings getInstance() {
        return (MultilanguageDuplocatorSettings)ServiceManager.getService(MultilanguageDuplocatorSettings.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerState(@NotNull Language language, @NotNull ExternalizableDuplocatorState state) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/dupLocator/MultilanguageDuplocatorSettings", "registerState"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/dupLocator/MultilanguageDuplocatorSettings", "registerState"));
        }
        Map<String, ExternalizableDuplocatorState> map = this.mySettingsMap;
        synchronized (map) {
            this.mySettingsMap.put(language.getDisplayName(), state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalizableDuplocatorState getState(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/dupLocator/MultilanguageDuplocatorSettings", "getState"));
        }
        Map<String, ExternalizableDuplocatorState> map = this.mySettingsMap;
        synchronized (map) {
            return this.mySettingsMap.get(language.getDisplayName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getState() {
        Map<String, ExternalizableDuplocatorState> map = this.mySettingsMap;
        synchronized (map) {
            Element element = new Element("state");
            for (String name : this.mySettingsMap.keySet()) {
                Element child = element.addContent("object");
                element.setAttribute("language", name);
                JDOMExternalizable settingsObject = this.mySettingsMap.get(name);
                try {
                    settingsObject.writeExternal(child);
                }
                catch (WriteExternalException e) {
                    LOG.error((Throwable)e);
                    return null;
                }
            }
            return element;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(Element state) {
        Map<String, ExternalizableDuplocatorState> map = this.mySettingsMap;
        synchronized (map) {
            if (state == null) {
                return;
            }
            for (Element o : state.getChildren("object")) {
                JDOMExternalizable stateObject;
                Element objectElement = o;
                String language = objectElement.getAttributeValue("language");
                if (language == null || (stateObject = (JDOMExternalizable)this.mySettingsMap.get(language)) == null) continue;
                try {
                    stateObject.readExternal(objectElement);
                }
                catch (InvalidDataException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
    }
}

