/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.ui.CustomRenderedTreeNode;
import com.intellij.dvcs.push.ui.TooltipNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsFullCommitDetails;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;

public class CommitNode
extends DefaultMutableTreeNode
implements CustomRenderedTreeNode,
TooltipNode {
    @NotNull
    private final Project myProject;

    public CommitNode(@NotNull Project project, @NotNull VcsFullCommitDetails commit) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/push/ui/CommitNode", "<init>"));
        }
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "com/intellij/dvcs/push/ui/CommitNode", "<init>"));
        }
        super(commit, false);
        this.myProject = project;
    }

    public VcsFullCommitDetails getUserObject() {
        return (VcsFullCommitDetails)super.getUserObject();
    }

    @Override
    public void render(@NotNull ColoredTreeCellRenderer renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/dvcs/push/ui/CommitNode", "render"));
        }
        String subject = StringUtil.shortenTextWithEllipsis((String)this.getUserObject().getSubject(), (int)80, (int)0);
        renderer.append(subject, new SimpleTextAttributes(128, renderer.getForeground()));
    }

    @Override
    public String getTooltip() {
        String hash = DvcsUtil.getShortHash(((Hash)this.getUserObject().getId()).toString());
        String date = DvcsUtil.getDateString((TimedVcsCommit)this.getUserObject());
        String author = this.getUserObject().getAuthor().getName();
        String message = IssueLinkHtmlRenderer.formatTextWithLinks(this.myProject, this.getUserObject().getFullMessage());
        return String.format("%s  %s  by %s\n\n%s", hash, date, author, message);
    }
}

