/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.dvcs.push.ui.VcsLinkListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLinkedText {
    private static final Pattern HREF_PATTERN = Pattern.compile("<a(?:\\s+href\\s*=\\s*[\"']([^\"']*)[\"'])?\\s*>([^<]*)</a>");
    @NotNull
    private String myTextBefore;
    @NotNull
    private String myTextAfter;
    @NotNull
    private String myHandledLink;
    @Nullable
    private final VcsLinkListener myLinkListener;

    public VcsLinkedText(@NotNull String text, @Nullable VcsLinkListener listener) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/dvcs/push/ui/VcsLinkedText", "<init>"));
        }
        Matcher aMatcher = HREF_PATTERN.matcher(text);
        if (aMatcher.find()) {
            this.myTextBefore = text.substring(0, aMatcher.start());
            this.myHandledLink = aMatcher.group(2);
            this.myTextAfter = text.substring(aMatcher.end(), text.length());
        } else {
            this.myTextBefore = text;
            this.myHandledLink = "";
            this.myTextAfter = "";
        }
        this.myLinkListener = listener;
    }

    @NotNull
    public String getTextBefore() {
        String string = this.myTextBefore;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/ui/VcsLinkedText", "getTextBefore"));
        }
        return string;
    }

    @NotNull
    public String getTextAfter() {
        String string = this.myTextAfter;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/ui/VcsLinkedText", "getTextAfter"));
        }
        return string;
    }

    @NotNull
    public String getLinkText() {
        String string = this.myHandledLink;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/ui/VcsLinkedText", "getLinkText"));
        }
        return string;
    }

    public void hyperLinkActivate(@NotNull DefaultMutableTreeNode relatedNode) {
        if (relatedNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relatedNode", "com/intellij/dvcs/push/ui/VcsLinkedText", "hyperLinkActivate"));
        }
        if (this.myLinkListener != null) {
            this.myLinkListener.hyperlinkActivated(relatedNode);
        }
    }
}

