/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.TerminateRemoteProcessDialog;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.GenericProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentListener;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentWithExecutorListener;
import com.intellij.execution.ui.layout.impl.DockableGridContainerFactory;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerAdapter;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.docking.DockContainerFactory;
import com.intellij.ui.docking.DockManager;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunContentManagerImpl
implements RunContentManager,
Disposable {
    public static final Key<Boolean> ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY = Key.create((String)"ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY");
    private static final Logger LOG = Logger.getInstance(RunContentManagerImpl.class);
    private static final Key<RunContentDescriptor> DESCRIPTOR_KEY = Key.create((String)"Descriptor");
    private final Project myProject;
    private final Map<String, ContentManager> myToolwindowIdToContentManagerMap;
    private final Map<RunContentListener, Disposable> myListeners;
    private final LinkedList<String> myToolwindowIdZBuffer;

    public RunContentManagerImpl(@NotNull Project project, @NotNull DockManager dockManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/ui/RunContentManagerImpl", "<init>"));
        }
        if (dockManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dockManager", "com/intellij/execution/ui/RunContentManagerImpl", "<init>"));
        }
        this.myToolwindowIdToContentManagerMap = new THashMap();
        this.myListeners = new THashMap();
        this.myToolwindowIdZBuffer = new LinkedList();
        this.myProject = project;
        DockableGridContainerFactory containerFactory = new DockableGridContainerFactory();
        dockManager.register("runner-grid", (DockContainerFactory)containerFactory);
        Disposer.register((Disposable)this.myProject, (Disposable)containerFactory);
        AppUIUtil.invokeOnEdt(new Runnable(){

            @Override
            public void run() {
                RunContentManagerImpl.this.init();
            }
        }, this.myProject.getDisposed());
    }

    private void init() {
        ToolWindowManagerEx toolWindowManager = ToolWindowManagerEx.getInstanceEx(this.myProject);
        if (toolWindowManager == null) {
            return;
        }
        for (Executor executor : ExecutorRegistry.getInstance().getRegisteredExecutors()) {
            this.registerToolwindow(executor, toolWindowManager);
        }
        toolWindowManager.addToolWindowManagerListener(new ToolWindowManagerAdapter(){

            @Override
            public void stateChanged() {
                if (RunContentManagerImpl.this.myProject.isDisposed()) {
                    return;
                }
                ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)RunContentManagerImpl.this.myProject);
                THashSet currentWindows = new THashSet();
                ContainerUtil.addAll((Collection)currentWindows, (Object[])toolWindowManager.getToolWindowIds());
                RunContentManagerImpl.this.myToolwindowIdZBuffer.retainAll((Collection<?>)currentWindows);
                String activeToolWindowId = toolWindowManager.getActiveToolWindowId();
                if (activeToolWindowId != null && RunContentManagerImpl.this.myToolwindowIdZBuffer.remove(activeToolWindowId)) {
                    RunContentManagerImpl.this.myToolwindowIdZBuffer.addFirst(activeToolWindowId);
                }
            }
        });
    }

    public void dispose() {
    }

    private void registerToolwindow(final @NotNull Executor executor, @NotNull ToolWindowManagerEx toolWindowManager) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/ui/RunContentManagerImpl", "registerToolwindow"));
        }
        if (toolWindowManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowManager", "com/intellij/execution/ui/RunContentManagerImpl", "registerToolwindow"));
        }
        final String toolWindowId = executor.getToolWindowId();
        if (toolWindowManager.getToolWindow(toolWindowId) != null) {
            return;
        }
        ToolWindow toolWindow = toolWindowManager.registerToolWindow(toolWindowId, true, ToolWindowAnchor.BOTTOM, this, true);
        final ContentManager contentManager = toolWindow.getContentManager();
        contentManager.addDataProvider(new DataProvider(){
            private int myInsideGetData = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object getData(String dataId) {
                ++this.myInsideGetData;
                try {
                    if (PlatformDataKeys.HELP_ID.is(dataId)) {
                        String string = executor.getHelpId();
                        return string;
                    }
                    Object object = this.myInsideGetData == 1 ? DataManager.getInstance().getDataContext((Component)contentManager.getComponent()).getData(dataId) : null;
                    return object;
                }
                finally {
                    --this.myInsideGetData;
                }
            }
        });
        toolWindow.setIcon(executor.getToolWindowIcon());
        new ContentManagerWatcher(toolWindow, contentManager);
        contentManager.addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

            public void selectionChanged(ContentManagerEvent event) {
                Content content = event.getContent();
                RunContentManagerImpl.this.getSyncPublisher().contentSelected(content == null ? null : RunContentManagerImpl.getRunContentDescriptorByContent(content), executor);
            }
        });
        this.myToolwindowIdToContentManagerMap.put(toolWindowId, contentManager);
        Disposer.register((Disposable)contentManager, (Disposable)new Disposable(){

            public void dispose() {
                ((ContentManager)RunContentManagerImpl.this.myToolwindowIdToContentManagerMap.remove(toolWindowId)).removeAllContents(true);
                RunContentManagerImpl.this.myToolwindowIdZBuffer.remove(toolWindowId);
            }
        });
        this.myToolwindowIdZBuffer.addLast(toolWindowId);
    }

    private RunContentWithExecutorListener getSyncPublisher() {
        return (RunContentWithExecutorListener)this.myProject.getMessageBus().syncPublisher(TOPIC);
    }

    public void toFrontRunContent(Executor requestor, ProcessHandler handler) {
        RunContentDescriptor descriptor = this.getDescriptorBy(handler, requestor);
        if (descriptor == null) {
            return;
        }
        this.toFrontRunContent(requestor, descriptor);
    }

    public void toFrontRunContent(final Executor requestor, final RunContentDescriptor descriptor) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ContentManager contentManager = RunContentManagerImpl.this.getContentManagerForRunner(requestor);
                Content content = RunContentManagerImpl.getRunContentByDescriptor(contentManager, descriptor);
                if (content != null) {
                    contentManager.setSelectedContent(content);
                    ToolWindowManager.getInstance((Project)RunContentManagerImpl.this.myProject).getToolWindow(requestor.getToolWindowId()).show(null);
                }
            }
        }, this.myProject.getDisposed());
    }

    public void hideRunContent(final @NotNull Executor executor, RunContentDescriptor descriptor) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/ui/RunContentManagerImpl", "hideRunContent"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ToolWindow toolWindow = ToolWindowManager.getInstance((Project)RunContentManagerImpl.this.myProject).getToolWindow(executor.getToolWindowId());
                if (toolWindow != null) {
                    toolWindow.hide(null);
                }
            }
        }, this.myProject.getDisposed());
    }

    @Nullable
    public RunContentDescriptor getSelectedContent(Executor executor) {
        Content selectedContent = this.getContentManagerForRunner(executor).getSelectedContent();
        return selectedContent != null ? RunContentManagerImpl.getRunContentDescriptorByContent(selectedContent) : null;
    }

    @Nullable
    public RunContentDescriptor getSelectedContent() {
        for (String activeWindow : this.myToolwindowIdZBuffer) {
            ContentManager contentManager = this.myToolwindowIdToContentManagerMap.get(activeWindow);
            if (contentManager == null) continue;
            Content selectedContent = contentManager.getSelectedContent();
            if (selectedContent == null) {
                if (contentManager.getContentCount() != 0) break;
                continue;
            }
            return RunContentManagerImpl.getRunContentDescriptorByContent(selectedContent);
        }
        return null;
    }

    public boolean removeRunContent(@NotNull Executor executor, RunContentDescriptor descriptor) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/ui/RunContentManagerImpl", "removeRunContent"));
        }
        ContentManager contentManager = this.getContentManagerForRunner(executor);
        Content content = RunContentManagerImpl.getRunContentByDescriptor(contentManager, descriptor);
        return content != null && contentManager.removeContent(content, true);
    }

    public void showRunContent(@NotNull Executor executor, @NotNull RunContentDescriptor descriptor) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/ui/RunContentManagerImpl", "showRunContent"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/execution/ui/RunContentManagerImpl", "showRunContent"));
        }
        this.showRunContent(executor, descriptor, descriptor.getExecutionId());
    }

    public void showRunContent(final @NotNull Executor executor, final @NotNull RunContentDescriptor descriptor, long executionId) {
        Content content;
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/ui/RunContentManagerImpl", "showRunContent"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/execution/ui/RunContentManagerImpl", "showRunContent"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ContentManager contentManager = this.getContentManagerForRunner(executor);
        RunContentDescriptor oldDescriptor = RunContentManagerImpl.chooseReuseContentForDescriptor(contentManager, descriptor, executionId, descriptor.getDisplayName());
        if (oldDescriptor == null) {
            content = this.createNewContent(contentManager, descriptor, executor);
            Icon icon = descriptor.getIcon();
            content.setIcon(icon == null ? executor.getToolWindowIcon() : icon);
        } else {
            content = oldDescriptor.getAttachedContent();
            LOG.assertTrue(content != null);
            this.getSyncPublisher().contentRemoved(oldDescriptor, executor);
            Disposer.dispose((Disposable)oldDescriptor);
        }
        content.setExecutionId(executionId);
        content.setComponent(descriptor.getComponent());
        content.setPreferredFocusedComponent(descriptor.getPreferredFocusComputable());
        content.putUserData(DESCRIPTOR_KEY, (Object)descriptor);
        final ProcessHandler processHandler = descriptor.getProcessHandler();
        if (processHandler != null) {
            final ProcessAdapter processAdapter = new ProcessAdapter(){

                public void startNotified(ProcessEvent event) {
                    LaterInvocator.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Icon icon = descriptor.getIcon();
                            content.setIcon(icon == null ? executor.getToolWindowIcon() : icon);
                        }
                    });
                }

                public void processTerminated(ProcessEvent event) {
                    LaterInvocator.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Icon icon = descriptor.getIcon();
                            content.setIcon(icon == null ? executor.getDisabledIcon() : IconLoader.getTransparentIcon((Icon)icon));
                        }
                    });
                }
            };
            processHandler.addProcessListener((ProcessListener)processAdapter);
            Disposable disposer = content.getDisposer();
            if (disposer != null) {
                Disposer.register((Disposable)disposer, (Disposable)new Disposable(){

                    public void dispose() {
                        processHandler.removeProcessListener((ProcessListener)processAdapter);
                    }
                });
            }
        }
        content.setDisplayName(descriptor.getDisplayName());
        descriptor.setAttachedContent(content);
        content.getManager().setSelectedContent(content);
        if (!descriptor.isActivateToolWindowWhenAdded()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ToolWindow window = ToolWindowManager.getInstance((Project)RunContentManagerImpl.this.myProject).getToolWindow(executor.getToolWindowId());
                descriptor.getPreferredFocusComputable();
                window.activate(null, descriptor.isAutoFocusContent(), descriptor.isAutoFocusContent());
            }
        }, this.myProject.getDisposed());
    }

    @Deprecated
    @Nullable
    public RunContentDescriptor getReuseContent(Executor requestor, DataContext dataContext) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        return this.getReuseContent(requestor, (RunContentDescriptor)GenericProgramRunner.CONTENT_TO_REUSE_DATA_KEY.getData(dataContext));
    }

    @Deprecated
    @Nullable
    public RunContentDescriptor getReuseContent(Executor requestor, @Nullable RunContentDescriptor contentToReuse) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        if (contentToReuse != null) {
            return contentToReuse;
        }
        return RunContentManagerImpl.chooseReuseContentForDescriptor(this.getContentManagerForRunner(requestor), null, 0L, null);
    }

    @Nullable
    public RunContentDescriptor getReuseContent(Executor requestor, @NotNull ExecutionEnvironment executionEnvironment) {
        if (executionEnvironment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executionEnvironment", "com/intellij/execution/ui/RunContentManagerImpl", "getReuseContent"));
        }
        return this.getReuseContent(executionEnvironment);
    }

    @Nullable
    public RunContentDescriptor getReuseContent(@NotNull ExecutionEnvironment executionEnvironment) {
        if (executionEnvironment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executionEnvironment", "com/intellij/execution/ui/RunContentManagerImpl", "getReuseContent"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        RunContentDescriptor contentToReuse = executionEnvironment.getContentToReuse();
        if (contentToReuse != null) {
            return contentToReuse;
        }
        ContentManager contentManager = this.getContentManagerForRunner(executionEnvironment.getExecutor());
        return RunContentManagerImpl.chooseReuseContentForDescriptor(contentManager, null, executionEnvironment.getExecutionId(), executionEnvironment.toString());
    }

    public RunContentDescriptor findContentDescriptor(Executor requestor, ProcessHandler handler) {
        return this.getDescriptorBy(handler, requestor);
    }

    public void showRunContent(@NotNull Executor info, @NotNull RunContentDescriptor descriptor, @Nullable RunContentDescriptor contentToReuse) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/execution/ui/RunContentManagerImpl", "showRunContent"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/execution/ui/RunContentManagerImpl", "showRunContent"));
        }
        RunContentManagerImpl.copyContentAndBehavior(descriptor, contentToReuse);
        this.showRunContent(info, descriptor, descriptor.getExecutionId());
    }

    public static void copyContentAndBehavior(@NotNull RunContentDescriptor descriptor, @Nullable RunContentDescriptor contentToReuse) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/execution/ui/RunContentManagerImpl", "copyContentAndBehavior"));
        }
        if (contentToReuse != null) {
            Content attachedContent = contentToReuse.getAttachedContent();
            if (attachedContent != null && attachedContent.isValid()) {
                descriptor.setAttachedContent(attachedContent);
            }
            if (contentToReuse.isReuseToolWindowActivation()) {
                descriptor.setActivateToolWindowWhenAdded(contentToReuse.isActivateToolWindowWhenAdded());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static RunContentDescriptor chooseReuseContentForDescriptor(@NotNull ContentManager contentManager, @Nullable RunContentDescriptor descriptor, long executionId, @Nullable String string) {
        if (contentManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentManager", "com/intellij/execution/ui/RunContentManagerImpl", "chooseReuseContentForDescriptor"));
        }
        Content content = null;
        if (descriptor != null) {
            if (descriptor.isContentReuseProhibited()) {
                return null;
            }
            Content attachedContent = descriptor.getAttachedContent();
            if (attachedContent != null && attachedContent.isValid() && contentManager.getIndexOfContent(attachedContent) != -1) {
                content = attachedContent;
            }
        }
        if (content == null) {
            void preferredName;
            content = RunContentManagerImpl.getContentFromManager(contentManager, (String)preferredName, executionId);
        }
        if (content == null || !RunContentManagerImpl.isTerminated(content) || content.getExecutionId() == executionId && executionId != 0L) {
            return null;
        }
        RunContentDescriptor oldDescriptor = RunContentManagerImpl.getRunContentDescriptorByContent(content);
        if (oldDescriptor != null && !oldDescriptor.isContentReuseProhibited()) {
            return oldDescriptor;
        }
        return null;
    }

    @Nullable
    private static Content getContentFromManager(ContentManager contentManager, @Nullable String preferredName, long executionId) {
        ArrayList<Content> contents = new ArrayList<Content>(Arrays.asList(contentManager.getContents()));
        Content first = contentManager.getSelectedContent();
        if (first != null && contents.remove(first)) {
            contents.add(0, first);
        }
        if (preferredName != null) {
            for (Content c : contents) {
                if (!RunContentManagerImpl.canReuseContent(c, executionId) || !preferredName.equals(c.getDisplayName())) continue;
                return c;
            }
        }
        for (Content c : contents) {
            if (!RunContentManagerImpl.canReuseContent(c, executionId)) continue;
            return c;
        }
        return null;
    }

    private static boolean canReuseContent(Content c, long executionId) {
        return c != null && !c.isPinned() && RunContentManagerImpl.isTerminated(c) && (c.getExecutionId() != executionId || executionId == 0L);
    }

    @NotNull
    private ContentManager getContentManagerForRunner(Executor executor) {
        ContentManager contentManager = this.myToolwindowIdToContentManagerMap.get(executor.getToolWindowId());
        if (contentManager == null) {
            LOG.error("Runner " + executor.getId() + " is not registered");
        }
        ContentManager contentManager2 = contentManager;
        if (contentManager2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/RunContentManagerImpl", "getContentManagerForRunner"));
        }
        return contentManager2;
    }

    private Content createNewContent(ContentManager contentManager, RunContentDescriptor descriptor, Executor executor) {
        String processDisplayName = descriptor.getDisplayName();
        Content content = ContentFactory.SERVICE.getInstance().createContent(descriptor.getComponent(), processDisplayName, true);
        content.putUserData(DESCRIPTOR_KEY, (Object)descriptor);
        content.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
        contentManager.addContent(content);
        new CloseListener(content, executor);
        return content;
    }

    private static boolean isTerminated(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/execution/ui/RunContentManagerImpl", "isTerminated"));
        }
        RunContentDescriptor descriptor = RunContentManagerImpl.getRunContentDescriptorByContent(content);
        ProcessHandler processHandler = descriptor == null ? null : descriptor.getProcessHandler();
        return processHandler == null || processHandler.isProcessTerminated();
    }

    @Nullable
    private static RunContentDescriptor getRunContentDescriptorByContent(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/execution/ui/RunContentManagerImpl", "getRunContentDescriptorByContent"));
        }
        return (RunContentDescriptor)content.getUserData(DESCRIPTOR_KEY);
    }

    @Nullable
    public ToolWindow getToolWindowByDescriptor(@NotNull RunContentDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/execution/ui/RunContentManagerImpl", "getToolWindowByDescriptor"));
        }
        for (Map.Entry<String, ContentManager> entry : this.myToolwindowIdToContentManagerMap.entrySet()) {
            if (RunContentManagerImpl.getRunContentByDescriptor(entry.getValue(), descriptor) == null) continue;
            return ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(entry.getKey());
        }
        return null;
    }

    @Nullable
    private static Content getRunContentByDescriptor(@NotNull ContentManager contentManager, @NotNull RunContentDescriptor descriptor) {
        if (contentManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentManager", "com/intellij/execution/ui/RunContentManagerImpl", "getRunContentByDescriptor"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/execution/ui/RunContentManagerImpl", "getRunContentByDescriptor"));
        }
        for (Content content : contentManager.getContents()) {
            if (!descriptor.equals(content.getUserData(DESCRIPTOR_KEY))) continue;
            return content;
        }
        return null;
    }

    public void addRunContentListener(final @NotNull RunContentListener listener, final Executor executor) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/execution/ui/RunContentManagerImpl", "addRunContentListener"));
        }
        Disposable disposable = Disposer.newDisposable();
        this.myProject.getMessageBus().connect(disposable).subscribe(TOPIC, (Object)new RunContentWithExecutorListener(){

            public void contentSelected(@Nullable RunContentDescriptor descriptor, @NotNull Executor executor2) {
                if (executor2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor2", "com/intellij/execution/ui/RunContentManagerImpl$11", "contentSelected"));
                }
                if (executor2.equals(executor)) {
                    listener.contentSelected(descriptor);
                }
            }

            public void contentRemoved(@Nullable RunContentDescriptor descriptor, @NotNull Executor executor2) {
                if (executor2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor2", "com/intellij/execution/ui/RunContentManagerImpl$11", "contentRemoved"));
                }
                if (executor2.equals(executor)) {
                    listener.contentRemoved(descriptor);
                }
            }
        });
        this.myListeners.put(listener, disposable);
    }

    public void addRunContentListener(final @NotNull RunContentListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/execution/ui/RunContentManagerImpl", "addRunContentListener"));
        }
        Disposable disposable = Disposer.newDisposable();
        this.myProject.getMessageBus().connect(disposable).subscribe(TOPIC, (Object)new RunContentWithExecutorListener(){

            public void contentSelected(@Nullable RunContentDescriptor descriptor, @NotNull Executor executor) {
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/ui/RunContentManagerImpl$12", "contentSelected"));
                }
                listener.contentSelected(descriptor);
            }

            public void contentRemoved(@Nullable RunContentDescriptor descriptor, @NotNull Executor executor) {
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/ui/RunContentManagerImpl$12", "contentRemoved"));
                }
                listener.contentRemoved(descriptor);
            }
        });
        this.myListeners.put(listener, disposable);
    }

    @NotNull
    public List<RunContentDescriptor> getAllDescriptors() {
        if (this.myToolwindowIdToContentManagerMap.isEmpty()) {
            List<RunContentDescriptor> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/RunContentManagerImpl", "getAllDescriptors"));
            }
            return list;
        }
        SmartList descriptors = new SmartList();
        for (String id : this.myToolwindowIdToContentManagerMap.keySet()) {
            for (Content content : this.myToolwindowIdToContentManagerMap.get(id).getContents()) {
                RunContentDescriptor descriptor = RunContentManagerImpl.getRunContentDescriptorByContent(content);
                if (descriptor == null) continue;
                descriptors.add(descriptor);
            }
        }
        SmartList smartList = descriptors;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ui/RunContentManagerImpl", "getAllDescriptors"));
        }
        return smartList;
    }

    public void removeRunContentListener(RunContentListener listener) {
        Disposable disposable = this.myListeners.remove(listener);
        if (disposable != null) {
            Disposer.dispose((Disposable)disposable);
        }
    }

    @Nullable
    private RunContentDescriptor getDescriptorBy(ProcessHandler handler, Executor runnerInfo) {
        for (Content content : this.getContentManagerForRunner(runnerInfo).getContents()) {
            RunContentDescriptor runContentDescriptor = RunContentManagerImpl.getRunContentDescriptorByContent(content);
            assert (runContentDescriptor != null);
            if (runContentDescriptor.getProcessHandler() != handler) continue;
            return runContentDescriptor;
        }
        return null;
    }

    private void waitForProcess(final RunContentDescriptor descriptor, final boolean modal) {
        final ProcessHandler processHandler = descriptor.getProcessHandler();
        final boolean killable = !modal && processHandler instanceof KillableProcess && ((KillableProcess)processHandler).canKillProcess();
        String title = ExecutionBundle.message((String)"terminating.process.progress.title", (Object[])new Object[]{descriptor.getDisplayName()});
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, title, true){
            {
                super(x0, x1, x2);
                if (killable) {
                    String cancelText = ExecutionBundle.message((String)"terminating.process.progress.kill", (Object[])new Object[0]);
                    this.setCancelText(cancelText);
                    this.setCancelTooltipText(cancelText);
                }
            }

            public boolean isConditionalModal() {
                return modal;
            }

            public boolean shouldStartInBackground() {
                return !modal;
            }

            public void run(final @NotNull ProgressIndicator progressIndicator) {
                if (progressIndicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/execution/ui/RunContentManagerImpl$13", "run"));
                }
                final Semaphore semaphore = new Semaphore();
                semaphore.down();
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ProcessHandler processHandler = descriptor.getProcessHandler();
                        try {
                            if (processHandler != null) {
                                processHandler.waitFor();
                            }
                        }
                        finally {
                            semaphore.up();
                        }
                    }
                });
                progressIndicator.setText(ExecutionBundle.message((String)"waiting.for.vm.detach.progress.text", (Object[])new Object[0]));
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        while (true) {
                            if (progressIndicator.isCanceled() || !progressIndicator.isRunning()) break;
                            try {
                                2 var1_1 = this;
                                synchronized (var1_1) {
                                    this.wait(2000L);
                                    continue;
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                continue;
                            }
                            break;
                        }
                        semaphore.up();
                    }
                });
                semaphore.waitFor();
            }

            public void onCancel() {
                if (killable && !processHandler.isProcessTerminated()) {
                    ((KillableProcess)processHandler).killProcess();
                }
            }
        });
    }

    private class CloseListener
    extends ContentManagerAdapter
    implements ProjectManagerListener {
        private Content myContent;
        private final Executor myExecutor;

        private CloseListener(@NotNull Content content, Executor executor) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/execution/ui/RunContentManagerImpl$CloseListener", "<init>"));
            }
            if (executor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/ui/RunContentManagerImpl$CloseListener", "<init>"));
            }
            this.myContent = content;
            content.getManager().addContentManagerListener((ContentManagerListener)this);
            ProjectManager.getInstance().addProjectManagerListener((ProjectManagerListener)this);
            this.myExecutor = executor;
        }

        public void contentRemoved(ContentManagerEvent event) {
            Content content = event.getContent();
            if (content == this.myContent) {
                this.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispose() {
            if (this.myContent == null) {
                return;
            }
            Content content = this.myContent;
            try {
                RunContentDescriptor descriptor = RunContentManagerImpl.getRunContentDescriptorByContent(content);
                RunContentManagerImpl.this.getSyncPublisher().contentRemoved(descriptor, this.myExecutor);
                if (descriptor != null) {
                    Disposer.dispose((Disposable)descriptor);
                }
            }
            finally {
                content.getManager().removeContentManagerListener((ContentManagerListener)this);
                ProjectManager.getInstance().removeProjectManagerListener((ProjectManagerListener)this);
                content.release();
                this.myContent = null;
            }
        }

        public void contentRemoveQuery(ContentManagerEvent event) {
            boolean canClose;
            if (event.getContent() == this.myContent && !(canClose = this.closeQuery(false))) {
                event.consume();
            }
        }

        public void projectOpened(Project project) {
        }

        public void projectClosed(Project project) {
            if (this.myContent != null && project == RunContentManagerImpl.this.myProject) {
                this.myContent.getManager().removeContent(this.myContent, true);
                this.dispose();
            }
        }

        public boolean canCloseProject(Project project) {
            if (project != RunContentManagerImpl.this.myProject) {
                return true;
            }
            if (this.myContent == null) {
                return true;
            }
            boolean canClose = this.closeQuery(true);
            if (canClose) {
                this.myContent.getManager().removeContent(this.myContent, true);
                this.myContent = null;
            }
            return canClose;
        }

        public void projectClosing(Project project) {
        }

        private boolean closeQuery(boolean modal) {
            boolean destroyProcess;
            RunContentDescriptor descriptor = RunContentManagerImpl.getRunContentDescriptorByContent(this.myContent);
            if (descriptor == null) {
                return true;
            }
            ProcessHandler processHandler = descriptor.getProcessHandler();
            if (processHandler == null || processHandler.isProcessTerminated() || processHandler.isProcessTerminating()) {
                return true;
            }
            if (processHandler.isSilentlyDestroyOnClose() || Boolean.TRUE.equals(processHandler.getUserData(ProcessHandler.SILENTLY_DESTROY_ON_CLOSE))) {
                destroyProcess = true;
            } else {
                boolean useDefault = Boolean.TRUE.equals(processHandler.getUserData(ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY));
                TerminateRemoteProcessDialog.TerminateOption option = new TerminateRemoteProcessDialog.TerminateOption(processHandler.detachIsDefault(), useDefault);
                int rc = TerminateRemoteProcessDialog.show(RunContentManagerImpl.this.myProject, descriptor.getDisplayName(), option);
                if (rc != 0) {
                    return false;
                }
                boolean bl = destroyProcess = !option.isToBeShown();
            }
            if (destroyProcess) {
                processHandler.destroyProcess();
            } else {
                processHandler.detachProcess();
            }
            RunContentManagerImpl.this.waitForProcess(descriptor, modal);
            return true;
        }
    }
}

