/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.AppearanceOptionsTopHitProvider;
import com.intellij.ide.ui.DaemonCodeAnalyzerOptionDescription;
import com.intellij.ide.ui.EditorOptionDescription;
import com.intellij.ide.ui.OptionsTopHitProvider;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorOptionsTopHitProvider
extends OptionsTopHitProvider {
    private static final Collection<BooleanOptionDescription> ourOptions = Collections.unmodifiableCollection(Arrays.asList(EditorOptionsTopHitProvider.editor("Mouse: " + EditorOptionsTopHitProvider.messageApp("checkbox.honor.camelhumps.words.settings.on.double.click"), "IS_MOUSE_CLICK_SELECTION_HONORS_CAMEL_WORDS"), EditorOptionsTopHitProvider.editor("Mouse: " + EditorOptionsTopHitProvider.messageApp(SystemInfo.isMac ? "checkbox.enable.ctrl.mousewheel.changes.font.size.macos" : "checkbox.enable.ctrl.mousewheel.changes.font.size"), "IS_WHEEL_FONTCHANGE_ENABLED"), EditorOptionsTopHitProvider.editor("Mouse: " + EditorOptionsTopHitProvider.messageApp("checkbox.enable.drag.n.drop.functionality.in.editor"), "IS_DND_ENABLED"), EditorOptionsTopHitProvider.editor("Virtual Space: " + EditorOptionsTopHitProvider.messageApp("checkbox.show.all.softwraps"), "IS_ALL_SOFTWRAPS_SHOWN"), EditorOptionsTopHitProvider.editor("Virtual Space: " + EditorOptionsTopHitProvider.messageApp("checkbox.allow.placement.of.caret.after.end.of.line"), "IS_VIRTUAL_SPACE"), EditorOptionsTopHitProvider.editor("Virtual Space: " + EditorOptionsTopHitProvider.messageApp("checkbox.allow.placement.of.caret.inside.tabs"), "IS_CARET_INSIDE_TABS"), EditorOptionsTopHitProvider.editor("Virtual Space: " + EditorOptionsTopHitProvider.messageApp("checkbox.show.virtual.space.at.file.bottom"), "ADDITIONAL_PAGE_AT_BOTTOM"), EditorOptionsTopHitProvider.editorUI("Appearance: " + EditorOptionsTopHitProvider.messageIde("checkbox.use.antialiased.font.in.editor"), "ANTIALIASING_IN_EDITOR"), EditorOptionsTopHitProvider.editorApp("Appearance: Caret blinking", "IS_CARET_BLINKING"), EditorOptionsTopHitProvider.editorApp("Appearance: " + EditorOptionsTopHitProvider.messageApp("checkbox.use.block.caret"), "IS_BLOCK_CURSOR"), EditorOptionsTopHitProvider.editorApp("Appearance: Show right margin", "IS_RIGHT_MARGIN_SHOWN"), EditorOptionsTopHitProvider.editorApp("Appearance: " + EditorOptionsTopHitProvider.messageApp("checkbox.show.line.numbers"), "ARE_LINE_NUMBERS_SHOWN"), EditorOptionsTopHitProvider.editorCode("Appearance: " + EditorOptionsTopHitProvider.messageApp("checkbox.show.method.separators"), "SHOW_METHOD_SEPARATORS"), EditorOptionsTopHitProvider.editorApp("Appearance: " + EditorOptionsTopHitProvider.messageApp("checkbox.show.whitespaces"), "IS_WHITESPACES_SHOWN"), EditorOptionsTopHitProvider.editorApp("Appearance: Show leading whitespaces", "IS_LEADING_WHITESPACES_SHOWN"), EditorOptionsTopHitProvider.editorApp("Appearance: Show inner whitespaces", "IS_INNER_WHITESPACES_SHOWN"), EditorOptionsTopHitProvider.editorApp("Appearance: Show trailing whitespaces", "IS_TRAILING_WHITESPACES_SHOWN"), EditorOptionsTopHitProvider.editorApp("Appearance: Show vertical indent guides", "IS_INDENT_GUIDES_SHOWN"), EditorOptionsTopHitProvider.editorCode("Appearance: " + EditorOptionsTopHitProvider.messageApp("checkbox.show.small.icons.in.gutter"), "SHOW_SMALL_ICONS_IN_GUTTER"), EditorOptionsTopHitProvider.option("Appearance: " + EditorOptionsTopHitProvider.messageApp("checkbox.show.code.folding.outline"), "IS_FOLDING_OUTLINE_SHOWN", "editor.preferences.folding"), EditorOptionsTopHitProvider.editorTabs("Tabs: " + EditorOptionsTopHitProvider.messageApp("checkbox.editor.tabs.in.single.row"), "SCROLL_TAB_LAYOUT_IN_EDITOR"), EditorOptionsTopHitProvider.editorTabs("Tabs: " + EditorOptionsTopHitProvider.messageApp("checkbox.hide.file.extension.in.editor.tabs"), "HIDE_KNOWN_EXTENSION_IN_TABS"), EditorOptionsTopHitProvider.editorTabs("Tabs: Show directory in editor tabs for non-unique filenames", "SHOW_DIRECTORY_FOR_NON_UNIQUE_FILENAMES"), EditorOptionsTopHitProvider.editorTabs("Tabs: " + EditorOptionsTopHitProvider.messageApp("checkbox.editor.tabs.show.close.button"), "SHOW_CLOSE_BUTTON"), EditorOptionsTopHitProvider.editorTabs("Tabs: " + EditorOptionsTopHitProvider.messageApp("checkbox.mark.modified.tabs.with.asterisk"), "MARK_MODIFIED_TABS_WITH_ASTERISK"), EditorOptionsTopHitProvider.editorTabs("Tabs: " + EditorOptionsTopHitProvider.messageApp("checkbox.show.tabs.tooltips"), "SHOW_TABS_TOOLTIPS"), EditorOptionsTopHitProvider.editorTabs("Tabs: " + EditorOptionsTopHitProvider.messageApp("radio.close.non.modified.files.first"), "CLOSE_NON_MODIFIED_FILES_FIRST")));

    @Override
    @NotNull
    public Collection<BooleanOptionDescription> getOptions(@Nullable Project project) {
        Collection<BooleanOptionDescription> collection = ourOptions;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/EditorOptionsTopHitProvider", "getOptions"));
        }
        return collection;
    }

    @Override
    public String getId() {
        return "editor";
    }

    static BooleanOptionDescription editor(String option, String field) {
        return EditorOptionsTopHitProvider.option(option, field, "preferences.editor");
    }

    static BooleanOptionDescription editorTabs(String option, String field) {
        return AppearanceOptionsTopHitProvider.option(option, field, "editor.preferences.tabs");
    }

    static BooleanOptionDescription option(String option, String field, String configurableId) {
        return new EditorOptionDescription(field, option, configurableId);
    }

    static BooleanOptionDescription editorApp(String option, String field) {
        return EditorOptionsTopHitProvider.option(option, field, "editor.preferences.appearance");
    }

    static BooleanOptionDescription editorUI(String option, String field) {
        return AppearanceOptionsTopHitProvider.option(option, field, "editor.preferences.appearance");
    }

    static BooleanOptionDescription editorCode(String option, String field) {
        return new DaemonCodeAnalyzerOptionDescription(field, option, "editor.preferences.appearance");
    }
}

