/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextBorder;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.Gray;
import com.intellij.util.ui.JBInsets;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.JTextComponent;

public class DarculaTextFieldUI
extends BasicTextFieldUI {
    private static final Icon SEARCH_ICON = IconLoader.findIcon((String)"/com/intellij/ide/ui/laf/darcula/icons/search.png", DarculaTextFieldUI.class, (boolean)true);
    private static final Icon SEARCH_WITH_HISTORY_ICON = IconLoader.findIcon((String)"/com/intellij/ide/ui/laf/darcula/icons/searchWithHistory.png", DarculaTextFieldUI.class, (boolean)true);
    private static final Icon CLEAR_ICON = IconLoader.findIcon((String)"/com/intellij/ide/ui/laf/darcula/icons/clear.png", DarculaTextFieldUI.class, (boolean)true);
    private final JTextField myTextField;
    protected JLabel myClearIcon;
    protected JLabel myRecentIcon;

    public DarculaTextFieldUI(JTextField textField) {
        this.myTextField = textField;
    }

    public static ComponentUI createUI(final JComponent c) {
        final DarculaTextFieldUI ui = new DarculaTextFieldUI((JTextField)c);
        c.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                c.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                c.repaint();
            }
        });
        c.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (ui.getComponent() != null && DarculaTextFieldUI.isSearchField(c)) {
                    if (ui.getActionUnder(e) != null) {
                        c.setCursor(Cursor.getPredefinedCursor(12));
                    } else {
                        c.setCursor(Cursor.getPredefinedCursor(2));
                    }
                }
            }
        });
        c.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SearchAction action;
                if (DarculaTextFieldUI.isSearchField(c) && (action = ui.getActionUnder(e)) != null) {
                    switch (action) {
                        case POPUP: {
                            ui.showSearchPopup();
                            break;
                        }
                        case CLEAR: {
                            ((JTextField)c).setText("");
                        }
                    }
                    e.consume();
                }
            }
        });
        return ui;
    }

    protected void showSearchPopup() {
        Object value = this.getComponent().getClientProperty("JTextField.Search.FindPopup");
        if (value instanceof JPopupMenu) {
            JPopupMenu popup = (JPopupMenu)value;
            popup.show(this.getComponent(), this.getSearchIconCoord().x, this.getComponent().getHeight());
        }
    }

    private boolean hasText() {
        JTextComponent component = this.getComponent();
        return component != null && !StringUtil.isEmpty((String)component.getText());
    }

    private SearchAction getActionUnder(MouseEvent e) {
        Point point = new Point(e.getX() - 8, e.getY() - 8);
        return point.distance(this.getSearchIconCoord()) <= 8.0 ? SearchAction.POPUP : (this.hasText() && point.distance(this.getClearIconCoord()) <= 8.0 ? SearchAction.CLEAR : null);
    }

    protected Rectangle getDrawingRect() {
        JTextField c = this.myTextField;
        JBInsets i = JBInsets.create((Insets)c.getInsets());
        int x = i.right - 4 - 16;
        int y = i.top - 3;
        int w = c.getWidth() - i.width() + 32 + 14 - 5;
        int h = c.getBounds().height - i.height() + 8 - 3;
        if (h % 2 == 1) {
            ++h;
        }
        return new Rectangle(x, y, w, h);
    }

    protected Point getSearchIconCoord() {
        Rectangle r = this.getDrawingRect();
        return new Point(r.x + 3, r.y + (r.height - 16) / 2 + 1);
    }

    protected Point getClearIconCoord() {
        Rectangle r = this.getDrawingRect();
        return new Point(r.x + r.width - 16 - 2, r.y + (r.height - 16) / 2);
    }

    @Override
    protected void paintBackground(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        JTextComponent c = this.getComponent();
        Container parent = c.getParent();
        Rectangle r = this.getDrawingRect();
        if (c.isOpaque() && parent != null) {
            g.setColor(parent.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        GraphicsConfig config = new GraphicsConfig((Graphics)g);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        Border border = c.getBorder();
        if (DarculaTextFieldUI.isSearchField(c)) {
            Icon searchIcon;
            g.setColor(c.getBackground());
            boolean noBorder = c.getClientProperty("JTextField.Search.noBorderRing") == Boolean.TRUE;
            int radius = r.height - 1;
            g.fillRoundRect(r.x, r.y + 1, r.width, r.height - (noBorder ? 2 : 1), radius, radius);
            g.setColor((Color)(c.isEnabled() ? Gray._100 : new Color(0x535353)));
            if (!noBorder) {
                if (c.hasFocus()) {
                    DarculaUIUtil.paintSearchFocusRing(g, r);
                } else {
                    g.drawRoundRect(r.x, r.y, r.width, r.height - 1, radius, radius);
                }
            }
            Point p = this.getSearchIconCoord();
            Icon icon = searchIcon = this.getComponent().getClientProperty("JTextField.Search.FindPopup") instanceof JPopupMenu ? UIManager.getIcon("TextField.darcula.searchWithHistory.icon") : UIManager.getIcon("TextField.darcula.search.icon");
            if (searchIcon == null) {
                searchIcon = IconLoader.findIcon((String)"/com/intellij/ide/ui/laf/icons/search.png", DarculaTextFieldUI.class, (boolean)true);
            }
            searchIcon.paintIcon(null, g, p.x, p.y);
            if (this.hasText()) {
                p = this.getClearIconCoord();
                Icon clearIcon = UIManager.getIcon("TextField.darcula.clear.icon");
                if (clearIcon == null) {
                    clearIcon = IconLoader.findIcon((String)"/com/intellij/ide/ui/laf/icons/clear.png", DarculaTextFieldUI.class, (boolean)true);
                }
                clearIcon.paintIcon(null, g, p.x, p.y);
            }
        } else if (border instanceof DarculaTextBorder) {
            if (c.isEnabled() && c.isEditable()) {
                g.setColor(c.getBackground());
            }
            int width = c.getWidth();
            int height = c.getHeight();
            Insets i = border.getBorderInsets(c);
            if (c.hasFocus()) {
                g.fillRoundRect(i.left - 5, i.top - 2, width - i.right - i.left + 10, height - i.top - i.bottom + 6, 5, 5);
            } else {
                g.fillRect(i.left - 5, i.top - 2, width - i.right - i.left + 12, height - i.top - i.bottom + 6);
            }
        } else {
            super.paintBackground(g);
        }
        config.restore();
    }

    @Override
    protected void paintSafely(Graphics g) {
        this.paintBackground(g);
        super.paintSafely(g);
    }

    public static boolean isSearchField(Component c) {
        return c instanceof JTextField && "search".equals(((JTextField)c).getClientProperty("JTextField.variant"));
    }

    public static boolean isSearchFieldWithHistoryPopup(Component c) {
        return DarculaTextFieldUI.isSearchField(c) && ((JTextField)c).getClientProperty("JTextField.Search.FindPopup") instanceof JPopupMenu;
    }

    private static enum SearchAction {
        POPUP,
        CLEAR;

    }
}

