/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.navigation.ChooseByNameContributorEx;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashSet;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class DefaultFileNavigationContributor
implements ChooseByNameContributorEx,
DumbAware {
    @NotNull
    public String[] getNames(Project project, boolean includeNonProjectItems) {
        if (FileBasedIndex.ourEnableTracingOfKeyHashToVirtualFileMapping) {
            final THashSet names = new THashSet(1000);
            IdFilter filter = IdFilter.getProjectIdFilter((Project)project, (boolean)includeNonProjectItems);
            this.processNames(new Processor<String>(){

                public boolean process(String s) {
                    names.add((Object)s);
                    return true;
                }
            }, FindSymbolParameters.searchScopeFor(project, includeNonProjectItems), filter);
            if (IdFilter.LOG.isDebugEnabled()) {
                IdFilter.LOG.debug("All names retrieved2:" + names.size());
            }
            String[] stringArray = ArrayUtil.toStringArray((Collection)names);
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/DefaultFileNavigationContributor", "getNames"));
            }
            return stringArray;
        }
        String[] stringArray = FilenameIndex.getAllFilenames(project);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/DefaultFileNavigationContributor", "getNames"));
        }
        return stringArray;
    }

    @NotNull
    public NavigationItem[] getItemsByName(String name, String pattern, Project project, boolean includeNonProjectItems) {
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        this.processElementsWithName(name, (Processor<NavigationItem>)processor, FindSymbolParameters.wrap(pattern, project, includeNonProjectItems));
        NavigationItem[] navigationItemArray = (NavigationItem[])processor.toArray((Object[])new NavigationItem[processor.getResults().size()]);
        if (navigationItemArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/DefaultFileNavigationContributor", "getItemsByName"));
        }
        return navigationItemArray;
    }

    @Override
    public void processNames(final @NotNull Processor<String> processor, @NotNull GlobalSearchScope scope, IdFilter filter) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/ide/util/gotoByName/DefaultFileNavigationContributor", "processNames"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/ide/util/gotoByName/DefaultFileNavigationContributor", "processNames"));
        }
        long started = System.currentTimeMillis();
        FileBasedIndex.getInstance().processAllKeys(FilenameIndex.NAME, (Processor)new Processor<String>(){

            public boolean process(String s) {
                return processor.process((Object)s);
            }
        }, scope, filter);
        if (IdFilter.LOG.isDebugEnabled()) {
            IdFilter.LOG.debug("All names retrieved:" + (System.currentTimeMillis() - started));
        }
    }

    @Override
    public void processElementsWithName(@NotNull String name, @NotNull Processor<NavigationItem> processor, @NotNull FindSymbolParameters parameters) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ide/util/gotoByName/DefaultFileNavigationContributor", "processElementsWithName"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/ide/util/gotoByName/DefaultFileNavigationContributor", "processElementsWithName"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/ide/util/gotoByName/DefaultFileNavigationContributor", "processElementsWithName"));
        }
        String completePattern = parameters.getCompletePattern();
        boolean includeDirs = completePattern.endsWith("/") || completePattern.endsWith("\\") || completePattern.startsWith("/") || completePattern.startsWith("\\");
        boolean result = FilenameIndex.processFilesByName(name, includeDirs, processor, parameters.getSearchScope(), parameters.getProject(), parameters.getIdFilter());
        if (!result && includeDirs) {
            FilenameIndex.processFilesByName(name, false, processor, parameters.getSearchScope(), parameters.getProject(), parameters.getIdFilter());
        }
    }
}

