/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.editor.selection;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.JsonParserDefinition;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.StringLiteralLexer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;

public class JsonStringLiteralSelectionHandler
extends ExtendWordSelectionHandlerBase {
    @Override
    public boolean canSelect(PsiElement e) {
        return JsonParserDefinition.STRING_LITERALS.contains(e.getNode().getElementType());
    }

    @Override
    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        PsiElement parent = e.getParent();
        assert (parent instanceof JsonStringLiteral);
        IElementType type = e.getNode().getElementType();
        StringLiteralLexer lexer = new StringLiteralLexer(type == JsonElementTypes.SINGLE_QUOTED_STRING ? (char)'\'' : '\"', type, false, "/", false, false);
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        SelectWordUtil.addWordHonoringEscapeSequences(editorText, e.getTextRange(), cursorOffset, (Lexer)lexer, result);
        result.add(ElementManipulators.getValueTextRange((PsiElement)parent).shiftRight(parent.getTextOffset()));
        return result;
    }
}

