/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditReadOnlyListener;
import com.intellij.openapi.editor.ex.LineIterator;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashMap;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MockDocument
implements DocumentEx {
    private final Map myUserData = new HashMap();
    private StringBuffer myText = new StringBuffer();
    private long myModStamp = LocalTimeCounter.currentTime();

    public MockDocument() {
    }

    public MockDocument(String text) {
        this.myText.append(text);
    }

    @NotNull
    public String getText() {
        String string = this.myText.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockDocument", "getText"));
        }
        return string;
    }

    @NotNull
    public String getText(@NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/mock/MockDocument", "getText"));
        }
        String string = range.substring(this.myText.toString());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockDocument", "getText"));
        }
        return string;
    }

    @Override
    public void replaceText(@NotNull CharSequence chars, long newModificationStamp) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/mock/MockDocument", "replaceText"));
        }
        this.myText = new StringBuffer();
        this.myText.append(chars);
        this.myModStamp = newModificationStamp;
    }

    @Override
    public int getListenersCount() {
        return 0;
    }

    public CharSequence textToCharArray() {
        return this.getText();
    }

    @NotNull
    public char[] getChars() {
        char[] cArray = this.getText().toCharArray();
        if (cArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockDocument", "getChars"));
        }
        return cArray;
    }

    @NotNull
    public CharSequence getCharsSequence() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockDocument", "getCharsSequence"));
        }
        return string;
    }

    @NotNull
    public CharSequence getImmutableCharSequence() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockDocument", "getImmutableCharSequence"));
        }
        return string;
    }

    public int getTextLength() {
        return this.myText.length();
    }

    public int getLineCount() {
        return 1;
    }

    public int getLineNumber(int offset) {
        return 0;
    }

    public int getLineStartOffset(int line) {
        return 0;
    }

    public int getLineEndOffset(int line) {
        return this.myText.length();
    }

    public void insertString(int offset, @NotNull CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/mock/MockDocument", "insertString"));
        }
        this.myText.insert(offset, s);
    }

    public void deleteString(int startOffset, int endOffset) {
        this.myText.delete(startOffset, endOffset);
    }

    public void replaceString(int startOffset, int endOffset, @NotNull CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/mock/MockDocument", "replaceString"));
        }
        this.myText.replace(startOffset, endOffset, ((Object)s).toString());
        this.myModStamp = LocalTimeCounter.currentTime();
    }

    @Override
    public void moveText(int srcStart, int srcEnd, int dstOffset) {
        throw new UnsupportedOperationException();
    }

    public boolean isWritable() {
        return false;
    }

    public long getModificationStamp() {
        return this.myModStamp;
    }

    public void fireReadOnlyModificationAttempt() {
    }

    public void addDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/mock/MockDocument", "addDocumentListener"));
        }
    }

    public void addDocumentListener(@NotNull DocumentListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/mock/MockDocument", "addDocumentListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/mock/MockDocument", "addDocumentListener"));
        }
    }

    public void removeDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/mock/MockDocument", "removeDocumentListener"));
        }
    }

    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset) {
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockDocument", "createRangeMarker"));
        }
        return null;
    }

    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset, boolean surviveOnExternalChange) {
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockDocument", "createRangeMarker"));
        }
        return null;
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/mock/MockDocument", "addPropertyChangeListener"));
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/mock/MockDocument", "removePropertyChangeListener"));
        }
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/mock/MockDocument", "getUserData"));
        }
        return (T)this.myUserData.get(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, T value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/mock/MockDocument", "putUserData"));
        }
        this.myUserData.put(key, value);
    }

    @Override
    public void setStripTrailingSpacesEnabled(boolean isEnabled) {
    }

    public int getLineSeparatorLength(int line) {
        return 0;
    }

    @Override
    @NotNull
    public LineIterator createLineIterator() {
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockDocument", "createLineIterator"));
        }
        return null;
    }

    @Override
    public void setModificationStamp(long modificationStamp) {
        this.myModStamp = modificationStamp;
    }

    public void setReadOnly(boolean isReadOnly) {
    }

    public RangeMarker getRangeGuard(int start, int end) {
        return null;
    }

    public void startGuardedBlockChecking() {
    }

    public void stopGuardedBlockChecking() {
    }

    @NotNull
    public RangeMarker createGuardedBlock(int startOffset, int endOffset) {
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockDocument", "createGuardedBlock"));
        }
        return null;
    }

    public void removeGuardedBlock(@NotNull RangeMarker block) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/mock/MockDocument", "removeGuardedBlock"));
        }
    }

    public RangeMarker getOffsetGuard(int offset) {
        return null;
    }

    @Override
    public void addEditReadOnlyListener(@NotNull EditReadOnlyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/mock/MockDocument", "addEditReadOnlyListener"));
        }
    }

    @Override
    public void removeEditReadOnlyListener(@NotNull EditReadOnlyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/mock/MockDocument", "removeEditReadOnlyListener"));
        }
    }

    @Override
    public void suppressGuardedExceptions() {
    }

    @Override
    public void unSuppressGuardedExceptions() {
    }

    @Override
    public boolean isInEventsHandling() {
        return false;
    }

    @Override
    public void clearLineModificationFlags() {
    }

    @Override
    public boolean removeRangeMarker(@NotNull RangeMarkerEx rangeMarker) {
        if (rangeMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/intellij/mock/MockDocument", "removeRangeMarker"));
        }
        return false;
    }

    @Override
    public void registerRangeMarker(@NotNull RangeMarkerEx rangeMarker, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        if (rangeMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/intellij/mock/MockDocument", "registerRangeMarker"));
        }
    }

    @Override
    public boolean isInBulkUpdate() {
        return false;
    }

    @Override
    public void setInBulkUpdate(boolean value) {
    }

    public void setCyclicBufferSize(int bufferSize) {
    }

    public void setText(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/mock/MockDocument", "setText"));
        }
    }

    @NotNull
    public RangeMarker createRangeMarker(@NotNull TextRange textRange) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/mock/MockDocument", "createRangeMarker"));
        }
        RangeMarker rangeMarker = this.createRangeMarker(textRange.getStartOffset(), textRange.getEndOffset());
        if (rangeMarker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockDocument", "createRangeMarker"));
        }
        return rangeMarker;
    }

    @Override
    @NotNull
    public List<RangeMarker> getGuardedBlocks() {
        List<RangeMarker> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockDocument", "getGuardedBlocks"));
        }
        return list;
    }

    @Override
    public boolean processRangeMarkers(@NotNull Processor<RangeMarker> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/mock/MockDocument", "processRangeMarkers"));
        }
        return false;
    }

    @Override
    public boolean processRangeMarkersOverlappingWith(int start, int end, @NotNull Processor<RangeMarker> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/mock/MockDocument", "processRangeMarkersOverlappingWith"));
        }
        return false;
    }
}

