/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.LineTooltipRenderer;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.codeInsight.hint.TooltipRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.ErrorStripTooltipRendererProvider;
import com.intellij.openapi.editor.ex.ErrorStripeEvent;
import com.intellij.openapi.editor.ex.ErrorStripeListener;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.impl.MarkupModelImpl;
import com.intellij.openapi.editor.impl.TrafficTooltipRenderer;
import com.intellij.openapi.editor.markup.ErrorStripeRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.impl.EditorWindowHolder;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import gnu.trove.TIntIntHashMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ScrollBarUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorMarkupModelImpl
extends MarkupModelImpl
implements EditorMarkupModel {
    private static final TooltipGroup ERROR_STRIPE_TOOLTIP_GROUP = new TooltipGroup("ERROR_STRIPE_TOOLTIP_GROUP", 0);
    private static final Icon ERRORS_FOUND_ICON = AllIcons.General.ErrorsFound;
    private static final int ERROR_ICON_WIDTH = ERRORS_FOUND_ICON.getIconWidth();
    private static final int ERROR_ICON_HEIGHT = ERRORS_FOUND_ICON.getIconHeight();
    private static final int PREFERRED_WIDTH = ERROR_ICON_WIDTH + 3;
    private final EditorImpl myEditor;
    private ErrorStripeRenderer myErrorStripeRenderer;
    private final List<ErrorStripeListener> myErrorMarkerListeners;
    private boolean dimensionsAreValid;
    private int myEditorScrollbarTop;
    private int myEditorTargetHeight;
    private int myEditorSourceHeight;
    private ProperTextRange myDirtyYPositions;
    private static final ProperTextRange WHOLE_DOCUMENT = new ProperTextRange(0, 0);
    @NotNull
    private ErrorStripTooltipRendererProvider myTooltipRendererProvider;
    private int myMinMarkHeight;
    private static final int myPreviewLines = 5;
    private static final int myCachePreviewLines = 100;
    private LightweightHint myEditorPreviewHint;
    private final EditorFragmentRenderer myEditorFragmentRenderer;
    private int myRowAdjuster;
    private int myWheelAccumulator;
    private static final Dimension STRIPE_BUTTON_PREFERRED_SIZE = new Dimension(ERROR_ICON_WIDTH + 4, ERROR_ICON_HEIGHT + 4);

    EditorMarkupModelImpl(@NotNull EditorImpl editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl", "<init>"));
        }
        super(editor.getDocument());
        this.myErrorMarkerListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myEditorScrollbarTop = -1;
        this.myEditorTargetHeight = -1;
        this.myEditorSourceHeight = -1;
        this.myTooltipRendererProvider = new BasicTooltipRendererProvider();
        this.myMinMarkHeight = 3;
        this.myEditorPreviewHint = null;
        this.myRowAdjuster = 0;
        this.myWheelAccumulator = 0;
        this.myEditor = editor;
        this.myEditorFragmentRenderer = new EditorFragmentRenderer();
    }

    private int offsetToLine(int offset, Document document) {
        if (offset < 0) {
            return 0;
        }
        if (offset > document.getTextLength()) {
            return document.getLineCount();
        }
        return this.myEditor.offsetToVisualLine(offset);
    }

    public void repaintVerticalScrollBar() {
        this.myEditor.getVerticalScrollBar().repaint();
    }

    void recalcEditorDimensions() {
        EditorImpl.MyScrollBar scrollBar = this.myEditor.getVerticalScrollBar();
        int scrollBarHeight = Math.max(0, scrollBar.getSize().height);
        this.myEditorScrollbarTop = scrollBar.getDecScrollButtonHeight();
        assert (this.myEditorScrollbarTop >= 0);
        int editorScrollbarBottom = scrollBar.getIncScrollButtonHeight();
        this.myEditorTargetHeight = scrollBarHeight - this.myEditorScrollbarTop - editorScrollbarBottom;
        this.myEditorSourceHeight = this.myEditor.getPreferredHeight();
        this.dimensionsAreValid = scrollBarHeight != 0;
    }

    public void repaintTrafficLightIcon() {
        MyErrorPanel errorPanel = this.getErrorPanel();
        if (errorPanel != null) {
            errorPanel.myErrorStripeButton.repaint();
            errorPanel.repaintTrafficTooltip();
        }
    }

    private boolean showToolTipByMouseMove(MouseEvent e) {
        int visualY;
        boolean isVisible;
        if (this.myEditor.getVisibleLineCount() == 0) {
            return false;
        }
        MouseEvent me = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), 0, e.getY() + 1, e.getClickCount(), e.isPopupTrigger());
        int visualLine = this.getVisualLineByEvent(e);
        Rectangle area = this.myEditor.getScrollingModel().getVisibleArea();
        boolean bl = isVisible = area.contains(area.x, visualY = this.myEditor.getLineHeight() * visualLine) && this.myWheelAccumulator == 0;
        if (IJSwingUtilities.findParentByInterface(this.myEditor.getComponent(), EditorWindowHolder.class) == null || isVisible || !UISettings.getInstance().SHOW_EDITOR_TOOLTIP) {
            THashSet highlighters = new THashSet();
            this.getNearestHighlighters(this, me.getY(), (Collection<RangeHighlighter>)highlighters);
            this.getNearestHighlighters((MarkupModelEx)DocumentMarkupModel.forDocument(this.myEditor.getDocument(), this.getEditor().getProject(), true), me.getY(), (Collection<RangeHighlighter>)highlighters);
            if (highlighters.isEmpty()) {
                return false;
            }
            int y = e.getY();
            RangeHighlighter nearest = this.getNearestRangeHighlighter(e);
            if (nearest != null) {
                ProperTextRange range = this.offsetsToYPositions(nearest.getStartOffset(), nearest.getEndOffset());
                int eachStartY = range.getStartOffset();
                int eachEndY = range.getEndOffset();
                y = eachStartY + (eachEndY - eachStartY) / 2;
            }
            me = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), me.getX(), y + 1, e.getClickCount(), e.isPopupTrigger());
            TooltipRenderer bigRenderer = this.myTooltipRendererProvider.calcTooltipRenderer((Collection<RangeHighlighter>)highlighters);
            if (bigRenderer != null) {
                this.showTooltip(me, bigRenderer, EditorMarkupModelImpl.createHint(me));
                return true;
            }
            return false;
        }
        float rowRatio = (float)visualLine / (float)(this.myEditor.getVisibleLineCount() - 1);
        int y = this.myRowAdjuster != 0 ? (int)(rowRatio * (float)this.myEditor.getVerticalScrollBar().getHeight()) : me.getY();
        me = new MouseEvent(me.getComponent(), me.getID(), me.getWhen(), me.getModifiers(), me.getX(), y, me.getClickCount(), me.isPopupTrigger());
        ArrayList<RangeHighlighterEx> highlighters = new ArrayList<RangeHighlighterEx>();
        this.collectRangeHighlighters(this, visualLine, highlighters);
        this.collectRangeHighlighters((MarkupModelEx)DocumentMarkupModel.forDocument(this.myEditor.getDocument(), this.getEditor().getProject(), true), visualLine, highlighters);
        this.myEditorFragmentRenderer.update(visualLine, highlighters, me.isAltDown());
        this.myEditorFragmentRenderer.show(this.myEditor, me.getPoint(), true, ERROR_STRIPE_TOOLTIP_GROUP, EditorMarkupModelImpl.createHint(me));
        return true;
    }

    private static HintHint createHint(MouseEvent me) {
        return new HintHint(me).setAwtTooltip(true).setPreferredPosition(Balloon.Position.atLeft).setBorderInsets(new Insets(1, 1, 1, 1)).setShowImmediately(true).setAnimationEnabled(false);
    }

    private int getVisualLineByEvent(MouseEvent e) {
        return this.fitLineToEditor(this.myEditor.offsetToVisualLine(this.yPositionToOffset(e.getY() + this.myWheelAccumulator, true)));
    }

    private int fitLineToEditor(int visualLine) {
        return Math.max(0, Math.min(this.myEditor.getVisibleLineCount() - 1, visualLine));
    }

    private int getOffset(int visualLine, boolean startLine) {
        int logicalLine = this.myEditor.visualToLogicalPosition((VisualPosition)new VisualPosition((int)visualLine, (int)0), (boolean)true).line;
        return startLine ? this.myEditor.getDocument().getLineStartOffset(logicalLine) : this.myEditor.getDocument().getLineEndOffset(logicalLine);
    }

    private void collectRangeHighlighters(MarkupModelEx markupModel, int visualLine, final Collection<RangeHighlighterEx> highlighters) {
        final int startOffset = this.getOffset(this.fitLineToEditor(visualLine - 5), true);
        final int endOffset = this.getOffset(this.fitLineToEditor(visualLine + 5), false);
        markupModel.processRangeHighlightersOverlappingWith(startOffset, endOffset, (Processor<? super RangeHighlighterEx>)new Processor<RangeHighlighterEx>(){

            public boolean process(RangeHighlighterEx highlighter) {
                if (!highlighter.getEditorFilter().avaliableIn((Editor)EditorMarkupModelImpl.this.myEditor)) {
                    return true;
                }
                if (highlighter.getErrorStripeMarkColor() != null && highlighter.getStartOffset() < endOffset && highlighter.getEndOffset() > startOffset) {
                    highlighters.add(highlighter);
                }
                return true;
            }
        });
    }

    @Nullable
    private RangeHighlighter getNearestRangeHighlighter(MouseEvent e) {
        ArrayList<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>();
        this.getNearestHighlighters(this, e.getY(), highlighters);
        this.getNearestHighlighters((MarkupModelEx)DocumentMarkupModel.forDocument(this.myEditor.getDocument(), this.myEditor.getProject(), true), e.getY(), highlighters);
        RangeHighlighter nearestMarker = null;
        int yPos = 0;
        for (RangeHighlighter highlighter : highlighters) {
            int newYPos = this.offsetsToYPositions(highlighter.getStartOffset(), highlighter.getEndOffset()).getStartOffset();
            if (nearestMarker != null && Math.abs(yPos - e.getY()) <= Math.abs(newYPos - e.getY())) continue;
            nearestMarker = highlighter;
            yPos = newYPos;
        }
        return nearestMarker;
    }

    private void getNearestHighlighters(MarkupModelEx markupModel, final int scrollBarY, final Collection<RangeHighlighter> nearest) {
        int startOffset = this.yPositionToOffset(scrollBarY - this.myMinMarkHeight, true);
        int endOffset = this.yPositionToOffset(scrollBarY + this.myMinMarkHeight, false);
        markupModel.processRangeHighlightersOverlappingWith(startOffset, endOffset, (Processor<? super RangeHighlighterEx>)new Processor<RangeHighlighterEx>(){

            public boolean process(RangeHighlighterEx highlighter) {
                ProperTextRange range;
                if (!highlighter.getEditorFilter().avaliableIn((Editor)EditorMarkupModelImpl.this.myEditor)) {
                    return true;
                }
                if (highlighter.getErrorStripeMarkColor() != null && scrollBarY >= (range = EditorMarkupModelImpl.this.offsetsToYPositions(highlighter.getStartOffset(), highlighter.getEndOffset())).getStartOffset() - EditorMarkupModelImpl.this.myMinMarkHeight * 2 && scrollBarY <= range.getEndOffset() + EditorMarkupModelImpl.this.myMinMarkHeight * 2) {
                    nearest.add(highlighter);
                }
                return true;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doClick(MouseEvent e) {
        int offset;
        RangeHighlighter marker = this.getNearestRangeHighlighter(e);
        LogicalPosition logicalPositionToScroll = null;
        if (marker == null) {
            if (this.myEditorPreviewHint == null) return;
            logicalPositionToScroll = this.myEditor.visualToLogicalPosition(new VisualPosition(this.myEditorFragmentRenderer.myStartVisualLine, 0));
            offset = this.myEditor.getDocument().getLineStartOffset(logicalPositionToScroll.line);
        } else {
            offset = marker.getStartOffset();
        }
        DocumentEx doc = this.myEditor.getDocument();
        if (doc.getLineCount() > 0 && this.myEditorPreviewHint == null) {
            int lineEnd = doc.getLineEndOffset(doc.getLineNumber(offset));
            this.myEditor.getCaretModel().moveToOffset(lineEnd);
        }
        this.myEditor.getCaretModel().removeSecondaryCarets();
        this.myEditor.getCaretModel().moveToOffset(offset);
        this.myEditor.getSelectionModel().removeSelection();
        ScrollingModelEx scrollingModel = this.myEditor.getScrollingModel();
        scrollingModel.disableAnimation();
        if (logicalPositionToScroll != null) {
            int lineY = this.myEditor.logicalPositionToXY((LogicalPosition)logicalPositionToScroll).y;
            int relativePopupOffset = this.myEditorFragmentRenderer.myRelativeY;
            scrollingModel.scrollVertically(lineY - relativePopupOffset);
        } else {
            scrollingModel.scrollToCaret(ScrollType.CENTER);
        }
        scrollingModel.enableAnimation();
        if (marker == null) return;
        this.fireErrorMarkerClicked(marker, e);
    }

    @Override
    public void setErrorStripeVisible(boolean val) {
        if (val) {
            this.myEditor.getVerticalScrollBar().setPersistentUI((ScrollBarUI)((Object)new MyErrorPanel()));
        } else {
            this.myEditor.getVerticalScrollBar().setPersistentUI(ButtonlessScrollBarUI.createNormal());
        }
    }

    @Nullable
    private MyErrorPanel getErrorPanel() {
        ScrollBarUI ui = this.myEditor.getVerticalScrollBar().getUI();
        return ui instanceof MyErrorPanel ? (MyErrorPanel)((Object)ui) : null;
    }

    @Override
    public void setErrorPanelPopupHandler(@NotNull PopupHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl", "setErrorPanelPopupHandler"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        MyErrorPanel errorPanel = this.getErrorPanel();
        if (errorPanel != null) {
            errorPanel.setPopupHandler(handler);
        }
    }

    @Override
    public void setErrorStripTooltipRendererProvider(@NotNull ErrorStripTooltipRendererProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl", "setErrorStripTooltipRendererProvider"));
        }
        this.myTooltipRendererProvider = provider;
    }

    @Override
    @NotNull
    public ErrorStripTooltipRendererProvider getErrorStripTooltipRendererProvider() {
        ErrorStripTooltipRendererProvider errorStripTooltipRendererProvider = this.myTooltipRendererProvider;
        if (errorStripTooltipRendererProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl", "getErrorStripTooltipRendererProvider"));
        }
        return errorStripTooltipRendererProvider;
    }

    @Override
    @NotNull
    public Editor getEditor() {
        EditorImpl editorImpl = this.myEditor;
        if (editorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl", "getEditor"));
        }
        return editorImpl;
    }

    @Override
    public void setErrorStripeRenderer(@NotNull ErrorStripeRenderer renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl", "setErrorStripeRenderer"));
        }
        EditorMarkupModelImpl.assertIsDispatchThread();
        if (this.myErrorStripeRenderer instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)this.myErrorStripeRenderer));
        }
        this.myErrorStripeRenderer = renderer;
        this.myEditor.getVerticalScrollBar().updateUI();
        this.repaintVerticalScrollBar();
    }

    private static void assertIsDispatchThread() {
        ApplicationManagerEx.getApplicationEx().assertIsDispatchThread();
    }

    @Override
    public ErrorStripeRenderer getErrorStripeRenderer() {
        return this.myErrorStripeRenderer;
    }

    @Override
    public void dispose() {
        MyErrorPanel panel = this.getErrorPanel();
        if (panel != null) {
            panel.uninstallListeners();
        }
        if (this.myErrorStripeRenderer instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)this.myErrorStripeRenderer));
        }
        this.myErrorStripeRenderer = null;
        super.dispose();
    }

    void repaint(int startOffset, int endOffset) {
        ProperTextRange range = this.offsetsToYPositions(startOffset, endOffset);
        this.markDirtied(range);
        if (startOffset == -1 || endOffset == -1) {
            this.myDirtyYPositions = WHOLE_DOCUMENT;
        }
        this.myEditor.getVerticalScrollBar().repaint(0, range.getStartOffset(), PREFERRED_WIDTH, range.getLength() + this.myMinMarkHeight);
    }

    private boolean isMirrored() {
        return this.myEditor.isMirrored();
    }

    private void showTooltip(MouseEvent e, TooltipRenderer tooltipObject, @NotNull HintHint hintHint) {
        if (hintHint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintHint", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl", "showTooltip"));
        }
        TooltipController tooltipController = TooltipController.getInstance();
        tooltipController.showTooltipByMouseMove(this.myEditor, new RelativePoint(e), tooltipObject, this.myEditor.getVerticalScrollbarOrientation() == 1, ERROR_STRIPE_TOOLTIP_GROUP, hintHint);
    }

    private void fireErrorMarkerClicked(RangeHighlighter marker, MouseEvent e) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ErrorStripeEvent event = new ErrorStripeEvent(this.getEditor(), e, marker);
        for (ErrorStripeListener listener : this.myErrorMarkerListeners) {
            listener.errorMarkerClicked(event);
        }
    }

    @Override
    public void addErrorMarkerListener(@NotNull ErrorStripeListener listener, @NotNull Disposable parent) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl", "addErrorMarkerListener"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl", "addErrorMarkerListener"));
        }
        ContainerUtil.add((Object)listener, this.myErrorMarkerListeners, (Disposable)parent);
    }

    public void markDirtied(@NotNull ProperTextRange yPositions) {
        if (yPositions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "yPositions", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl", "markDirtied"));
        }
        if (this.myDirtyYPositions != WHOLE_DOCUMENT) {
            int start = Math.max(0, yPositions.getStartOffset() - this.myEditor.getLineHeight());
            int end = this.myEditorScrollbarTop + this.myEditorTargetHeight == 0 ? yPositions.getEndOffset() + this.myEditor.getLineHeight() : Math.min(this.myEditorScrollbarTop + this.myEditorTargetHeight, yPositions.getEndOffset() + this.myEditor.getLineHeight());
            ProperTextRange adj = new ProperTextRange(start, Math.max(end, start));
            this.myDirtyYPositions = this.myDirtyYPositions == null ? adj : this.myDirtyYPositions.union((TextRange)adj);
        }
        this.myEditorScrollbarTop = 0;
        this.myEditorSourceHeight = 0;
        this.myEditorTargetHeight = 0;
        this.dimensionsAreValid = false;
    }

    @Override
    public void setMinMarkHeight(int minMarkHeight) {
        this.myMinMarkHeight = minMarkHeight;
    }

    @Override
    public boolean isErrorStripeVisible() {
        return this.getErrorPanel() != null;
    }

    @NotNull
    private ProperTextRange offsetsToYPositions(int start, int end) {
        int startY;
        int lineCount;
        if (!this.dimensionsAreValid) {
            this.recalcEditorDimensions();
        }
        DocumentEx document = this.myEditor.getDocument();
        int startLineNumber = end == -1 ? 0 : this.offsetToLine(start, document);
        int editorTargetHeight = Math.max(0, this.myEditorTargetHeight);
        if (this.myEditorSourceHeight < editorTargetHeight) {
            lineCount = 0;
            startY = this.myEditorScrollbarTop + startLineNumber * this.myEditor.getLineHeight();
        } else {
            lineCount = this.myEditorSourceHeight / this.myEditor.getLineHeight();
            startY = this.myEditorScrollbarTop + (int)((float)startLineNumber / (float)lineCount * (float)editorTargetHeight);
        }
        int endLineNumber = this.offsetToLine(end, document);
        int endY = end == -1 || start == -1 ? Math.min(this.myEditorSourceHeight, editorTargetHeight) : (start == end || this.offsetToLine(start, document) == endLineNumber ? startY : (this.myEditorSourceHeight < editorTargetHeight ? this.myEditorScrollbarTop + endLineNumber * this.myEditor.getLineHeight() : this.myEditorScrollbarTop + (int)((float)endLineNumber / (float)lineCount * (float)editorTargetHeight)));
        if (endY < startY) {
            endY = startY;
        }
        ProperTextRange properTextRange = new ProperTextRange(startY, endY);
        if (properTextRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl", "offsetsToYPositions"));
        }
        return properTextRange;
    }

    private int yPositionToOffset(int y, boolean beginLine) {
        VisualPosition visual;
        if (!this.dimensionsAreValid) {
            this.recalcEditorDimensions();
        }
        int safeY = Math.max(0, y - this.myEditorScrollbarTop);
        if (this.myEditorSourceHeight < this.myEditorTargetHeight) {
            visual = this.myEditor.xyToVisualPosition(new Point(0, safeY));
        } else {
            float fraction = Math.max(0.0f, Math.min(1.0f, (float)safeY / (float)this.myEditorTargetHeight));
            int lineCount = this.myEditorSourceHeight / this.myEditor.getLineHeight();
            visual = new VisualPosition((int)(fraction * (float)lineCount), 0);
        }
        int line = this.myEditor.visualToLogicalPosition((VisualPosition)visual).line;
        DocumentEx document = this.myEditor.getDocument();
        if (line < 0) {
            return 0;
        }
        if (line >= document.getLineCount()) {
            return document.getTextLength();
        }
        FoldingModelImpl foldingModel = this.myEditor.getFoldingModel();
        if (beginLine) {
            int offset = document.getLineStartOffset(line);
            FoldRegion startCollapsed = foldingModel.getCollapsedRegionAtOffset(offset);
            return startCollapsed != null ? Math.min(offset, startCollapsed.getStartOffset()) : offset;
        }
        int offset = document.getLineEndOffset(line);
        FoldRegion startCollapsed = foldingModel.getCollapsedRegionAtOffset(offset);
        return startCollapsed != null ? Math.max(offset, startCollapsed.getEndOffset()) : offset;
    }

    private class EditorFragmentRenderer
    implements TooltipRenderer {
        private int myVisualLine;
        private boolean myShowInstantly;
        private final List<RangeHighlighterEx> myHighlighters = new ArrayList<RangeHighlighterEx>();
        private BufferedImage myCacheLevel1;
        private BufferedImage myCacheLevel2;
        private int myCacheStartLine;
        private int myCacheEndLine;
        private int myStartVisualLine;
        private int myEndVisualLine;
        private int myRelativeY;
        private boolean myDelayed = false;
        private boolean isDirty = false;
        private final AtomicReference<Point> myPointHolder = new AtomicReference();
        private final AtomicReference<HintHint> myHintHolder = new AtomicReference();

        private EditorFragmentRenderer() {
            this.update(-1, Collections.<RangeHighlighterEx>emptyList(), false);
        }

        void update(int visualLine, Collection<RangeHighlighterEx> rangeHighlighters, boolean showInstantly) {
            this.myVisualLine = visualLine;
            this.myShowInstantly = showInstantly;
            this.myHighlighters.clear();
            if (this.myVisualLine == -1) {
                return;
            }
            int oldStartLine = this.myStartVisualLine;
            int oldEndLine = this.myEndVisualLine;
            this.myStartVisualLine = EditorMarkupModelImpl.this.fitLineToEditor(this.myVisualLine - 5);
            this.myEndVisualLine = EditorMarkupModelImpl.this.fitLineToEditor(this.myVisualLine + 5);
            this.isDirty |= oldStartLine != this.myStartVisualLine || oldEndLine != this.myEndVisualLine;
            for (RangeHighlighterEx rangeHighlighter : rangeHighlighters) {
                this.myHighlighters.add(rangeHighlighter);
            }
            Collections.sort(this.myHighlighters, new Comparator<RangeHighlighterEx>(){

                @Override
                public int compare(@NotNull RangeHighlighterEx ex1, @NotNull RangeHighlighterEx ex2) {
                    if (ex1 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ex1", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$EditorFragmentRenderer$1", "compare"));
                    }
                    if (ex2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ex2", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$EditorFragmentRenderer$1", "compare"));
                    }
                    LogicalPosition startPos1 = EditorMarkupModelImpl.this.myEditor.offsetToLogicalPosition(ex1.getAffectedAreaStartOffset());
                    LogicalPosition startPos2 = EditorMarkupModelImpl.this.myEditor.offsetToLogicalPosition(ex2.getAffectedAreaStartOffset());
                    if (startPos1.line != startPos2.line) {
                        return 0;
                    }
                    return startPos1.column - startPos2.column;
                }
            });
        }

        @Override
        public LightweightHint show(@NotNull Editor editor, @NotNull Point p, boolean alignToRight, @NotNull TooltipGroup group, @NotNull HintHint hintInfo) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$EditorFragmentRenderer", "show"));
            }
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$EditorFragmentRenderer", "show"));
            }
            if (group == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$EditorFragmentRenderer", "show"));
            }
            if (hintInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintInfo", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$EditorFragmentRenderer", "show"));
            }
            final HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
            boolean needDelay = false;
            if (EditorMarkupModelImpl.this.myEditorPreviewHint == null) {
                needDelay = true;
                JPanel editorFragmentPreviewPanel = new JPanel(){
                    private static final int R = 6;

                    @Override
                    public Dimension getPreferredSize() {
                        int width = EditorMarkupModelImpl.this.myEditor.getGutterComponentEx().getWidth() + ((EditorMarkupModelImpl)EditorMarkupModelImpl.this).myEditor.getScrollingModel().getVisibleArea().width;
                        if (!ToolWindowManagerEx.getInstanceEx(EditorMarkupModelImpl.this.myEditor.getProject()).getIdsOn(ToolWindowAnchor.LEFT).isEmpty()) {
                            --width;
                        }
                        return new Dimension(width - 11, EditorMarkupModelImpl.this.myEditor.getLineHeight() * (EditorFragmentRenderer.this.myEndVisualLine - EditorFragmentRenderer.this.myStartVisualLine));
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void paintComponent(@NotNull Graphics g) {
                        if (g == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$EditorFragmentRenderer$2", "paintComponent"));
                        }
                        if (EditorFragmentRenderer.this.myVisualLine == -1) {
                            return;
                        }
                        Dimension size = this.getPreferredSize();
                        EditorGutterComponentEx gutterComponentEx = EditorMarkupModelImpl.this.myEditor.getGutterComponentEx();
                        int gutterWidth = gutterComponentEx.getWidth();
                        if (EditorFragmentRenderer.this.myCacheLevel2 == null || EditorFragmentRenderer.this.myCacheStartLine > EditorFragmentRenderer.this.myStartVisualLine || EditorFragmentRenderer.this.myCacheEndLine < EditorFragmentRenderer.this.myEndVisualLine) {
                            EditorFragmentRenderer.this.myCacheStartLine = EditorMarkupModelImpl.this.fitLineToEditor(EditorFragmentRenderer.this.myVisualLine - 100);
                            EditorFragmentRenderer.this.myCacheEndLine = EditorMarkupModelImpl.this.fitLineToEditor(EditorFragmentRenderer.this.myCacheStartLine + 200 + 1);
                            if (EditorFragmentRenderer.this.myCacheLevel2 == null) {
                                EditorFragmentRenderer.this.myCacheLevel2 = UIUtil.createImage((int)size.width, (int)(EditorMarkupModelImpl.this.myEditor.getLineHeight() * 201), (int)1);
                            }
                            Graphics2D cg = EditorFragmentRenderer.this.myCacheLevel2.createGraphics();
                            AffineTransform t = cg.getTransform();
                            UISettings.setupAntialiasing((Graphics)cg);
                            int lineShift = -EditorMarkupModelImpl.this.myEditor.getLineHeight() * EditorFragmentRenderer.this.myCacheStartLine;
                            AffineTransform translateInstance = AffineTransform.getTranslateInstance(-3.0, lineShift);
                            translateInstance.preConcatenate(t);
                            cg.setTransform(translateInstance);
                            cg.setClip(0, -lineShift, gutterWidth, EditorFragmentRenderer.this.myCacheLevel2.getHeight());
                            gutterComponentEx.paint(cg);
                            translateInstance = AffineTransform.getTranslateInstance(gutterWidth - 3, lineShift);
                            translateInstance.preConcatenate(t);
                            cg.setTransform(translateInstance);
                            EditorComponentImpl contentComponent = EditorMarkupModelImpl.this.myEditor.getContentComponent();
                            cg.setClip(0, -lineShift, contentComponent.getWidth(), EditorFragmentRenderer.this.myCacheLevel2.getHeight());
                            contentComponent.paint(cg);
                        }
                        if (EditorFragmentRenderer.this.myCacheLevel1 == null) {
                            EditorFragmentRenderer.this.myCacheLevel1 = UIUtil.createImage((int)size.width, (int)(EditorMarkupModelImpl.this.myEditor.getLineHeight() * 11), (int)1);
                            EditorFragmentRenderer.this.isDirty = true;
                        }
                        if (EditorFragmentRenderer.this.isDirty) {
                            EditorFragmentRenderer.this.myRelativeY = SwingUtilities.convertPoint((Component)this, (int)0, (int)0, (Component)((EditorMarkupModelImpl)EditorMarkupModelImpl.this).myEditor.getScrollPane()).y;
                            Graphics2D g2d = EditorFragmentRenderer.this.myCacheLevel1.createGraphics();
                            AffineTransform transform = g2d.getTransform();
                            UISettings.setupAntialiasing((Graphics)g2d);
                            GraphicsUtil.setupAAPainting((Graphics)g2d);
                            g2d.setColor(EditorMarkupModelImpl.this.myEditor.getBackgroundColor());
                            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
                            AffineTransform translateInstance = AffineTransform.getTranslateInstance(gutterWidth, EditorMarkupModelImpl.this.myEditor.getLineHeight() * (EditorFragmentRenderer.this.myCacheStartLine - EditorFragmentRenderer.this.myStartVisualLine));
                            translateInstance.preConcatenate(transform);
                            g2d.setTransform(translateInstance);
                            UIUtil.drawImage((Graphics)g2d, (Image)EditorFragmentRenderer.this.myCacheLevel2, (int)(-gutterWidth), (int)0, null);
                            TIntIntHashMap rightEdges = new TIntIntHashMap();
                            int h = EditorMarkupModelImpl.this.myEditor.getLineHeight() - 2;
                            for (RangeHighlighterEx ex : EditorFragmentRenderer.this.myHighlighters) {
                                String s;
                                int hEndOffset = ex.getAffectedAreaEndOffset();
                                Object tooltip = ex.getErrorStripeTooltip();
                                if (tooltip == null || (s = String.valueOf(tooltip)).isEmpty()) continue;
                                s = s.replaceAll("&nbsp;", " ").replaceAll("\\s+", " ");
                                s = StringUtil.unescapeXml((String)s);
                                LogicalPosition logicalPosition = EditorMarkupModelImpl.this.myEditor.offsetToLogicalPosition(hEndOffset);
                                int endOfLineOffset = EditorMarkupModelImpl.this.myEditor.getDocument().getLineEndOffset(logicalPosition.line);
                                logicalPosition = EditorMarkupModelImpl.this.myEditor.offsetToLogicalPosition(endOfLineOffset);
                                Point placeToShow = EditorMarkupModelImpl.this.myEditor.logicalPositionToXY(logicalPosition);
                                logicalPosition = EditorMarkupModelImpl.this.myEditor.xyToLogicalPosition(placeToShow);
                                placeToShow.x += 9;
                                placeToShow.y -= EditorFragmentRenderer.this.myCacheStartLine * EditorMarkupModelImpl.this.myEditor.getLineHeight() - 1;
                                Font font = EditorMarkupModelImpl.this.myEditor.getColorsScheme().getFont(EditorFontType.PLAIN);
                                g2d.setFont(font.deriveFont((float)font.getSize() * 0.8f));
                                int w = g2d.getFontMetrics().stringWidth(s);
                                int rightEdge = rightEdges.get(logicalPosition.line);
                                placeToShow.x = Math.max(placeToShow.x, rightEdge);
                                rightEdge = Math.max(rightEdge, placeToShow.x + w + 18);
                                rightEdges.put(logicalPosition.line, rightEdge);
                                g2d.setColor(MessageType.WARNING.getPopupBackground());
                                g2d.fillRoundRect(placeToShow.x, placeToShow.y, w + 12, h, 6, 6);
                                g2d.setColor((Color)new JBColor((Color)JBColor.GRAY, (Color)Gray._200));
                                g2d.drawRoundRect(placeToShow.x, placeToShow.y, w + 12, h, 6, 6);
                                g2d.setColor(JBColor.foreground());
                                g2d.drawString(s, placeToShow.x + 6, placeToShow.y + h - g2d.getFontMetrics(g2d.getFont()).getDescent() / 2 - 2);
                            }
                            EditorFragmentRenderer.this.isDirty = false;
                        }
                        Graphics2D g2 = (Graphics2D)g.create();
                        try {
                            GraphicsUtil.setupAAPainting((Graphics)g2);
                            g2.setClip(new RoundRectangle2D.Double(0.0, 0.0, (double)size.width - 0.5, (double)size.height - 0.5, 2.0, 2.0));
                            UIUtil.drawImage((Graphics)g2, (Image)EditorFragmentRenderer.this.myCacheLevel1, (int)0, (int)0, (ImageObserver)this);
                            if (UIUtil.isUnderDarcula()) {
                                Rectangle s = new Rectangle(0, 0, size.width, size.height);
                                double cx = size.width / 2;
                                double cy = 0.0;
                                double rx = size.width / 10;
                                int ry = EditorMarkupModelImpl.this.myEditor.getLineHeight() * 3 / 2;
                                g2.setPaint(new GradientPaint(0.0f, 0.0f, Gray._255.withAlpha(75), 0.0f, ry, Gray._255.withAlpha(10)));
                                double pseudoMajorAxis = (double)size.width - rx * 9.0 / 5.0;
                                Ellipse2D.Double topShape1 = new Ellipse2D.Double(cx - rx - pseudoMajorAxis / 2.0, cy - (double)ry, 2.0 * rx, 2 * ry);
                                Ellipse2D.Double topShape2 = new Ellipse2D.Double(cx - rx + pseudoMajorAxis / 2.0, cy - (double)ry, 2.0 * rx, 2 * ry);
                                Area topArea = new Area(topShape1);
                                topArea.add(new Area(topShape2));
                                topArea.add(new Area(new Rectangle2D.Double(cx - pseudoMajorAxis / 2.0, cy, pseudoMajorAxis, ry)));
                                g2.fill(topArea);
                                Area bottomArea = new Area(s);
                                bottomArea.subtract(topArea);
                                g2.setPaint(new GradientPaint(0.0f, size.height - ry, Gray._0.withAlpha(10), 0.0f, size.height, Gray._255.withAlpha(30)));
                                g2.fill(bottomArea);
                            }
                        }
                        finally {
                            g2.dispose();
                        }
                    }
                };
                EditorMarkupModelImpl.this.myEditorPreviewHint = new LightweightHint(editorFragmentPreviewPanel){

                    @Override
                    public void hide(boolean ok) {
                        super.hide(ok);
                        EditorFragmentRenderer.this.myCacheLevel1 = null;
                        if (EditorFragmentRenderer.this.myCacheLevel2 != null) {
                            EditorFragmentRenderer.this.myCacheLevel2 = null;
                            EditorFragmentRenderer.this.myCacheStartLine = -1;
                            EditorFragmentRenderer.this.myCacheEndLine = -1;
                        }
                        EditorFragmentRenderer.this.myDelayed = false;
                    }
                };
                EditorMarkupModelImpl.this.myEditorPreviewHint.setForceLightweightPopup(true);
            }
            Point point = new Point(hintInfo.getOriginalPoint());
            hintInfo.setTextBg(EditorMarkupModelImpl.this.myEditor.getColorsScheme().getDefaultBackground());
            hintInfo.setBorderColor(EditorMarkupModelImpl.this.myEditor.getColorsScheme().getDefaultForeground());
            point = SwingUtilities.convertPoint((Component)((Object)((EditorImpl)editor).getVerticalScrollBar()), point, EditorMarkupModelImpl.this.myEditor.getComponent().getRootPane());
            this.myPointHolder.set(point);
            this.myHintHolder.set(hintInfo);
            if (needDelay && !this.myShowInstantly) {
                this.myDelayed = true;
                Alarm alarm = new Alarm();
                alarm.addRequest(new Runnable(){

                    @Override
                    public void run() {
                        if (EditorMarkupModelImpl.this.myEditorPreviewHint == null || !EditorFragmentRenderer.this.myDelayed) {
                            return;
                        }
                        EditorFragmentRenderer.this.showEditorHint(hintManager, (Point)EditorFragmentRenderer.this.myPointHolder.get(), (HintHint)EditorFragmentRenderer.this.myHintHolder.get());
                        EditorFragmentRenderer.this.myDelayed = false;
                    }
                }, 300);
            } else if (!this.myDelayed) {
                this.showEditorHint(hintManager, point, hintInfo);
            }
            return EditorMarkupModelImpl.this.myEditorPreviewHint;
        }

        private void showEditorHint(HintManagerImpl hintManager, Point point, HintHint hintInfo) {
            int flags = 299;
            hintManager.showEditorHint(EditorMarkupModelImpl.this.myEditorPreviewHint, (Editor)EditorMarkupModelImpl.this.myEditor, point, flags, 0, false, hintInfo);
        }
    }

    private static class BasicTooltipRendererProvider
    implements ErrorStripTooltipRendererProvider {
        private BasicTooltipRendererProvider() {
        }

        @Override
        public TooltipRenderer calcTooltipRenderer(@NotNull Collection<RangeHighlighter> highlighters) {
            if (highlighters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighters", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$BasicTooltipRendererProvider", "calcTooltipRenderer"));
            }
            LineTooltipRenderer bigRenderer = null;
            Set tooltips = null;
            for (RangeHighlighter highlighter : highlighters) {
                Object tooltipObject = highlighter.getErrorStripeTooltip();
                if (tooltipObject == null) continue;
                String text = tooltipObject.toString();
                if (tooltips == null) {
                    tooltips = new THashSet();
                }
                if (!tooltips.add(text)) continue;
                if (bigRenderer == null) {
                    bigRenderer = new LineTooltipRenderer(text, new Object[]{highlighters});
                    continue;
                }
                bigRenderer.addBelow(text);
            }
            return bigRenderer;
        }

        @Override
        @NotNull
        public TooltipRenderer calcTooltipRenderer(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$BasicTooltipRendererProvider", "calcTooltipRenderer"));
            }
            LineTooltipRenderer lineTooltipRenderer = new LineTooltipRenderer(text, new Object[]{text});
            if (lineTooltipRenderer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$BasicTooltipRendererProvider", "calcTooltipRenderer"));
            }
            return lineTooltipRenderer;
        }

        @Override
        @NotNull
        public TooltipRenderer calcTooltipRenderer(@NotNull String text, int width) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$BasicTooltipRendererProvider", "calcTooltipRenderer"));
            }
            LineTooltipRenderer lineTooltipRenderer = new LineTooltipRenderer(text, width, new Object[]{text});
            if (lineTooltipRenderer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$BasicTooltipRendererProvider", "calcTooltipRenderer"));
            }
            return lineTooltipRenderer;
        }

        @Override
        @NotNull
        public TrafficTooltipRenderer createTrafficTooltipRenderer(final @NotNull Runnable onHide, @NotNull Editor editor) {
            if (onHide == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onHide", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$BasicTooltipRendererProvider", "createTrafficTooltipRenderer"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$BasicTooltipRendererProvider", "createTrafficTooltipRenderer"));
            }
            TrafficTooltipRenderer trafficTooltipRenderer = new TrafficTooltipRenderer(){

                @Override
                public void repaintTooltipWindow() {
                }

                @Override
                public LightweightHint show(@NotNull Editor editor, @NotNull Point p, boolean alignToRight, @NotNull TooltipGroup group, @NotNull HintHint hintHint) {
                    if (editor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$BasicTooltipRendererProvider$1", "show"));
                    }
                    if (p == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$BasicTooltipRendererProvider$1", "show"));
                    }
                    if (group == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$BasicTooltipRendererProvider$1", "show"));
                    }
                    if (hintHint == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintHint", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$BasicTooltipRendererProvider$1", "show"));
                    }
                    JLabel label = new JLabel("WTF");
                    return new LightweightHint(label){

                        @Override
                        public void hide() {
                            super.hide();
                            onHide.run();
                        }
                    };
                }
            };
            if (trafficTooltipRenderer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$BasicTooltipRendererProvider", "createTrafficTooltipRenderer"));
            }
            return trafficTooltipRenderer;
        }
    }

    private class MyErrorPanel
    extends ButtonlessScrollBarUI
    implements MouseMotionListener,
    MouseListener,
    MouseWheelListener,
    UISettingsListener {
        private PopupHandler myHandler;
        private JButton myErrorStripeButton;
        private BufferedImage myCachedTrack;
        private TrafficTooltipRenderer myTrafficTooltipRenderer;

        private MyErrorPanel() {
        }

        protected JButton createDecreaseButton(int orientation) {
            this.myErrorStripeButton = EditorMarkupModelImpl.this.myErrorStripeRenderer == null ? super.createDecreaseButton(orientation) : new ErrorStripeButton();
            return this.myErrorStripeButton;
        }

        public boolean alwaysShowTrack() {
            if (this.scrollbar.getOrientation() == 1) {
                return true;
            }
            return super.alwaysShowTrack();
        }

        public void installUI(JComponent c) {
            super.installUI(c);
            this.myCachedTrack = null;
        }

        public void uninstallUI(@NotNull JComponent c) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "uninstallUI"));
            }
            super.uninstallUI(c);
            this.myCachedTrack = null;
        }

        protected void installListeners() {
            super.installListeners();
            this.scrollbar.addMouseMotionListener(this);
            this.scrollbar.addMouseListener(this);
            this.scrollbar.addMouseWheelListener(this);
            this.myErrorStripeButton.addMouseMotionListener(this);
            this.myErrorStripeButton.addMouseListener(this);
            UISettings.getInstance().addUISettingsListener((UISettingsListener)this);
        }

        protected void uninstallListeners() {
            this.scrollbar.removeMouseMotionListener(this);
            this.scrollbar.removeMouseListener(this);
            this.myErrorStripeButton.removeMouseMotionListener(this);
            this.myErrorStripeButton.removeMouseListener(this);
            UISettings.getInstance().removeUISettingsListener((UISettingsListener)this);
            super.uninstallListeners();
        }

        public void uiSettingsChanged(UISettings source) {
            if (!UISettings.getInstance().SHOW_EDITOR_TOOLTIP) {
                this.hideMyEditorPreviewHint();
            }
        }

        protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
            if (UISettings.getInstance().PRESENTATION_MODE || ButtonlessScrollBarUI.isMacOverlayScrollbarSupported()) {
                super.paintThumb(g, c, thumbBounds);
                return;
            }
            if (this.isMacOverlayScrollbar()) {
                if (!EditorMarkupModelImpl.this.isMirrored()) {
                    super.paintThumb(g, c, thumbBounds);
                } else {
                    Graphics2D g2d = (Graphics2D)g;
                    AffineTransform old = g2d.getTransform();
                    AffineTransform tx = AffineTransform.getScaleInstance(-1.0, 1.0);
                    tx.translate(-c.getWidth(), 0.0);
                    g2d.transform(tx);
                    g.translate(1, 0);
                    super.paintThumb(g, c, thumbBounds);
                    g2d.setTransform(old);
                }
            } else {
                int shift = EditorMarkupModelImpl.this.isMirrored() ? -9 : 9;
                g.translate(shift, 0);
                super.paintThumb(g, c, thumbBounds);
                g.translate(-shift, 0);
            }
        }

        protected int adjustThumbWidth(int width) {
            if (this.isMacOverlayScrollbar() || UISettings.getInstance().PRESENTATION_MODE) {
                return super.adjustThumbWidth(width);
            }
            return width - 2;
        }

        protected int getThickness() {
            if (UISettings.getInstance().PRESENTATION_MODE || ButtonlessScrollBarUI.isMacOverlayScrollbarSupported()) {
                return super.getThickness();
            }
            return super.getThickness() + (this.isMacOverlayScrollbar() ? 2 : 7);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doPaintTrack(Graphics g, JComponent c, Rectangle bounds) {
            if (UISettings.getInstance().PRESENTATION_MODE || ButtonlessScrollBarUI.isMacOverlayScrollbarSupported()) {
                g.setColor(EditorMarkupModelImpl.this.getEditor().getColorsScheme().getDefaultBackground());
                g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            }
            Rectangle clip = g.getClipBounds().intersection(bounds);
            if (clip.height == 0) {
                return;
            }
            Rectangle componentBounds = c.getBounds();
            ProperTextRange docRange = ProperTextRange.create((int)0, (int)((int)componentBounds.getHeight()));
            if (this.myCachedTrack == null || (double)this.myCachedTrack.getHeight() != componentBounds.getHeight()) {
                this.myCachedTrack = UIUtil.createImage((int)componentBounds.width, (int)componentBounds.height, (int)2);
                EditorMarkupModelImpl.this.myDirtyYPositions = docRange;
                this.paintTrackBasement(this.myCachedTrack.getGraphics(), new Rectangle(0, 0, componentBounds.width, componentBounds.height));
            }
            if (EditorMarkupModelImpl.this.myDirtyYPositions == WHOLE_DOCUMENT) {
                EditorMarkupModelImpl.this.myDirtyYPositions = docRange;
            }
            if (EditorMarkupModelImpl.this.myDirtyYPositions != null) {
                Graphics2D imageGraphics = this.myCachedTrack.createGraphics();
                ((ApplicationImpl)ApplicationManager.getApplication()).editorPaintStart();
                try {
                    EditorMarkupModelImpl.this.myDirtyYPositions = EditorMarkupModelImpl.this.myDirtyYPositions.intersection((TextRange)docRange);
                    if (EditorMarkupModelImpl.this.myDirtyYPositions == null) {
                        EditorMarkupModelImpl.this.myDirtyYPositions = docRange;
                    }
                    this.repaint(imageGraphics, componentBounds.width, ERROR_ICON_WIDTH - 1, EditorMarkupModelImpl.this.myDirtyYPositions);
                    EditorMarkupModelImpl.this.myDirtyYPositions = null;
                }
                finally {
                    ((ApplicationImpl)ApplicationManager.getApplication()).editorPaintFinish();
                }
            }
            UIUtil.drawImage((Graphics)g, (BufferedImage)this.myCachedTrack, null, (int)0, (int)0);
        }

        private void paintTrackBasement(Graphics g, Rectangle bounds) {
            if (UISettings.getInstance().PRESENTATION_MODE || ButtonlessScrollBarUI.isMacOverlayScrollbarSupported()) {
                g.setColor(EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground());
                g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
                return;
            }
            g.setColor((Color)ButtonlessScrollBarUI.getTrackBackground());
            g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height + 1);
            g.setColor((Color)ButtonlessScrollBarUI.getTrackBorderColor());
            int border = EditorMarkupModelImpl.this.isMirrored() ? bounds.x + bounds.width - 1 : bounds.x;
            g.drawLine(border, bounds.y, border, bounds.y + bounds.height + 1);
        }

        protected Color adjustColor(Color c) {
            if (this.isMacOverlayScrollbar()) {
                return super.adjustColor(c);
            }
            if (UIUtil.isUnderDarcula()) {
                return c;
            }
            return ColorUtil.withAlpha((Color)ColorUtil.shift((Color)super.adjustColor(c), (double)0.9), (double)0.85);
        }

        private void repaint(Graphics g, int gutterWidth, int stripeWidth, ProperTextRange yrange) {
            Rectangle clip = new Rectangle(0, yrange.getStartOffset(), gutterWidth, yrange.getLength() + EditorMarkupModelImpl.this.myMinMarkHeight);
            this.paintTrackBasement(g, clip);
            DocumentEx document = EditorMarkupModelImpl.this.myEditor.getDocument();
            int startOffset = EditorMarkupModelImpl.this.yPositionToOffset(clip.y - EditorMarkupModelImpl.this.myMinMarkHeight, true);
            int endOffset = EditorMarkupModelImpl.this.yPositionToOffset(clip.y + clip.height, false);
            this.drawMarkup(g, stripeWidth, startOffset, endOffset, EditorMarkupModelImpl.this);
            this.drawMarkup(g, stripeWidth, startOffset, endOffset, (MarkupModelEx)DocumentMarkupModel.forDocument(document, EditorMarkupModelImpl.this.myEditor.getProject(), true));
        }

        private void drawMarkup(final Graphics g, final int width, int startOffset, int endOffset, MarkupModelEx markup) {
            final PriorityQueue<PositionedStripe> thinEnds = new PriorityQueue<PositionedStripe>(5, new Comparator<PositionedStripe>(){

                @Override
                public int compare(@NotNull PositionedStripe o1, @NotNull PositionedStripe o2) {
                    if (o1 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel$1", "compare"));
                    }
                    if (o2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel$1", "compare"));
                    }
                    return o1.yEnd - o2.yEnd;
                }
            });
            final PriorityQueue<PositionedStripe> wideEnds = new PriorityQueue<PositionedStripe>(5, new Comparator<PositionedStripe>(){

                @Override
                public int compare(@NotNull PositionedStripe o1, @NotNull PositionedStripe o2) {
                    if (o1 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel$2", "compare"));
                    }
                    if (o2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel$2", "compare"));
                    }
                    return o1.yEnd - o2.yEnd;
                }
            });
            final ArrayList<PositionedStripe> thinStripes = new ArrayList<PositionedStripe>();
            final ArrayList<PositionedStripe> wideStripes = new ArrayList<PositionedStripe>();
            final int[] thinYStart = new int[1];
            final int[] wideYStart = new int[1];
            markup.processRangeHighlightersOverlappingWith(startOffset, endOffset, (Processor<? super RangeHighlighterEx>)new Processor<RangeHighlighterEx>(){

                public boolean process(RangeHighlighterEx highlighter) {
                    int i;
                    if (!highlighter.getEditorFilter().avaliableIn((Editor)EditorMarkupModelImpl.this.myEditor)) {
                        return true;
                    }
                    Color color = highlighter.getErrorStripeMarkColor();
                    if (color == null) {
                        return true;
                    }
                    boolean isThin = highlighter.isThinErrorStripeMark();
                    int[] yStart = isThin ? thinYStart : wideYStart;
                    List stripes = isThin ? thinStripes : wideStripes;
                    Queue ends = isThin ? thinEnds : wideEnds;
                    ProperTextRange range = EditorMarkupModelImpl.this.offsetsToYPositions(highlighter.getStartOffset(), highlighter.getEndOffset());
                    int ys = range.getStartOffset();
                    int ye = range.getEndOffset();
                    if (ye - ys < EditorMarkupModelImpl.this.myMinMarkHeight) {
                        ye = ys + EditorMarkupModelImpl.this.myMinMarkHeight;
                    }
                    yStart[0] = MyErrorPanel.this.drawStripesEndingBefore(ys, ends, stripes, g, width, yStart[0]);
                    int layer = highlighter.getLayer();
                    PositionedStripe stripe = null;
                    for (i = 0; i < stripes.size(); ++i) {
                        PositionedStripe s = (PositionedStripe)stripes.get(i);
                        if (s.layer == layer) {
                            stripe = s;
                            break;
                        }
                        if (s.layer < layer) break;
                    }
                    if (stripe == null) {
                        if (yStart[0] != ys) {
                            if (!stripes.isEmpty()) {
                                PositionedStripe top = (PositionedStripe)stripes.get(0);
                                MyErrorPanel.this.drawSpot(g, width, top.thin, yStart[0], ys, top.color, true, true);
                            }
                            yStart[0] = ys;
                        }
                        stripe = new PositionedStripe(color, ye, isThin, layer);
                        stripes.add(i, stripe);
                        ends.offer(stripe);
                    } else if (stripe.yEnd != ye) {
                        ends.remove(stripe);
                        stripe.yEnd = ye;
                        ends.offer(stripe);
                    }
                    return true;
                }
            });
            this.drawStripesEndingBefore(Integer.MAX_VALUE, thinEnds, thinStripes, g, width, thinYStart[0]);
            this.drawStripesEndingBefore(Integer.MAX_VALUE, wideEnds, wideStripes, g, width, wideYStart[0]);
        }

        private int drawStripesEndingBefore(int ys, Queue<PositionedStripe> ends, List<PositionedStripe> stripes, Graphics g, int width, int yStart) {
            PositionedStripe endingStripe;
            while (!ends.isEmpty() && (endingStripe = ends.peek()).yEnd <= ys) {
                ends.remove();
                int i = stripes.indexOf(endingStripe);
                stripes.remove(i);
                if (i != 0) continue;
                this.drawSpot(g, width, endingStripe.thin, yStart, endingStripe.yEnd, endingStripe.color, true, true);
                yStart = endingStripe.yEnd;
            }
            return yStart;
        }

        private void drawSpot(Graphics g, int width, boolean thinErrorStripeMark, int yStart, int yEnd, Color color, boolean drawTopDecoration, boolean drawBottomDecoration) {
            GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
            int x = EditorMarkupModelImpl.this.isMirrored() ? 3 : 5;
            int paintWidth = width;
            boolean flatStyle = Registry.is((String)"ide.new.markup.markers");
            if (thinErrorStripeMark) {
                paintWidth /= 2;
                paintWidth += flatStyle ? -2 : 1;
                int n = x = EditorMarkupModelImpl.this.isMirrored() ? width + 2 : 0;
                if (yEnd - yStart < 6) {
                    yEnd += yEnd - --yStart - 1;
                }
            }
            if (color == null) {
                return;
            }
            Color darker = color;
            if (!UIUtil.isUnderDarcula()) {
                float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
                hsb[2] = Math.min(1.0f, hsb[2] * 0.85f);
                darker = new Color(Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]));
            }
            if (flatStyle) {
                g.setColor(darker);
                g.fillRoundRect(x, yStart, paintWidth, yEnd - yStart, 3, 3);
                config.restore();
                return;
            }
            g.setColor(color);
            g.fillRect(x + 1, yStart, paintWidth - 2, yEnd - yStart + 1);
            Color brighter = color.brighter();
            g.setColor(brighter);
            UIUtil.drawLine((Graphics)g, (int)x, (int)yStart, (int)x, (int)yEnd);
            if (drawTopDecoration) {
                UIUtil.drawLine((Graphics)g, (int)(x + 1), (int)yStart, (int)(x + paintWidth - 2), (int)yStart);
            }
            g.setColor(darker);
            if (drawBottomDecoration) {
                UIUtil.drawLine((Graphics)g, (int)(x + 1), (int)yEnd, (int)(x + paintWidth - 2), (int)yEnd);
            }
            UIUtil.drawLine((Graphics)g, (int)(x + paintWidth - 2), (int)yStart, (int)(x + paintWidth - 2), (int)yEnd);
            config.restore();
        }

        @Override
        public void mouseClicked(final @NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "mouseClicked"));
            }
            CommandProcessor.getInstance().executeCommand(EditorMarkupModelImpl.this.myEditor.getProject(), new Runnable(){

                @Override
                public void run() {
                    MyErrorPanel.this.doMouseClicked(e);
                }
            }, EditorBundle.message((String)"move.caret.command.name", (Object[])new Object[0]), (Object)DocCommandGroupId.noneGroupId((Document)EditorMarkupModelImpl.this.getDocument()), UndoConfirmationPolicy.DEFAULT, EditorMarkupModelImpl.this.getDocument());
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "mousePressed"));
            }
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "mouseReleased"));
            }
        }

        private int getWidth() {
            return this.scrollbar.getWidth();
        }

        private void doMouseClicked(MouseEvent e) {
            EditorMarkupModelImpl.this.myEditor.getContentComponent().requestFocus();
            int lineCount = EditorMarkupModelImpl.this.getDocument().getLineCount() + EditorMarkupModelImpl.this.myEditor.getSettings().getAdditionalLinesCount();
            if (lineCount == 0) {
                return;
            }
            if (e.getX() > 0 && e.getX() <= this.getWidth()) {
                EditorMarkupModelImpl.this.doClick(e);
            }
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "mouseMoved"));
            }
            EditorImpl.MyScrollBar scrollBar = EditorMarkupModelImpl.this.myEditor.getVerticalScrollBar();
            int buttonHeight = scrollBar.getDecScrollButtonHeight();
            int lineCount = EditorMarkupModelImpl.this.getDocument().getLineCount() + EditorMarkupModelImpl.this.myEditor.getSettings().getAdditionalLinesCount();
            if (lineCount == 0) {
                return;
            }
            if (e.getY() < buttonHeight && EditorMarkupModelImpl.this.myErrorStripeRenderer != null) {
                this.showTrafficLightTooltip(e);
                return;
            }
            if (e.getX() > 0 && e.getX() <= this.getWidth() && EditorMarkupModelImpl.this.showToolTipByMouseMove(e)) {
                this.scrollbar.setCursor(Cursor.getPredefinedCursor(12));
                return;
            }
            this.cancelMyToolTips(e, false);
            if (this.scrollbar.getCursor().equals(Cursor.getPredefinedCursor(12))) {
                this.scrollbar.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (EditorMarkupModelImpl.this.myEditorPreviewHint == null) {
                return;
            }
            EditorMarkupModelImpl.this.myWheelAccumulator += e.getScrollType() == 0 ? e.getUnitsToScroll() * e.getScrollAmount() : (e.getWheelRotation() < 0 ? -e.getScrollAmount() : e.getScrollAmount());
            EditorMarkupModelImpl.this.myRowAdjuster = EditorMarkupModelImpl.this.myWheelAccumulator / EditorMarkupModelImpl.this.myEditor.getLineHeight();
            EditorMarkupModelImpl.this.showToolTipByMouseMove(e);
        }

        private void showTrafficLightTooltip(MouseEvent e) {
            if (this.myTrafficTooltipRenderer == null) {
                this.myTrafficTooltipRenderer = EditorMarkupModelImpl.this.myTooltipRendererProvider.createTrafficTooltipRenderer(new Runnable(){

                    @Override
                    public void run() {
                        MyErrorPanel.this.myTrafficTooltipRenderer = null;
                    }
                }, EditorMarkupModelImpl.this.myEditor);
            }
            EditorMarkupModelImpl.this.showTooltip(e, this.myTrafficTooltipRenderer, new HintHint(e).setAwtTooltip(true).setMayCenterPosition(true).setContentActive(false).setPreferredPosition(Balloon.Position.atLeft));
        }

        private void repaintTrafficTooltip() {
            if (this.myTrafficTooltipRenderer != null) {
                this.myTrafficTooltipRenderer.repaintTooltipWindow();
            }
        }

        private void cancelMyToolTips(MouseEvent e, boolean checkIfShouldSurvive) {
            this.hideMyEditorPreviewHint();
            TooltipController tooltipController = TooltipController.getInstance();
            if (!checkIfShouldSurvive || !tooltipController.shouldSurvive(e)) {
                tooltipController.cancelTooltip(ERROR_STRIPE_TOOLTIP_GROUP, e, true);
            }
        }

        private void hideMyEditorPreviewHint() {
            if (EditorMarkupModelImpl.this.myEditorPreviewHint != null) {
                EditorMarkupModelImpl.this.myEditorPreviewHint.hide();
                EditorMarkupModelImpl.this.myEditorPreviewHint = null;
                EditorMarkupModelImpl.this.myRowAdjuster = 0;
                EditorMarkupModelImpl.this.myWheelAccumulator = 0;
            }
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "mouseEntered"));
            }
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "mouseExited"));
            }
            this.cancelMyToolTips(e, true);
        }

        @Override
        public void mouseDragged(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "mouseDragged"));
            }
            this.cancelMyToolTips(e, true);
        }

        private void setPopupHandler(@NotNull PopupHandler handler) {
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$MyErrorPanel", "setPopupHandler"));
            }
            if (this.myHandler != null) {
                this.scrollbar.removeMouseListener((MouseListener)this.myHandler);
                this.myErrorStripeButton.removeMouseListener((MouseListener)this.myHandler);
            }
            this.myHandler = handler;
            this.scrollbar.addMouseListener((MouseListener)handler);
            this.myErrorStripeButton.addMouseListener((MouseListener)this.myHandler);
        }
    }

    private class ErrorStripeButton
    extends JButton {
        private ErrorStripeButton() {
            this.setFocusable(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(@NotNull Graphics g) {
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/editor/impl/EditorMarkupModelImpl$ErrorStripeButton", "paint"));
            }
            ((ApplicationImpl)ApplicationManager.getApplication()).editorPaintStart();
            Rectangle bounds = this.getBounds();
            Rectangle errorIconBounds = new Rectangle(0, 0, ERROR_ICON_WIDTH, ERROR_ICON_HEIGHT);
            errorIconBounds.x = bounds.width / 2 - errorIconBounds.width / 2 + 1;
            errorIconBounds.y = bounds.height / 2 - errorIconBounds.height / 2;
            try {
                if (UISettings.getInstance().PRESENTATION_MODE || ButtonlessScrollBarUI.isMacOverlayScrollbarSupported()) {
                    g.setColor(EditorMarkupModelImpl.this.getEditor().getColorsScheme().getDefaultBackground());
                    g.fillRect(0, 0, bounds.width, bounds.height);
                    if (EditorMarkupModelImpl.this.myErrorStripeRenderer != null) {
                        EditorMarkupModelImpl.this.myErrorStripeRenderer.paint((Component)this, g, errorIconBounds);
                    }
                } else {
                    g.setColor((Color)ButtonlessScrollBarUI.getTrackBackground());
                    g.fillRect(0, 0, bounds.width, bounds.height);
                    g.setColor((Color)ButtonlessScrollBarUI.getTrackBorderColor());
                    int borderX = !EditorMarkupModelImpl.this.isMirrored() ? 0 : bounds.width - 1;
                    g.drawLine(borderX, 0, borderX, bounds.height);
                    if (EditorMarkupModelImpl.this.myErrorStripeRenderer != null) {
                        EditorMarkupModelImpl.this.myErrorStripeRenderer.paint((Component)this, g, errorIconBounds);
                    }
                }
            }
            finally {
                ((ApplicationImpl)ApplicationManager.getApplication()).editorPaintFinish();
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return STRIPE_BUTTON_PREFERRED_SIZE;
        }
    }

    private static class PositionedStripe {
        private final Color color;
        private int yEnd;
        private final boolean thin;
        private final int layer;

        private PositionedStripe(Color color, int yEnd, boolean thin, int layer) {
            this.color = color;
            this.yEnd = yEnd;
            this.thin = thin;
            this.layer = layer;
        }
    }
}

