/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.impl.UndefinedMacrosConfigurable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.WaitForProgressToShow;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ProjectMacrosUtil {
    private static final Logger LOG = Logger.getInstance((String)("#" + ProjectMacrosUtil.class.getName()));

    private ProjectMacrosUtil() {
    }

    public static boolean showMacrosConfigurationDialog(Project project, Collection<String> undefinedMacros) {
        String text = ProjectBundle.message((String)"project.load.undefined.path.variables.message", (Object[])new Object[0]);
        Application application = ApplicationManager.getApplication();
        if (application.isHeadlessEnvironment() || application.isUnitTestMode()) {
            throw new RuntimeException(text + ": " + StringUtil.join(undefinedMacros, (String)", "));
        }
        return ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new UndefinedMacrosConfigurable(text, undefinedMacros));
    }

    public static boolean checkNonIgnoredMacros(Project project, Set<String> usedMacros) {
        PathMacros pathMacros = PathMacros.getInstance();
        Iterator<String> iterator = usedMacros.iterator();
        while (iterator.hasNext()) {
            if (!pathMacros.isIgnoredMacroName(iterator.next())) continue;
            iterator.remove();
        }
        return ProjectMacrosUtil.checkMacros(project, usedMacros);
    }

    public static boolean checkMacros(final Project project, final Set<String> usedMacros) {
        Set<String> defined = ProjectMacrosUtil.getDefinedMacros();
        usedMacros.removeAll(defined);
        String pathMacroSystemPrefix = "path.macro.";
        Iterator<String> it = usedMacros.iterator();
        while (it.hasNext()) {
            final String macro = it.next();
            final String value = System.getProperty("path.macro." + macro, null);
            if (value == null) continue;
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    PathMacros.getInstance().setMacro(macro, value);
                }
            });
            it.remove();
        }
        if (usedMacros.isEmpty()) {
            return true;
        }
        final boolean[] result = new boolean[1];
        Runnable r = new Runnable(){

            @Override
            public void run() {
                result[0] = ProjectMacrosUtil.showMacrosConfigurationDialog(project, usedMacros);
            }
        };
        WaitForProgressToShow.runOrInvokeAndWaitAboveProgress((Runnable)r, (ModalityState)ModalityState.NON_MODAL);
        return result[0];
    }

    public static Set<String> getDefinedMacros() {
        PathMacros pathMacros = PathMacros.getInstance();
        HashSet<String> definedMacros = new HashSet(pathMacros.getUserMacroNames());
        definedMacros.addAll(pathMacros.getSystemMacroNames());
        definedMacros = Collections.unmodifiableSet(definedMacros);
        return definedMacros;
    }
}

