/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.BackgroundFromStartOption;
import com.intellij.openapi.vcs.changes.committed.AbstractCalledLater;
import com.intellij.openapi.vcs.changes.committed.CacheSettingsDialog;
import com.intellij.openapi.vcs.changes.committed.ChangeListFilteringStrategy;
import com.intellij.openapi.vcs.changes.committed.CommittedChangeListsListener;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowserUseCase;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesFilterDialog;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesFilterKey;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesFilterPriority;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.committed.DecoratorManager;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedViewAuxiliary;
import com.intellij.openapi.vcs.changes.committed.VcsConfigurationChangeListener;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.LightColors;
import com.intellij.util.AsynchConsumer;
import com.intellij.util.BufferedListConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommittedChangesPanel
extends JPanel
implements TypeSafeDataProvider,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.committed.CommittedChangesPanel");
    private final CommittedChangesTreeBrowser myBrowser;
    private final Project myProject;
    private CommittedChangesProvider myProvider;
    private ChangeBrowserSettings mySettings;
    private final RepositoryLocation myLocation;
    private int myMaxCount = 0;
    private final MyFilterComponent myFilterComponent = new MyFilterComponent();
    private final JCheckBox myRegexCheckbox;
    private final List<Runnable> myShouldBeCalledOnDispose;
    private volatile boolean myDisposed;
    private volatile boolean myInLoad;
    private Consumer<String> myIfNotCachedReloader;
    private boolean myChangesLoaded;

    public CommittedChangesPanel(Project project, CommittedChangesProvider provider, ChangeBrowserSettings settings, @Nullable RepositoryLocation location, @Nullable ActionGroup extraActions) {
        super(new BorderLayout());
        this.mySettings = settings;
        this.myProject = project;
        this.myProvider = provider;
        this.myLocation = location;
        this.myShouldBeCalledOnDispose = new ArrayList<Runnable>();
        this.myBrowser = new CommittedChangesTreeBrowser(project, new ArrayList<CommittedChangeList>());
        Disposer.register((Disposable)this, (Disposable)this.myBrowser);
        this.add((Component)this.myBrowser, "Center");
        VcsCommittedViewAuxiliary auxiliary = provider.createActions((DecoratorManager)this.myBrowser, location);
        JPanel toolbarPanel = new JPanel();
        toolbarPanel.setLayout(new BoxLayout(toolbarPanel, 0));
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("CommittedChangesToolbar");
        ActionToolbar toolBar = this.myBrowser.createGroupFilterToolbar(project, group, extraActions, auxiliary != null ? auxiliary.getToolbarActions() : Collections.emptyList());
        toolbarPanel.add(toolBar.getComponent());
        toolbarPanel.add(Box.createHorizontalGlue());
        this.myRegexCheckbox = new JCheckBox(VcsBundle.message((String)"committed.changes.regex.title", (Object[])new Object[0]));
        this.myRegexCheckbox.setSelected(false);
        this.myRegexCheckbox.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CommittedChangesPanel.this.myFilterComponent.filter();
            }
        });
        toolbarPanel.add((Component)((Object)this.myFilterComponent));
        toolbarPanel.add(this.myRegexCheckbox);
        this.myFilterComponent.setMinimumSize(this.myFilterComponent.getPreferredSize());
        this.myFilterComponent.setMaximumSize(this.myFilterComponent.getPreferredSize());
        this.myBrowser.setToolBar(toolbarPanel);
        if (auxiliary != null) {
            this.myShouldBeCalledOnDispose.add(auxiliary.getCalledOnViewDispose());
            this.myBrowser.setTableContextMenu(group, auxiliary.getPopupActions());
        } else {
            this.myBrowser.setTableContextMenu(group, Collections.<AnAction>emptyList());
        }
        AnAction anAction = ActionManager.getInstance().getAction("CommittedChanges.Refresh");
        anAction.registerCustomShortcutSet(CommonShortcuts.getRerun(), (JComponent)this);
        this.myBrowser.addFilter(this.myFilterComponent);
        this.myIfNotCachedReloader = this.myLocation == null ? null : new Consumer<String>(){

            public void consume(String s) {
                CommittedChangesPanel.this.refreshChanges(false);
            }
        };
    }

    public RepositoryLocation getRepositoryLocation() {
        return this.myLocation;
    }

    public void setMaxCount(int maxCount) {
        this.myMaxCount = maxCount;
    }

    public void setProvider(CommittedChangesProvider provider) {
        if (this.myProvider != provider) {
            this.myProvider = provider;
            this.mySettings = provider.createDefaultSettings();
        }
    }

    public void refreshChanges(boolean cacheOnly) {
        if (this.myLocation != null) {
            this.refreshChangesFromLocation();
        } else {
            this.refreshChangesFromCache(cacheOnly);
        }
    }

    private void refreshChangesFromLocation() {
        this.myBrowser.reset();
        this.myInLoad = true;
        this.myBrowser.setLoading(true);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Loading changes", true, BackgroundFromStartOption.getInstance()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(final @NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/committed/CommittedChangesPanel$3", "run"));
                }
                try {
                    AsynchConsumer<List<CommittedChangeList>> appender = new AsynchConsumer<List<CommittedChangeList>>(){

                        public void finished() {
                        }

                        public void consume(final List<CommittedChangeList> list) {
                            new AbstractCalledLater(myProject, ModalityState.stateForComponent((Component)CommittedChangesPanel.this.myBrowser)){

                                @Override
                                public void run() {
                                    CommittedChangesPanel.this.myBrowser.append(list);
                                }
                            }.callMe();
                        }
                    };
                    final BufferedListConsumer bufferedListConsumer = new BufferedListConsumer(30, appender, -1);
                    CommittedChangesPanel.this.myProvider.loadCommittedChanges(CommittedChangesPanel.this.mySettings, CommittedChangesPanel.this.myLocation, CommittedChangesPanel.this.myMaxCount, (AsynchConsumer)new AsynchConsumer<CommittedChangeList>(){

                        public void finished() {
                            bufferedListConsumer.flush();
                        }

                        public void consume(CommittedChangeList committedChangeList) {
                            if (CommittedChangesPanel.this.myDisposed) {
                                indicator.cancel();
                            }
                            ProgressManager.checkCanceled();
                            bufferedListConsumer.consumeOne(committedChangeList);
                        }
                    });
                }
                catch (VcsException e) {
                    LOG.info((Throwable)e);
                    WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            Messages.showErrorDialog((Project)myProject, (String)("Error refreshing view: " + StringUtil.join((String[])e.getMessages(), (String)"\n")), (String)"Committed Changes");
                        }
                    }, null, (Project)this.myProject);
                }
                finally {
                    CommittedChangesPanel.this.myInLoad = false;
                    CommittedChangesPanel.this.myBrowser.setLoading(false);
                }
            }
        });
    }

    public void clearCaches() {
        CommittedChangesCache cache = CommittedChangesCache.getInstance(this.myProject);
        cache.clearCaches(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CommittedChangesPanel.this.updateFilteredModel(Collections.emptyList(), true);
                    }
                }, ModalityState.NON_MODAL, CommittedChangesPanel.this.myProject.getDisposed());
            }
        });
    }

    private void refreshChangesFromCache(final boolean cacheOnly) {
        final CommittedChangesCache cache = CommittedChangesCache.getInstance(this.myProject);
        cache.hasCachesForAnyRoot(new Consumer<Boolean>(){

            public void consume(Boolean notEmpty) {
                if (!notEmpty.booleanValue()) {
                    if (cacheOnly) {
                        CommittedChangesPanel.this.myBrowser.getEmptyText().setText(VcsBundle.message((String)"committed.changes.not.loaded.message", (Object[])new Object[0]));
                        return;
                    }
                    if (!CacheSettingsDialog.showSettingsDialog(CommittedChangesPanel.this.myProject)) {
                        return;
                    }
                }
                cache.getProjectChangesAsync(CommittedChangesPanel.this.mySettings, CommittedChangesPanel.this.myMaxCount, cacheOnly, new Consumer<List<CommittedChangeList>>(){

                    public void consume(List<CommittedChangeList> committedChangeLists) {
                        CommittedChangesPanel.this.updateFilteredModel(committedChangeLists, false);
                    }
                }, new Consumer<List<VcsException>>(){

                    public void consume(List<VcsException> vcsExceptions) {
                        AbstractVcsHelper.getInstance((Project)CommittedChangesPanel.this.myProject).showErrors(vcsExceptions, "Error refreshing VCS history");
                    }
                });
            }
        });
    }

    private void updateFilteredModel(List<CommittedChangeList> committedChangeLists, boolean reset) {
        if (committedChangeLists == null) {
            return;
        }
        this.myChangesLoaded = !reset;
        this.setEmptyMessage(this.myChangesLoaded);
        this.myBrowser.setItems(committedChangeLists, CommittedChangesBrowserUseCase.COMMITTED);
    }

    private void setEmptyMessage(boolean changesLoaded) {
        String emptyText = !changesLoaded ? VcsBundle.message((String)"committed.changes.not.loaded.message", (Object[])new Object[0]) : VcsBundle.message((String)"committed.changes.empty.message", (Object[])new Object[0]);
        this.myBrowser.getEmptyText().setText(emptyText);
    }

    public void setChangesFilter() {
        CommittedChangesFilterDialog filterDialog = new CommittedChangesFilterDialog(this.myProject, this.myProvider.createFilterUI(true), this.mySettings);
        filterDialog.show();
        if (filterDialog.isOK()) {
            this.mySettings = filterDialog.getSettings();
            this.refreshChanges(false);
        }
    }

    public void calcData(DataKey key, DataSink sink) {
        if (key.equals(VcsDataKeys.REMOTE_HISTORY_CHANGED_LISTENER)) {
            sink.put(VcsDataKeys.REMOTE_HISTORY_CHANGED_LISTENER, this.myIfNotCachedReloader);
        } else if (VcsDataKeys.REMOTE_HISTORY_LOCATION.equals(key)) {
            sink.put(VcsDataKeys.REMOTE_HISTORY_LOCATION, (Object)this.myLocation);
        }
        this.myBrowser.calcData(key, sink);
    }

    public void dispose() {
        for (Runnable runnable : this.myShouldBeCalledOnDispose) {
            runnable.run();
        }
        this.myDisposed = true;
    }

    private void setRegularFilterBackground() {
        this.myFilterComponent.getTextEditor().setBackground(UIUtil.getTextFieldBackground());
    }

    private void setNotFoundFilterBackground() {
        this.myFilterComponent.getTextEditor().setBackground(LightColors.RED);
    }

    public void passCachedListsToListener(final VcsConfigurationChangeListener.DetailedNotification notification, final Project project, final VirtualFile root) {
        final LinkedList resultList = new LinkedList();
        this.myBrowser.reportLoadedLists(new CommittedChangeListsListener(){

            public void onBeforeStartReport() {
            }

            public boolean report(CommittedChangeList list) {
                resultList.add(list);
                return false;
            }

            public void onAfterEndReport() {
                if (!resultList.isEmpty()) {
                    notification.execute(project, root, resultList);
                }
            }
        });
    }

    public boolean isInLoad() {
        return this.myInLoad;
    }

    private class MyFilterComponent
    extends FilterComponent
    implements ChangeListFilteringStrategy {
        private final List<ChangeListener> myList;

        public MyFilterComponent() {
            super("COMMITTED_CHANGES_FILTER_HISTORY", 20);
            this.myList = ContainerUtil.createLockFreeCopyOnWriteList();
        }

        public CommittedChangesFilterKey getKey() {
            return new CommittedChangesFilterKey("text", CommittedChangesFilterPriority.TEXT);
        }

        public void filter() {
            for (ChangeListener changeListener : this.myList) {
                changeListener.stateChanged(new ChangeEvent((Object)this));
            }
        }

        public JComponent getFilterUI() {
            return null;
        }

        public void setFilterBase(List<CommittedChangeList> changeLists) {
        }

        public void addChangeListener(ChangeListener listener) {
            this.myList.add(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.myList.remove(listener);
        }

        public void resetFilterBase() {
        }

        public void appendFilterBase(List<CommittedChangeList> changeLists) {
        }

        @NotNull
        public List<CommittedChangeList> filterChangeLists(List<CommittedChangeList> changeLists) {
            CommittedChangesPanel.this.setEmptyMessage(CommittedChangesPanel.this.myChangesLoaded);
            FilterHelper filterHelper = CommittedChangesPanel.this.myRegexCheckbox.isSelected() ? new RegexFilterHelper(CommittedChangesPanel.this.myFilterComponent.getFilter()) : new WordMatchFilterHelper(CommittedChangesPanel.this.myFilterComponent.getFilter());
            ArrayList<CommittedChangeList> result = new ArrayList<CommittedChangeList>();
            for (CommittedChangeList list : changeLists) {
                if (!filterHelper.filter(list)) continue;
                result.add(list);
            }
            if (result.size() == 0 && !CommittedChangesPanel.this.myFilterComponent.getFilter().isEmpty()) {
                CommittedChangesPanel.this.setNotFoundFilterBackground();
            } else {
                CommittedChangesPanel.this.setRegularFilterBackground();
            }
            ArrayList<CommittedChangeList> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/committed/CommittedChangesPanel$MyFilterComponent", "filterChangeLists"));
            }
            return arrayList;
        }
    }

    private static class WordMatchFilterHelper
    implements FilterHelper {
        private final String[] myParts;

        WordMatchFilterHelper(String filterString) {
            this.myParts = filterString.split(" ");
            for (int i = 0; i < this.myParts.length; ++i) {
                this.myParts[i] = this.myParts[i].toLowerCase();
            }
        }

        @Override
        public boolean filter(@NotNull CommittedChangeList cl) {
            if (cl == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cl", "com/intellij/openapi/vcs/changes/committed/CommittedChangesPanel$WordMatchFilterHelper", "filter"));
            }
            return WordMatchFilterHelper.changeListMatches(cl, this.myParts);
        }

        private static boolean changeListMatches(@NotNull CommittedChangeList changeList, String[] filterWords) {
            if (changeList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "com/intellij/openapi/vcs/changes/committed/CommittedChangesPanel$WordMatchFilterHelper", "changeListMatches"));
            }
            for (String word : filterWords) {
                String comment = changeList.getComment();
                String committer = changeList.getCommitterName();
                if (!(comment != null && comment.toLowerCase().contains(word) || committer != null && committer.toLowerCase().contains(word)) && !Long.toString(changeList.getNumber()).contains(word)) continue;
                return true;
            }
            return false;
        }
    }

    private class RegexFilterHelper
    implements FilterHelper {
        private final Pattern myPattern;

        RegexFilterHelper(String regex) {
            Pattern pattern;
            if (regex == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regex", "com/intellij/openapi/vcs/changes/committed/CommittedChangesPanel$RegexFilterHelper", "<init>"));
            }
            try {
                pattern = Pattern.compile(regex);
            }
            catch (PatternSyntaxException e) {
                pattern = null;
                CommittedChangesPanel.this.myBrowser.getEmptyText().setText(VcsBundle.message((String)"committed.changes.incorrect.regex.message", (Object[])new Object[0]));
            }
            this.myPattern = pattern;
        }

        @Override
        public boolean filter(@NotNull CommittedChangeList cl) {
            if (cl == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cl", "com/intellij/openapi/vcs/changes/committed/CommittedChangesPanel$RegexFilterHelper", "filter"));
            }
            return this.changeListMatches(cl);
        }

        private boolean changeListMatches(@NotNull CommittedChangeList cl) {
            if (cl == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cl", "com/intellij/openapi/vcs/changes/committed/CommittedChangesPanel$RegexFilterHelper", "changeListMatches"));
            }
            if (this.myPattern == null) {
                return false;
            }
            boolean commentMatches = this.myPattern.matcher(cl.getComment()).find();
            boolean committerMatches = this.myPattern.matcher(cl.getCommitterName()).find();
            boolean revisionMatches = this.myPattern.matcher(Long.toString(cl.getNumber())).find();
            return commentMatches || committerMatches || revisionMatches;
        }
    }

    private static interface FilterHelper {
        public boolean filter(@NotNull CommittedChangeList var1);
    }
}

