/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.impl.FileStatusProvider;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FileStatusManagerImpl
extends FileStatusManager
implements ProjectComponent {
    private final Map<VirtualFile, FileStatus> myCachedStatuses = Collections.synchronizedMap(new HashMap());
    private final Map<VirtualFile, Boolean> myWhetherExactlyParentToChanged = Collections.synchronizedMap(new HashMap());
    private final Project myProject;
    private final List<FileStatusListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private FileStatusProvider myFileStatusProvider;
    private final NotNullLazyValue<FileStatusProvider[]> myExtensions = new NotNullLazyValue<FileStatusProvider[]>(){

        @NotNull
        protected FileStatusProvider[] compute() {
            FileStatusProvider[] fileStatusProviderArray = (FileStatusProvider[])Extensions.getExtensions(FileStatusProvider.EP_NAME, (AreaInstance)FileStatusManagerImpl.this.myProject);
            if (fileStatusProviderArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/FileStatusManagerImpl$1", "compute"));
            }
            return fileStatusProviderArray;
        }
    };

    public FileStatusManagerImpl(Project project, StartupManager startupManager, DirectoryIndex makeSureIndexIsInitializedFirst) {
        this.myProject = project;
        startupManager.registerPreStartupActivity(new Runnable(){

            @Override
            public void run() {
                DocumentAdapter documentListener = new DocumentAdapter(){

                    public void documentChanged(DocumentEvent event) {
                        VirtualFile file = FileDocumentManager.getInstance().getFile(event.getDocument());
                        if (file != null) {
                            FileStatusManagerImpl.this.refreshFileStatusFromDocument(file, event.getDocument());
                        }
                    }
                };
                EditorFactory factory = EditorFactory.getInstance();
                if (factory != null) {
                    factory.getEventMulticaster().addDocumentListener((DocumentListener)documentListener, (Disposable)FileStatusManagerImpl.this.myProject);
                }
            }
        });
        startupManager.registerPostStartupActivity((Runnable)new DumbAwareRunnable(){

            public void run() {
                FileStatusManagerImpl.this.fileStatusesChanged();
            }
        });
    }

    public void setFileStatusProvider(FileStatusProvider fileStatusProvider) {
        this.myFileStatusProvider = fileStatusProvider;
    }

    public FileStatus calcStatus(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/vcs/impl/FileStatusManagerImpl", "calcStatus"));
        }
        for (FileStatusProvider extension : (FileStatusProvider[])this.myExtensions.getValue()) {
            FileStatus status = extension.getFileStatus(virtualFile);
            if (status == null) continue;
            return status;
        }
        if (virtualFile.isInLocalFileSystem() && this.myFileStatusProvider != null) {
            return this.myFileStatusProvider.getFileStatus(virtualFile);
        }
        return FileStatusManagerImpl.getDefaultStatus(virtualFile);
    }

    @NotNull
    public static FileStatus getDefaultStatus(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/impl/FileStatusManagerImpl", "getDefaultStatus"));
        }
        FileStatus fileStatus = file.isValid() && file.is(VFileProperty.SPECIAL) ? FileStatus.IGNORED : FileStatus.NOT_CHANGED;
        if (fileStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/FileStatusManagerImpl", "getDefaultStatus"));
        }
        return fileStatus;
    }

    public void projectClosed() {
    }

    public void projectOpened() {
    }

    public void disposeComponent() {
        this.myCachedStatuses.clear();
    }

    @NotNull
    public String getComponentName() {
        if ("FileStatusManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/impl/FileStatusManagerImpl", "getComponentName"));
        }
        return "FileStatusManager";
    }

    public void initComponent() {
    }

    public void addFileStatusListener(@NotNull FileStatusListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/vcs/impl/FileStatusManagerImpl", "addFileStatusListener"));
        }
        this.myListeners.add(listener);
    }

    public void addFileStatusListener(final @NotNull FileStatusListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/vcs/impl/FileStatusManagerImpl", "addFileStatusListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/vcs/impl/FileStatusManagerImpl", "addFileStatusListener"));
        }
        this.addFileStatusListener(listener);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                FileStatusManagerImpl.this.removeFileStatusListener(listener);
            }
        });
    }

    public void fileStatusesChanged() {
        if (this.myProject.isDisposed()) {
            return;
        }
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            ApplicationManager.getApplication().invokeLater((Runnable)new DumbAwareRunnable(){

                public void run() {
                    FileStatusManagerImpl.this.fileStatusesChanged();
                }
            }, ModalityState.NON_MODAL);
            return;
        }
        this.myCachedStatuses.clear();
        this.myWhetherExactlyParentToChanged.clear();
        for (FileStatusListener listener : this.myListeners) {
            listener.fileStatusesChanged();
        }
    }

    private void cacheChangedFileStatus(VirtualFile virtualFile, FileStatus fs) {
        this.myCachedStatuses.put(virtualFile, fs);
        if (FileStatus.NOT_CHANGED.equals(fs)) {
            ThreeState parentingStatus = this.myFileStatusProvider.getNotChangedDirectoryParentingStatus(virtualFile);
            if (ThreeState.YES.equals((Object)parentingStatus)) {
                this.myWhetherExactlyParentToChanged.put(virtualFile, true);
            } else if (ThreeState.UNSURE.equals((Object)parentingStatus)) {
                this.myWhetherExactlyParentToChanged.put(virtualFile, false);
            }
        } else {
            this.myWhetherExactlyParentToChanged.remove(virtualFile);
        }
    }

    public void fileStatusChanged(final VirtualFile file) {
        Application application = ApplicationManager.getApplication();
        if (!application.isDispatchThread() && !application.isUnitTestMode()) {
            ApplicationManager.getApplication().invokeLater((Runnable)new DumbAwareRunnable(){

                public void run() {
                    FileStatusManagerImpl.this.fileStatusChanged(file);
                }
            });
            return;
        }
        if (file == null || !file.isValid()) {
            return;
        }
        FileStatus cachedStatus = this.getCachedStatus(file);
        if (cachedStatus == FileStatusNull.INSTANCE) {
            return;
        }
        if (cachedStatus == null) {
            this.cacheChangedFileStatus(file, FileStatusNull.INSTANCE);
            return;
        }
        FileStatus newStatus = this.calcStatus(file);
        if (cachedStatus == newStatus) {
            return;
        }
        this.cacheChangedFileStatus(file, newStatus);
        for (FileStatusListener listener : this.myListeners) {
            listener.fileStatusChanged(file);
        }
    }

    public FileStatus getStatus(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/impl/FileStatusManagerImpl", "getStatus"));
        }
        if (file instanceof LightVirtualFile) {
            return FileStatus.NOT_CHANGED;
        }
        FileStatus status = this.getCachedStatus(file);
        if (status == null || status == FileStatusNull.INSTANCE) {
            status = this.calcStatus(file);
            this.cacheChangedFileStatus(file, status);
        }
        return status;
    }

    public FileStatus getCachedStatus(VirtualFile file) {
        return this.myCachedStatuses.get(file);
    }

    public void removeFileStatusListener(@NotNull FileStatusListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/vcs/impl/FileStatusManagerImpl", "removeFileStatusListener"));
        }
        this.myListeners.remove(listener);
    }

    public Color getNotChangedDirectoryColor(@NotNull VirtualFile vf) {
        if (vf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vf", "com/intellij/openapi/vcs/impl/FileStatusManagerImpl", "getNotChangedDirectoryColor"));
        }
        Color notChangedColor = FileStatus.NOT_CHANGED.getColor();
        if (!vf.isDirectory()) {
            return notChangedColor;
        }
        Boolean exactMatch = this.myWhetherExactlyParentToChanged.get(vf);
        return exactMatch == null ? notChangedColor : (exactMatch != false ? FileStatus.NOT_CHANGED_IMMEDIATE.getColor() : FileStatus.NOT_CHANGED_RECURSIVE.getColor());
    }

    public void refreshFileStatusFromDocument(VirtualFile file, Document doc) {
        if (this.myFileStatusProvider != null) {
            this.myFileStatusProvider.refreshFileStatusFromDocument(file, doc);
        }
    }

    private static class FileStatusNull
    implements FileStatus {
        private static final FileStatus INSTANCE = new FileStatusNull();

        private FileStatusNull() {
        }

        public String getText() {
            throw new AssertionError((Object)"Should not be called");
        }

        public Color getColor() {
            throw new AssertionError((Object)"Should not be called");
        }

        @NotNull
        public ColorKey getColorKey() {
            throw new AssertionError((Object)"Should not be called");
        }

        @NotNull
        public String getId() {
            throw new AssertionError((Object)"Should not be called");
        }
    }
}

