/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.ide.ReopenProjectAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.UniqueNameBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WelcomeScreen;
import com.intellij.openapi.wm.impl.welcomeScreen.BottomLineBorder;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenColors;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ListUtil;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.util.Function;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.LineBorder;
import org.jetbrains.annotations.NotNull;

public class RecentProjectPanel
extends JPanel {
    private final JBList myList;
    private final UniqueNameBuilder<ReopenProjectAction> myPathShortener;

    public RecentProjectPanel(WelcomeScreen screen) {
        super(new BorderLayout());
        Object[] recentProjectActions = RecentProjectsManagerBase.getInstance().getRecentProjectsActions(false);
        this.myPathShortener = new UniqueNameBuilder(SystemProperties.getUserHome(), File.separator, 40);
        for (AnAction anAction : recentProjectActions) {
            ReopenProjectAction item = (ReopenProjectAction)anAction;
            this.myPathShortener.addPath((Object)item, item.getProjectPath());
        }
        this.myList = new MyList(recentProjectActions);
        this.myList.setCellRenderer((ListCellRenderer)new RecentProjectItemRenderer());
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                Object selection;
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/wm/impl/welcomeScreen/RecentProjectPanel$1", "onClick"));
                }
                int selectedIndex = RecentProjectPanel.this.myList.getSelectedIndex();
                if (selectedIndex >= 0 && RecentProjectPanel.this.myList.getCellBounds(selectedIndex, selectedIndex).contains(event.getPoint()) && (selection = RecentProjectPanel.this.myList.getSelectedValue()) != null) {
                    ((AnAction)selection).actionPerformed(AnActionEvent.createFromInputEvent((AnAction)((AnAction)selection), (InputEvent)event, (String)"WelcomeScreen"));
                }
                return true;
            }
        }.installOn((Component)this.myList);
        this.myList.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selection = RecentProjectPanel.this.myList.getSelectedValue();
                if (selection != null) {
                    ((AnAction)selection).actionPerformed(AnActionEvent.createFromInputEvent((AnAction)((AnAction)selection), null, (String)"WelcomeScreen"));
                }
            }
        }, KeyStroke.getKeyStroke(10, 0), 1);
        new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                int rc;
                Object[] selection = RecentProjectPanel.this.myList.getSelectedValues();
                if (selection != null && selection.length > 0 && (rc = Messages.showOkCancelDialog((Component)RecentProjectPanel.this, (String)("Remove '" + StringUtil.join((Object[])selection, (Function)new Function<Object, String>(){

                    public String fun(Object action) {
                        return ((ReopenProjectAction)((Object)action)).getTemplatePresentation().getText();
                    }
                }, (String)"'\n'") + "' from recent projects list?"), (String)"Remove Recent Project", (Icon)Messages.getQuestionIcon())) == 0) {
                    RecentProjectsManagerBase manager = RecentProjectsManagerBase.getInstance();
                    for (Object projectAction : selection) {
                        manager.removePath(((ReopenProjectAction)((Object)projectAction)).getProjectPath());
                    }
                    ListUtil.removeSelectedItems((JList)RecentProjectPanel.this.myList);
                }
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/welcomeScreen/RecentProjectPanel$3", "update"));
                }
                e.getPresentation().setEnabled(!ListWithFilter.isSearchActive((JList)RecentProjectPanel.this.myList));
            }
        }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"DELETE", "BACK_SPACE"}), (JComponent)this.myList, (Disposable)screen);
        this.myList.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){
            boolean myIsEngaged = false;

            @Override
            public void mouseMoved(MouseEvent e) {
                if (this.myIsEngaged && !UIUtil.isSelectionButtonDown((MouseEvent)e)) {
                    Point point = e.getPoint();
                    int index = RecentProjectPanel.this.myList.locationToIndex(point);
                    RecentProjectPanel.this.myList.setSelectedIndex(index);
                    Rectangle bounds = RecentProjectPanel.this.myList.getCellBounds(index, index);
                    if (bounds != null && bounds.contains(point)) {
                        RecentProjectPanel.this.myList.setCursor(Cursor.getPredefinedCursor(12));
                    } else {
                        RecentProjectPanel.this.myList.setCursor(Cursor.getPredefinedCursor(0));
                    }
                } else {
                    this.myIsEngaged = true;
                }
            }
        });
        this.myList.setSelectedIndex(0);
        JBScrollPane scroll = new JBScrollPane((Component)this.myList);
        scroll.setBorder(null);
        JBList list = recentProjectActions.length == 0 ? this.myList : ListWithFilter.wrap((JList)this.myList, (JScrollPane)scroll, (Function)new Function<Object, String>(){

            public String fun(Object o) {
                ReopenProjectAction item = (ReopenProjectAction)((Object)o);
                String home = SystemProperties.getUserHome();
                String path = item.getProjectPath();
                if (FileUtil.startsWith((String)path, (String)home)) {
                    path = path.substring(home.length());
                }
                return item.getProjectName() + " " + path;
            }
        });
        this.add((Component)list, "Center");
        JPanel title = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, 28);
            }
        };
        title.setBorder(new BottomLineBorder());
        JLabel jLabel = new JLabel("Recent Projects");
        title.add(jLabel);
        jLabel.setHorizontalAlignment(0);
        jLabel.setForeground(WelcomeScreenColors.CAPTION_FOREGROUND);
        title.setBackground(WelcomeScreenColors.CAPTION_BACKGROUND);
        this.add((Component)title, "North");
        this.setBorder(new LineBorder(WelcomeScreenColors.BORDER_COLOR));
    }

    private String getTitle2Text(ReopenProjectAction action, JComponent pathLabel) {
        String fullText = action.getProjectPath();
        if (fullText == null || fullText.length() == 0) {
            return " ";
        }
        fullText = FileUtil.getLocationRelativeToUserHome((String)fullText, (boolean)false);
        int labelWidth = pathLabel.getWidth();
        if (pathLabel.getFontMetrics(pathLabel.getFont()).stringWidth(fullText) > labelWidth) {
            return this.myPathShortener.getShortPath((Object)action);
        }
        return fullText;
    }

    private class RecentProjectItemRenderer
    extends JPanel
    implements ListCellRenderer {
        private final JLabel myName;
        private final JLabel myPath;

        private RecentProjectItemRenderer() {
            super((LayoutManager)new VerticalFlowLayout());
            this.myName = new JLabel();
            this.myPath = new JLabel();
            this.setFocusable(true);
            this.myPath.setFont(this.myPath.getFont().deriveFont(10.0f));
            this.add(this.myName);
            this.add(this.myPath);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ReopenProjectAction item = (ReopenProjectAction)((Object)value);
            Color fore = UIUtil.getListForeground((boolean)isSelected);
            Color back = UIUtil.getListBackground((boolean)isSelected);
            this.myName.setForeground(fore);
            this.myPath.setForeground(isSelected ? fore : UIUtil.getInactiveTextColor());
            this.setBackground(back);
            this.myName.setText(item.getProjectName());
            this.myPath.setText(RecentProjectPanel.this.getTitle2Text(item, this.myPath));
            return this;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            return new Dimension(Math.min(size.width, 245), size.height);
        }
    }

    private static class MyList
    extends JBList {
        private MyList(Object ... listData) {
            if (listData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listData", "com/intellij/openapi/wm/impl/welcomeScreen/RecentProjectPanel$MyList", "<init>"));
            }
            super(listData);
            this.setEmptyText("  No Project Open Yet  ");
            this.setSelectionMode(2);
        }

        public Dimension getPreferredScrollableViewportSize() {
            return new Dimension(250, 400);
        }
    }
}

