/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class VariableInIncompleteCodeSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public VariableInIncompleteCodeSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters p, final @NotNull Processor<PsiReference> consumer) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/psi/impl/search/VariableInIncompleteCodeSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/VariableInIncompleteCodeSearcher", "processQuery"));
        }
        final PsiElement refElement = p.getElementToSearch();
        if (!refElement.isValid() || !(refElement instanceof PsiLocalVariable) && !(refElement instanceof PsiParameter)) {
            return;
        }
        final String name = ((PsiVariable)refElement).getName();
        if (name == null) {
            return;
        }
        SearchScope scope = p.getEffectiveSearchScope();
        if (!(scope instanceof LocalSearchScope)) {
            return;
        }
        PsiElement[] elements = ((LocalSearchScope)scope).getScope();
        if (elements.length == 0) {
            return;
        }
        PsiElementProcessor processor = new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement element) {
                PsiJavaCodeReferenceElement ref;
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/search/VariableInIncompleteCodeSearcher$1", "execute"));
                }
                if (element instanceof PsiJavaCodeReferenceElement && !(ref = (PsiJavaCodeReferenceElement)element).isQualified() && name.equals(ref.getText()) && !(ref.getParent() instanceof PsiMethodCallExpression) && ref.resolve() == null && ref.advancedResolve(true).getElement() == refElement) {
                    consumer.process((Object)ref);
                }
                return true;
            }
        };
        for (PsiElement element : elements) {
            if (!element.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) continue;
            PsiTreeUtil.processElements((PsiElement)element, (PsiElementProcessor)processor);
        }
    }
}

