/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDiamondTypeImpl;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiDiamondTypeElementImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiTypeElementImpl
extends CompositePsiElement
implements PsiTypeElement {
    private volatile PsiType myCachedType = null;

    public PsiTypeElementImpl() {
        this(JavaElementType.TYPE);
    }

    protected PsiTypeElementImpl(IElementType type) {
        super(type);
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myCachedType = null;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/PsiTypeElementImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitTypeElement((PsiTypeElement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public PsiType getType() {
        PsiType cachedType = this.myCachedType;
        if (cachedType != null) {
            PsiType psiType = cachedType;
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiTypeElementImpl", "getType"));
            }
            return psiType;
        }
        this.myCachedType = cachedType = this.calculateType();
        PsiType psiType = cachedType;
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiTypeElementImpl", "getType"));
        }
        return psiType;
    }

    private PsiType calculateType() {
        Object type = null;
        SmartList annotations = new SmartList();
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            List<PsiType> types;
            PsiAnnotation[] array;
            if (child instanceof PsiComment || child instanceof PsiWhiteSpace) continue;
            if (child instanceof PsiAnnotation) {
                annotations.add((Object)((PsiAnnotation)child));
            } else if (child instanceof PsiTypeElement) {
                assert (type == null) : this;
                if (child instanceof PsiDiamondTypeElementImpl) {
                    type = new PsiDiamondTypeImpl(this.getManager(), this);
                    break;
                }
                type = ((PsiTypeElement)child).getType();
            } else if (PsiUtil.isJavaToken((PsiElement)child, (TokenSet)ElementType.PRIMITIVE_TYPE_BIT_SET)) {
                assert (type == null) : this;
                this.addTypeUseAnnotations((List<PsiAnnotation>)annotations);
                array = (PsiAnnotation[])ContainerUtil.copyAndClear((Collection)annotations, (ArrayFactory)PsiAnnotation.ARRAY_FACTORY, (boolean)true);
                type = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createPrimitiveType(child.getText(), array);
            } else if (child instanceof PsiJavaCodeReferenceElement) {
                assert (type == null) : this;
                this.addTypeUseAnnotations((List<PsiAnnotation>)annotations);
                array = (PsiAnnotation[])ContainerUtil.copyAndClear((Collection)annotations, (ArrayFactory)PsiAnnotation.ARRAY_FACTORY, (boolean)true);
                type = new PsiClassReferenceType((PsiJavaCodeReferenceElement)child, null, array);
            } else if (PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.LBRACKET)) {
                assert (type != null) : this;
                array = (PsiAnnotation[])ContainerUtil.copyAndClear((Collection)annotations, (ArrayFactory)PsiAnnotation.ARRAY_FACTORY, (boolean)true);
                type = type.createArrayType(array);
            } else if (PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.ELLIPSIS)) {
                assert (type != null) : this;
                array = (PsiAnnotation[])ContainerUtil.copyAndClear((Collection)annotations, (ArrayFactory)PsiAnnotation.ARRAY_FACTORY, (boolean)true);
                type = PsiEllipsisType.createEllipsis((PsiType)type, (PsiAnnotation[])array);
            }
            if (PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.QUEST)) {
                assert (type == null) : this;
                PsiElement boundKind = PsiTreeUtil.skipSiblingsForward((PsiElement)child, (Class[])new Class[]{PsiComment.class, PsiWhiteSpace.class});
                PsiElement boundType = PsiTreeUtil.skipSiblingsForward((PsiElement)boundKind, (Class[])new Class[]{PsiComment.class, PsiWhiteSpace.class});
                type = PsiUtil.isJavaToken((PsiElement)boundKind, (IElementType)JavaTokenType.EXTENDS_KEYWORD) && boundType instanceof PsiTypeElement ? PsiWildcardType.createExtends((PsiManager)this.getManager(), (PsiType)((PsiTypeElement)boundType).getType()) : (PsiUtil.isJavaToken((PsiElement)boundKind, (IElementType)JavaTokenType.SUPER_KEYWORD) && boundType instanceof PsiTypeElement ? PsiWildcardType.createSuper((PsiManager)this.getManager(), (PsiType)((PsiTypeElement)boundType).getType()) : PsiWildcardType.createUnbounded((PsiManager)this.getManager()));
                PsiAnnotation[] array2 = (PsiAnnotation[])ContainerUtil.copyAndClear((Collection)annotations, (ArrayFactory)PsiAnnotation.ARRAY_FACTORY, (boolean)true);
                type = ((PsiWildcardType)type).annotate(array2);
                break;
            }
            if (PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.AND)) {
                types = this.collectTypes();
                assert (!types.isEmpty()) : this;
                type = PsiIntersectionType.createIntersection(types);
                break;
            }
            if (!PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.OR)) continue;
            types = this.collectTypes();
            assert (!types.isEmpty()) : this;
            type = PsiDisjunctionType.createDisjunction(types, (PsiManager)this.getManager());
            break;
        }
        return type == null ? PsiType.NULL : type;
    }

    private void addTypeUseAnnotations(List<PsiAnnotation> list) {
        PsiTypeElementImpl parent = this;
        while (parent instanceof PsiTypeElement) {
            PsiElement left = PsiTreeUtil.skipSiblingsBackward((PsiElement)parent, (Class[])new Class[]{PsiComment.class, PsiWhiteSpace.class, PsiAnnotation.class});
            if (left instanceof PsiModifierList) {
                List<PsiAnnotation> annotations = PsiImplUtil.getTypeUseAnnotations((PsiModifierList)left);
                if (annotations == null || annotations.isEmpty()) break;
                list.addAll(annotations);
                break;
            }
            if (left != null) break;
            parent = parent.getParent();
        }
    }

    private List<PsiType> collectTypes() {
        List typeElements = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, PsiTypeElement.class);
        return ContainerUtil.map((Collection)typeElements, (Function)new Function<PsiTypeElement, PsiType>(){

            public PsiType fun(PsiTypeElement typeElement) {
                return typeElement.getType();
            }
        });
    }

    public PsiJavaCodeReferenceElement getInnermostComponentReferenceElement() {
        TreeElement firstChildNode = this.getFirstChildNode();
        if (firstChildNode == null) {
            return null;
        }
        if (firstChildNode.getElementType() == JavaElementType.TYPE) {
            return ((PsiTypeElement)SourceTreeToPsiMap.treeToPsiNotNull(firstChildNode)).getInnermostComponentReferenceElement();
        }
        return this.getReferenceElement();
    }

    @Nullable
    private PsiJavaCodeReferenceElement getReferenceElement() {
        ASTNode ref = this.findChildByType(JavaElementType.JAVA_CODE_REFERENCE);
        if (ref == null) {
            return null;
        }
        return (PsiJavaCodeReferenceElement)SourceTreeToPsiMap.treeElementToPsi(ref);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/source/PsiTypeElementImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/source/PsiTypeElementImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/source/PsiTypeElementImpl", "processDeclarations"));
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        return true;
    }

    @NotNull
    public PsiAnnotation[] getAnnotations() {
        PsiAnnotation[] annotations = (PsiAnnotation[])PsiTreeUtil.getChildrenOfType((PsiElement)this, PsiAnnotation.class);
        PsiAnnotation[] psiAnnotationArray = annotations != null ? annotations : PsiAnnotation.EMPTY_ARRAY;
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiTypeElementImpl", "getAnnotations"));
        }
        return psiAnnotationArray;
    }

    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        List annotations = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, PsiAnnotation.class);
        this.addTypeUseAnnotations(annotations);
        PsiAnnotation[] psiAnnotationArray = (PsiAnnotation[])annotations.toArray(PsiAnnotation.ARRAY_FACTORY.create(annotations.size()));
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiTypeElementImpl", "getApplicableAnnotations"));
        }
        return psiAnnotationArray;
    }

    public PsiAnnotation findAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/source/PsiTypeElementImpl", "findAnnotation"));
        }
        return PsiImplUtil.findAnnotation((PsiAnnotationOwner)this, qualifiedName);
    }

    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/source/PsiTypeElementImpl", "addAnnotation"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        PsiExpression methodCallCandidate;
        PsiVariable variable;
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/psi/impl/source/PsiTypeElementImpl", "replace"));
        }
        PsiImplUtil.markTypeAnnotations(this);
        PsiElement result = super.replace(newElement);
        PsiImplUtil.deleteTypeAnnotations((PsiTypeElement)result);
        PsiElement parent = result.getParent();
        if (parent instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent;
            CodeEditUtil.markToReformat(method.getParameterList().getNode(), true);
        } else if (parent instanceof PsiVariable && (variable = (PsiVariable)parent).hasInitializer() && (methodCallCandidate = variable.getInitializer()) instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)methodCallCandidate;
            CodeEditUtil.markToReformat(methodCallExpression.getArgumentList().getNode(), true);
        }
        return result;
    }

    @Override
    public String toString() {
        return "PsiTypeElement:" + this.getText();
    }
}

