/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.parsing.xml;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.dtd.DTDLanguage;
import com.intellij.lexer.DtdLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.parsing.xml.XmlParsing;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlEntityDecl;
import org.jetbrains.annotations.NotNull;

public class DtdParsing
extends XmlParsing
implements XmlElementType {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.parsing.xml.XmlParser");
    private final IElementType myRootType;
    public static final XmlEntityDecl.EntityContextType TYPE_FOR_MARKUP_DECL = XmlEntityDecl.EntityContextType.ELEMENT_CONTENT_SPEC;
    private final XmlEntityDecl.EntityContextType myContextType;

    public DtdParsing(IElementType root, XmlEntityDecl.EntityContextType contextType, PsiBuilder builder) {
        super(builder);
        this.myRootType = root;
        this.myContextType = contextType;
        this.myBuilder.enforceCommentTokens(TokenSet.EMPTY);
    }

    public DtdParsing(CharSequence chars, final IElementType type, final XmlEntityDecl.EntityContextType contextType, PsiFile contextFile) {
        this(type, contextType, PsiBuilderFactory.getInstance().createBuilder((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)DTDLanguage.INSTANCE), (Lexer)new DtdLexer(false){
            final int myInitialState;
            {
                super(x0);
                this.myInitialState = DtdParsing.getLexerInitialState(type, contextType);
            }

            public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
                if (buffer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/psi/impl/source/parsing/xml/DtdParsing$1", "start"));
                }
                super.start(buffer, startOffset, endOffset, this.myInitialState);
            }
        }, chars));
        if (contextFile != null) {
            this.myBuilder.putUserDataUnprotected(FileContextUtil.CONTAINING_FILE_KEY, (Object)contextFile);
        }
    }

    public ASTNode parse() {
        PsiFile file;
        PsiBuilder.Marker root = this.myBuilder.mark();
        if (this.myRootType == XML_MARKUP_DECL) {
            this.parseTopLevelMarkupDecl();
            root.done(this.myRootType);
            return this.myBuilder.getTreeBuilt();
        }
        PsiBuilder.Marker document = null;
        if (this.myRootType == DTD_FILE) {
            document = this.myBuilder.mark();
            this.parseProlog();
        }
        switch (this.myContextType) {
            case GENERIC_XML: {
                this.parseGenericXml();
                break;
            }
            case ELEMENT_CONTENT_SPEC: {
                this.doParseContentSpec(true);
                break;
            }
            case ATTLIST_SPEC: {
                this.parseAttlistContent();
                break;
            }
            case ATTR_VALUE: {
                this.parseAttrValue();
            }
            case ATTRIBUTE_SPEC: {
                this.parseAttributeContentSpec();
                break;
            }
            case ENTITY_DECL_CONTENT: {
                this.parseEntityDeclContent();
                break;
            }
            case ENUMERATED_TYPE: {
                this.parseEnumeratedTypeContent();
            }
        }
        while (!this.myBuilder.eof()) {
            this.myBuilder.advanceLexer();
        }
        if (document != null) {
            document.done(XML_DOCUMENT);
        }
        root.done(this.myRootType);
        ASTNode astNode = this.myBuilder.getTreeBuilt();
        if (this.myRootType != DTD_FILE && (file = (PsiFile)this.myBuilder.getUserDataUnprotected(FileContextUtil.CONTAINING_FILE_KEY)) != null) {
            DummyHolder result = DummyHolderFactory.createHolder(file.getManager(), (Language)DTDLanguage.INSTANCE, (PsiElement)file);
            FileElement holder = result.getTreeElement();
            holder.rawAddChildren((TreeElement)astNode);
        }
        return astNode;
    }

    private static int getLexerInitialState(IElementType rootNodeType, XmlEntityDecl.EntityContextType context) {
        int state = 0;
        switch (context) {
            case ELEMENT_CONTENT_SPEC: 
            case ATTLIST_SPEC: 
            case ATTRIBUTE_SPEC: 
            case ENTITY_DECL_CONTENT: 
            case ENUMERATED_TYPE: {
                state = 30;
                break;
            }
            case GENERIC_XML: 
            case ATTR_VALUE: {
                break;
            }
            default: {
                LOG.error("context: " + context);
            }
        }
        if (rootNodeType == XML_MARKUP_DECL && context == TYPE_FOR_MARKUP_DECL) {
            state = 26;
        }
        return state;
    }

    private void parseGenericXml() {
        IElementType tokenType;
        while ((tokenType = this.myBuilder.getTokenType()) != null) {
            if (tokenType == XML_ATTLIST_DECL_START) {
                this.parseAttlistDecl();
                continue;
            }
            if (tokenType == XML_ELEMENT_DECL_START) {
                this.parseElementDecl();
                continue;
            }
            if (tokenType == XML_ENTITY_DECL_START) {
                this.parseEntityDecl();
                continue;
            }
            if (tokenType == XML_NOTATION_DECL_START) {
                this.parseNotationDecl();
                continue;
            }
            if (tokenType == XML_ENTITY_REF_TOKEN) {
                this.parseEntityRef();
                continue;
            }
            if (this.parseProcessingInstruction()) continue;
            if (tokenType == XML_START_TAG_START) {
                this.parseTag(false);
                continue;
            }
            if (this.isCommentToken(tokenType)) {
                this.parseComment();
                continue;
            }
            if (this.parseConditionalSection() || tokenType == null) continue;
            this.addToken();
        }
    }

    private void parseNotationDecl() {
        if (this.myBuilder.getTokenType() != XML_NOTATION_DECL_START) {
            return;
        }
        PsiBuilder.Marker decl = this.myBuilder.mark();
        this.addToken();
        if (!this.parseName()) {
            decl.done(XML_NOTATION_DECL);
            return;
        }
        this.parseEntityDeclContent();
        if (this.myBuilder.getTokenType() != null) {
            this.addToken();
        }
        decl.done(XML_NOTATION_DECL);
    }

    private void parseEntityDecl() {
        if (this.myBuilder.getTokenType() != XML_ENTITY_DECL_START) {
            return;
        }
        PsiBuilder.Marker decl = this.myBuilder.mark();
        this.addToken();
        if (this.myBuilder.getTokenType() == XML_PERCENT) {
            this.addToken();
        }
        if (this.parseCompositeName()) {
            decl.done(XML_ENTITY_DECL);
            return;
        }
        this.parseEntityDeclContent();
        if (this.myBuilder.getTokenType() != null) {
            this.addToken();
        }
        decl.done(XML_ENTITY_DECL);
    }

    private boolean parseCompositeName() {
        if (!this.parseName()) {
            if (this.myBuilder.getTokenType() == XML_LEFT_PAREN) {
                this.parseGroup();
            } else {
                this.myBuilder.error(XmlErrorMessages.message("dtd.parser.message.name.expected", new Object[0]));
                return true;
            }
        }
        return false;
    }

    private void parseEntityDeclContent() {
        IElementType tokenType = this.myBuilder.getTokenType();
        if (tokenType != XML_ATTRIBUTE_VALUE_START_DELIMITER && tokenType != XML_DOCTYPE_PUBLIC && tokenType != XML_DOCTYPE_SYSTEM) {
            this.myBuilder.error(XmlErrorMessages.message("dtd.parser.message.literal.public.system.expected", new Object[0]));
            return;
        }
        while (tokenType != XML_TAG_END && tokenType != null) {
            if (tokenType == XML_ATTRIBUTE_VALUE_START_DELIMITER) {
                this.parseAttributeValue();
            } else {
                this.addToken();
            }
            tokenType = this.myBuilder.getTokenType();
        }
    }

    private boolean parseConditionalSection() {
        if (this.myBuilder.getTokenType() != XML_CONDITIONAL_SECTION_START) {
            return false;
        }
        PsiBuilder.Marker conditionalSection = this.myBuilder.mark();
        this.addToken();
        IElementType tokenType = this.myBuilder.getTokenType();
        if (tokenType != XML_CONDITIONAL_IGNORE && tokenType != XML_CONDITIONAL_INCLUDE && tokenType != XML_ENTITY_REF_TOKEN) {
            conditionalSection.done(XML_CONDITIONAL_SECTION);
            return true;
        }
        if (tokenType == XML_ENTITY_REF_TOKEN) {
            this.parseEntityRef();
        } else {
            this.addToken();
        }
        if (this.myBuilder.getTokenType() != XML_MARKUP_START) {
            conditionalSection.done(XML_CONDITIONAL_SECTION);
            return true;
        }
        this.parseMarkupContent();
        if (this.myBuilder.getTokenType() != XML_CONDITIONAL_SECTION_END) {
            conditionalSection.done(XML_CONDITIONAL_SECTION);
            return true;
        }
        this.addToken();
        conditionalSection.done(XML_CONDITIONAL_SECTION);
        return true;
    }

    private boolean parseProcessingInstruction() {
        if (this.myBuilder.getTokenType() != XML_PI_START) {
            return false;
        }
        PsiBuilder.Marker tag = this.myBuilder.mark();
        this.addToken();
        if (this.myBuilder.getTokenType() != XML_PI_TARGET) {
            tag.done(XML_PROCESSING_INSTRUCTION);
            return true;
        }
        this.addToken();
        if (this.myBuilder.getTokenType() != XML_PI_END) {
            tag.done(XML_PROCESSING_INSTRUCTION);
            return true;
        }
        this.addToken();
        tag.done(XML_PROCESSING_INSTRUCTION);
        return true;
    }

    private void parseEntityRef() {
        PsiBuilder.Marker ref = this.myBuilder.mark();
        if (this.myBuilder.getTokenType() == XML_ENTITY_REF_TOKEN) {
            this.addToken();
        }
        ref.done(XML_ENTITY_REF);
    }

    private void parseProlog() {
        PsiBuilder.Marker prolog = this.myBuilder.mark();
        while (this.parseProcessingInstruction()) {
        }
        if (this.myBuilder.getTokenType() == XML_DECL_START) {
            this.parseDecl();
        }
        while (this.parseProcessingInstruction()) {
        }
        if (this.myBuilder.getTokenType() == XML_DOCTYPE_START) {
            this.parseDocType();
        }
        while (this.parseProcessingInstruction()) {
        }
        prolog.done(XML_PROLOG);
    }

    private void parseDocType() {
        if (this.myBuilder.getTokenType() != XML_DOCTYPE_START) {
            return;
        }
        PsiBuilder.Marker docType = this.myBuilder.mark();
        this.addToken();
        if (this.myBuilder.getTokenType() != XML_NAME) {
            docType.done(XML_DOCTYPE);
            return;
        }
        this.addToken();
        if (this.myBuilder.getTokenType() == XML_DOCTYPE_SYSTEM) {
            this.addToken();
            if (this.myBuilder.getTokenType() == XML_ATTRIBUTE_VALUE_TOKEN) {
                this.addToken();
            }
        } else if (this.myBuilder.getTokenType() == XML_DOCTYPE_PUBLIC) {
            this.addToken();
            if (this.myBuilder.getTokenType() == XML_ATTRIBUTE_VALUE_TOKEN) {
                this.addToken();
            }
            if (this.myBuilder.getTokenType() == XML_ATTRIBUTE_VALUE_TOKEN) {
                this.addToken();
            }
        }
        if (this.myBuilder.getTokenType() == XML_MARKUP_START) {
            this.parseMarkupDecl();
        }
        if (this.myBuilder.getTokenType() != XML_DOCTYPE_END) {
            docType.done(XML_DOCTYPE);
            return;
        }
        this.addToken();
        docType.done(XML_DOCTYPE);
    }

    private void parseMarkupDecl() {
        PsiBuilder.Marker decl = this.myBuilder.mark();
        this.parseMarkupContent();
        decl.done(XML_MARKUP_DECL);
    }

    private void parseMarkupContent() {
        IElementType tokenType = this.myBuilder.getTokenType();
        if (tokenType == XML_MARKUP_START) {
            this.addToken();
        }
        while (true) {
            if ((tokenType = this.myBuilder.getTokenType()) == XML_ELEMENT_DECL_START) {
                this.parseElementDecl();
                continue;
            }
            if (tokenType == XML_ATTLIST_DECL_START) {
                this.parseAttlistDecl();
                continue;
            }
            if (tokenType == XML_ENTITY_DECL_START) {
                this.parseEntityDecl();
                continue;
            }
            if (tokenType == XML_NOTATION_DECL_START) {
                this.parseNotationDecl();
                continue;
            }
            if (tokenType == XML_ENTITY_REF_TOKEN) {
                this.parseEntityRef();
                continue;
            }
            if (tokenType == XML_COMMENT_START) {
                this.parseComment();
                continue;
            }
            if (!this.parseConditionalSection()) break;
        }
        if (tokenType == XML_MARKUP_END) {
            this.addToken();
        }
    }

    private void parseElementDecl() {
        if (this.myBuilder.getTokenType() != XML_ELEMENT_DECL_START) {
            return;
        }
        PsiBuilder.Marker decl = this.myBuilder.mark();
        this.addToken();
        if (this.parseCompositeName()) {
            decl.done(XML_ELEMENT_DECL);
            return;
        }
        this.doParseContentSpec(false);
        this.skipTillEndOfBlock();
        decl.done(XML_ELEMENT_DECL);
    }

    private void skipTillEndOfBlock() {
        while (!this.myBuilder.eof() && this.myBuilder.getTokenType() != XML_TAG_END && !this.isAnotherDeclStart(this.myBuilder.getTokenType())) {
            if (this.myBuilder.getTokenType() == XML_COMMENT_START) {
                this.parseComment();
                continue;
            }
            this.addToken();
        }
        if (this.myBuilder.getTokenType() == XML_TAG_END) {
            this.addToken();
        }
    }

    private boolean isAnotherDeclStart(IElementType type) {
        return type == XML_ATTLIST_DECL_START || type == XML_ELEMENT_DECL_START;
    }

    private boolean parseName() {
        IElementType type = this.myBuilder.getTokenType();
        if (type == XML_NAME) {
            this.addToken();
            return true;
        }
        if (type == XML_ENTITY_REF_TOKEN) {
            this.parseEntityRef();
            return true;
        }
        return this.consumeKeywordAsName(type);
    }

    private boolean consumeKeywordAsName(IElementType type) {
        if (type == XML_DOCTYPE_PUBLIC || type == XML_DOCTYPE_SYSTEM || type == XML_CONTENT_EMPTY || type == XML_CONTENT_ANY) {
            this.myBuilder.remapCurrentToken(XML_NAME);
            this.addToken();
            return true;
        }
        return false;
    }

    private void doParseContentSpec(boolean topLevel) {
        String tokenText;
        IElementType tokenType;
        if (!topLevel && this.myBuilder.rawLookup(0) != XML_WHITE_SPACE) {
            this.myBuilder.error(XmlErrorMessages.message("dtd.parser.message.whitespace.expected", new Object[0]));
        } else if (!(topLevel || (tokenType = this.myBuilder.getTokenType()) == XML_LEFT_PAREN || tokenType == XML_ENTITY_REF_TOKEN || tokenType == XML_CONTENT_ANY || tokenType == XML_CONTENT_EMPTY || tokenType == XML_NAME && ("-".equals(tokenText = this.myBuilder.getTokenText()) || "O".equals(tokenText)))) {
            PsiBuilder.Marker spec = this.myBuilder.mark();
            spec.done(XML_ELEMENT_CONTENT_SPEC);
            this.myBuilder.error(XmlErrorMessages.message("dtd.parser.message.left.paren.or.entityref.or.empty.or.any.expected", new Object[0]));
            return;
        }
        PsiBuilder.Marker spec = this.myBuilder.mark();
        this.parseElementContentSpecInner(topLevel);
        spec.done(XML_ELEMENT_CONTENT_SPEC);
    }

    private boolean parseElementContentSpecInner(boolean topLevel) {
        IElementType tokenType = this.myBuilder.getTokenType();
        boolean endedWithDelimiter = false;
        while (tokenType != null && tokenType != XML_TAG_END && tokenType != XML_START_TAG_START && tokenType != XML_ELEMENT_DECL_START && tokenType != XML_RIGHT_PAREN && tokenType != XML_COMMENT_START) {
            if (tokenType == XML_BAR && topLevel) {
                this.addToken();
                tokenType = this.myBuilder.getTokenType();
                continue;
            }
            if (tokenType == XML_LEFT_PAREN) {
                if (!this.parseGroup()) {
                    return false;
                }
                endedWithDelimiter = false;
            } else if (tokenType == XML_ENTITY_REF_TOKEN) {
                this.parseEntityRef();
                endedWithDelimiter = false;
            } else if (tokenType == XML_NAME || tokenType == XML_CONTENT_EMPTY || tokenType == XML_CONTENT_ANY || tokenType == XML_PCDATA) {
                this.addToken();
                endedWithDelimiter = false;
            } else if (this.consumeKeywordAsName(tokenType)) {
                endedWithDelimiter = false;
            } else {
                this.myBuilder.error(XmlErrorMessages.message("dtd.parser.message.name.or.entity.ref.expected", new Object[0]));
                return false;
            }
            tokenType = this.myBuilder.getTokenType();
            if (tokenType == XML_STAR || tokenType == XML_PLUS || tokenType == XML_QUESTION) {
                this.addToken();
                tokenType = this.myBuilder.getTokenType();
                if (tokenType == XML_PLUS) {
                    this.addToken();
                    tokenType = this.myBuilder.getTokenType();
                }
            }
            if (tokenType != XML_BAR && tokenType != XML_COMMA) continue;
            this.addToken();
            tokenType = this.myBuilder.getTokenType();
            endedWithDelimiter = true;
        }
        if (endedWithDelimiter && tokenType == XML_RIGHT_PAREN) {
            this.myBuilder.error(XmlErrorMessages.message("dtd.parser.message.name.or.entity.ref.expected", new Object[0]));
        }
        return true;
    }

    private boolean parseGroup() {
        PsiBuilder.Marker group = this.myBuilder.mark();
        this.addToken();
        boolean b = this.parseElementContentSpecInner(false);
        if (b && this.myBuilder.getTokenType() == XML_RIGHT_PAREN) {
            this.addToken();
            group.done(XML_ELEMENT_CONTENT_GROUP);
            return true;
        }
        if (b) {
            this.myBuilder.error(XmlErrorMessages.message("dtd.parser.message.rbrace.expected", new Object[0]));
            group.done(XML_ELEMENT_CONTENT_GROUP);
            return false;
        }
        group.done(XML_ELEMENT_CONTENT_GROUP);
        return b;
    }

    private void parseAttlistDecl() {
        if (this.myBuilder.getTokenType() != XML_ATTLIST_DECL_START) {
            return;
        }
        PsiBuilder.Marker decl = this.myBuilder.mark();
        this.addToken();
        if (!this.parseName()) {
            IElementType tokenType = this.myBuilder.getTokenType();
            if (tokenType == XML_LEFT_PAREN) {
                this.parseGroup();
            } else {
                this.myBuilder.error(XmlErrorMessages.message("dtd.parser.message.name.expected", new Object[0]));
                decl.done(XML_ATTLIST_DECL);
                return;
            }
        }
        this.parseAttlistContent();
        this.skipTillEndOfBlock();
        decl.done(XML_ATTLIST_DECL);
    }

    private void parseAttlistContent() {
        while (true) {
            if (this.myBuilder.getTokenType() == XML_ENTITY_REF_TOKEN) {
                this.parseEntityRef();
                continue;
            }
            if (this.myBuilder.getTokenType() == XML_COMMENT_START) {
                this.parseComment();
                continue;
            }
            if (!this.parseAttributeDecl()) break;
        }
    }

    private boolean parseAttributeDecl() {
        if (this.myBuilder.getTokenType() != XML_NAME) {
            return false;
        }
        PsiBuilder.Marker decl = this.myBuilder.mark();
        this.addToken();
        boolean b = this.parseAttributeContentSpec();
        decl.done(XML_ATTRIBUTE_DECL);
        return b;
    }

    private boolean parseAttributeContentSpec() {
        if (!this.parseName()) {
            if (this.myBuilder.getTokenType() == XML_LEFT_PAREN) {
                this.parseEnumeratedType();
            } else {
                return true;
            }
        }
        if (this.myBuilder.getTokenType() == XML_ATT_IMPLIED) {
            this.addToken();
        } else if (this.myBuilder.getTokenType() == XML_ATT_REQUIRED) {
            this.addToken();
        } else if (this.myBuilder.getTokenType() == XML_ATT_FIXED) {
            this.addToken();
            if (this.myBuilder.getTokenType() == XML_ATTRIBUTE_VALUE_START_DELIMITER) {
                this.parseAttributeValue();
            }
        } else if (this.myBuilder.getTokenType() == XML_ATTRIBUTE_VALUE_START_DELIMITER) {
            this.parseAttributeValue();
        }
        return true;
    }

    private void parseEnumeratedType() {
        PsiBuilder.Marker enumeratedType = this.myBuilder.mark();
        this.addToken();
        this.parseEnumeratedTypeContent();
        if (this.myBuilder.getTokenType() == XML_RIGHT_PAREN) {
            this.addToken();
        }
        enumeratedType.done(XML_ENUMERATED_TYPE);
    }

    private void parseEnumeratedTypeContent() {
        while (true) {
            if (this.myBuilder.getTokenType() == XML_ENTITY_REF_TOKEN) {
                this.parseEntityRef();
                continue;
            }
            if (this.myBuilder.getTokenType() != XML_NAME && this.myBuilder.getTokenType() != XML_BAR) break;
            this.addToken();
        }
    }

    private void parseDecl() {
        if (this.myBuilder.getTokenType() != XML_DECL_START) {
            return;
        }
        PsiBuilder.Marker decl = this.myBuilder.mark();
        this.addToken();
        this.parseAttributeList();
        if (this.myBuilder.getTokenType() == XML_DECL_END) {
            this.addToken();
        } else {
            this.myBuilder.error(XmlErrorMessages.message("expected.prologue.tag.termination.expected", new Object[0]));
        }
        decl.done(XML_DECL);
    }

    private void parseAttributeList() {
        int lastPosition = -1;
        while (true) {
            if (this.myBuilder.getTokenType() == XML_ENTITY_REF_TOKEN) {
                this.parseEntityRef();
                continue;
            }
            if (this.myBuilder.getTokenType() != XML_NAME) {
                return;
            }
            if (lastPosition != -1 && lastPosition == this.myBuilder.getCurrentOffset()) {
                this.myBuilder.error(XmlErrorMessages.message("expected.whitespace", new Object[0]));
                lastPosition = -1;
            }
            this.addToken();
            if (this.myBuilder.getTokenType() != XML_EQ) {
                this.myBuilder.error(XmlErrorMessages.message("expected.attribute.eq.sign", new Object[0]));
                continue;
            }
            this.addToken();
            if (this.myBuilder.getTokenType() != XML_ATTRIBUTE_VALUE_START_DELIMITER) {
                return;
            }
            this.addToken();
            if (this.myBuilder.getTokenType() == XML_ATTRIBUTE_VALUE_TOKEN) {
                this.addToken();
                if (this.myBuilder.getTokenType() == XML_ATTRIBUTE_VALUE_END_DELIMITER) {
                    lastPosition = this.myBuilder.getCurrentOffset();
                    this.addToken();
                    continue;
                }
                lastPosition = -1;
                continue;
            }
            if (this.myBuilder.getTokenType() == XML_ATTRIBUTE_VALUE_END_DELIMITER) {
                lastPosition = this.myBuilder.getCurrentOffset();
                this.addToken();
                continue;
            }
            lastPosition = -1;
        }
    }

    private int parseAttributeValue() {
        if (this.myBuilder.getTokenType() != XML_ATTRIBUTE_VALUE_START_DELIMITER) {
            return -1;
        }
        PsiBuilder.Marker value = this.myBuilder.mark();
        this.addToken();
        while (true) {
            if (this.myBuilder.getTokenType() == XML_ATTRIBUTE_VALUE_TOKEN) {
                this.addToken();
                continue;
            }
            if (this.myBuilder.getTokenType() == XML_CHAR_ENTITY_REF) {
                this.addToken();
                continue;
            }
            if (this.myBuilder.getTokenType() != XML_ENTITY_REF_TOKEN) break;
            this.parseEntityRef();
        }
        if (this.myBuilder.getTokenType() != XML_ATTRIBUTE_VALUE_END_DELIMITER) {
            value.done(XML_ATTRIBUTE_VALUE);
            return -1;
        }
        int tokenEnd = this.myBuilder.getCurrentOffset();
        this.addToken();
        value.done(XML_ATTRIBUTE_VALUE);
        return tokenEnd;
    }

    private void addToken() {
        this.myBuilder.advanceLexer();
    }

    private void parseTopLevelMarkupDecl() {
        this.parseMarkupContent();
        while (this.myBuilder.getTokenType() != null) {
            if (this.myBuilder.getTokenType() == XML_ENTITY_REF_TOKEN) {
                this.parseEntityRef();
                continue;
            }
            if (this.myBuilder.getTokenType() == XML_ENTITY_DECL_START) {
                this.parseEntityDecl();
                continue;
            }
            this.myBuilder.advanceLexer();
        }
    }

    private void parseAttrValue() {
        while (this.myBuilder.getTokenType() != null) {
            if (this.myBuilder.getTokenType() == XML_ENTITY_REF_TOKEN) {
                this.parseEntityRef();
                continue;
            }
            this.addToken();
        }
    }
}

