/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.execution.ExecutionException;
import java.net.NoRouteToHostException;

public class RemoteSdkException
extends ExecutionException {
    private final boolean myNoRouteToHost;
    private final boolean myAuthFailed;

    public RemoteSdkException(String s, Throwable throwable) {
        super(s, throwable);
        this.myNoRouteToHost = throwable instanceof NoRouteToHostException;
        this.myAuthFailed = false;
    }

    public RemoteSdkException(String s) {
        super(s);
        this.myAuthFailed = false;
        this.myNoRouteToHost = false;
    }

    public boolean isNoRouteToHost() {
        return this.myNoRouteToHost;
    }

    public boolean isAuthFailed() {
        return this.myAuthFailed;
    }

    public String getMessage() {
        if (this.myNoRouteToHost) {
            return this.getCause().getMessage();
        }
        if (this.myAuthFailed) {
            return "Authentication failed";
        }
        return super.getMessage();
    }

    public static RemoteSdkException cantObtainRemoteCredentials(Throwable e) {
        return new RemoteSdkException("Cant obtain remote credentials", e);
    }
}

