/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.semantic;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.reference.SoftReference;
import com.intellij.semantic.SemContributor;
import com.intellij.semantic.SemContributorEP;
import com.intellij.semantic.SemElement;
import com.intellij.semantic.SemKey;
import com.intellij.semantic.SemRegistrar;
import com.intellij.semantic.SemService;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ConcurrentWeakHashMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashMap;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SemServiceImpl
extends SemService {
    private static final Comparator<SemKey> KEY_COMPARATOR = new Comparator<SemKey>(){

        @Override
        public int compare(SemKey o1, SemKey o2) {
            return o2.getUniqueId() - o1.getUniqueId();
        }
    };
    private final ConcurrentWeakHashMap<PsiElement, java.lang.ref.SoftReference<SemCacheChunk>> myCache = new ConcurrentWeakHashMap();
    private volatile MultiMap<SemKey, NullableFunction<PsiElement, ? extends SemElement>> myProducers;
    private volatile MultiMap<SemKey, SemKey> myInheritors;
    private final Project myProject;
    private boolean myBulkChange = false;
    private final AtomicInteger myCreatingSem = new AtomicInteger(0);

    public SemServiceImpl(Project project, PsiManager psiManager) {
        this.myProject = project;
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(PsiModificationTracker.TOPIC, (Object)new PsiModificationTracker.Listener(){

            public void modificationCountChanged() {
                if (!SemServiceImpl.this.isInsideAtomicChange()) {
                    SemServiceImpl.this.clearCache();
                }
            }
        });
        ((PsiManagerEx)psiManager).registerRunnableToRunOnChange(new Runnable(){

            @Override
            public void run() {
                if (!SemServiceImpl.this.isInsideAtomicChange()) {
                    SemServiceImpl.this.clearCache();
                }
            }
        });
        LowMemoryWatcher.register((Runnable)new Runnable(){

            @Override
            public void run() {
                if (SemServiceImpl.this.myCreatingSem.get() == 0) {
                    SemServiceImpl.this.clearCache();
                }
            }
        }, (Disposable)project);
    }

    private static MultiMap<SemKey, SemKey> cacheKeyHierarchy(Collection<SemKey> allKeys) {
        final MultiMap result = MultiMap.createSmartList();
        ContainerUtil.process(allKeys, (Processor)new Processor<SemKey>(){

            public boolean process(SemKey key) {
                result.putValue((Object)key, (Object)key);
                for (SemKey parent : key.getSupers()) {
                    result.putValue((Object)parent, (Object)key);
                    this.process(parent);
                }
                return true;
            }
        });
        for (SemKey each : result.keySet()) {
            ArrayList inheritors = new ArrayList(new HashSet(result.get((Object)each)));
            Collections.sort(inheritors, KEY_COMPARATOR);
            result.put((Object)each, inheritors);
        }
        return result;
    }

    private MultiMap<SemKey, NullableFunction<PsiElement, ? extends SemElement>> collectProducers() {
        final MultiMap map = MultiMap.createSmartList();
        SemRegistrar registrar = new SemRegistrar(){

            public <T extends SemElement, V extends PsiElement> void registerSemElementProvider(SemKey<T> key, final ElementPattern<? extends V> place, final NullableFunction<V, T> provider) {
                map.putValue(key, (Object)new NullableFunction<PsiElement, SemElement>(){

                    public SemElement fun(PsiElement element) {
                        if (place.accepts((Object)element)) {
                            return (SemElement)provider.fun((Object)element);
                        }
                        return null;
                    }
                });
            }
        };
        for (SemContributorEP contributor : (SemContributorEP[])this.myProject.getExtensions(SemContributor.EP_NAME)) {
            contributor.registerSemProviders(this.myProject.getPicoContainer(), registrar);
        }
        return map;
    }

    public void clearCache() {
        this.myCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performAtomicChange(@NotNull Runnable change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/semantic/SemServiceImpl", "performAtomicChange"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        boolean oldValue = this.myBulkChange;
        this.myBulkChange = true;
        try {
            change.run();
        }
        finally {
            this.myBulkChange = oldValue;
            if (!oldValue) {
                this.clearCache();
            }
        }
    }

    public boolean isInsideAtomicChange() {
        return this.myBulkChange;
    }

    @Nullable
    public <T extends SemElement> List<T> getSemElements(SemKey<T> key, @NotNull PsiElement psi) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/semantic/SemServiceImpl", "getSemElements"));
        }
        List<T> cached = this._getCachedSemElements(key, true, psi);
        if (cached != null) {
            return cached;
        }
        this.ensureInitialized();
        RecursionGuard.StackStamp stamp = RecursionManager.createGuard((String)"semService").markStack();
        LinkedHashSet<SemElement> result = new LinkedHashSet<SemElement>();
        THashMap map = new THashMap();
        for (SemKey each : this.myInheritors.get(key)) {
            List<SemElement> list = this.createSemElements(each, psi);
            map.put(each, list);
            result.addAll(list);
        }
        if (stamp.mayCacheNow()) {
            SemCacheChunk persistent = this.getOrCreateChunk(psi);
            for (SemKey semKey : map.keySet()) {
                persistent.putSemElements(semKey, (List)map.get(semKey));
            }
        }
        return new ArrayList(result);
    }

    private void ensureInitialized() {
        if (this.myInheritors == null) {
            this.myProducers = this.collectProducers();
            this.myInheritors = SemServiceImpl.cacheKeyHierarchy(this.myProducers.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private List<SemElement> createSemElements(SemKey key, PsiElement psi) {
        List result = null;
        Collection producers = this.myProducers.get((Object)key);
        if (!producers.isEmpty()) {
            for (NullableFunction producer : producers) {
                this.myCreatingSem.incrementAndGet();
                try {
                    SemElement element = (SemElement)producer.fun((Object)psi);
                    if (element == null) continue;
                    if (result == null) {
                        result = new SmartList();
                    }
                    result.add(element);
                }
                finally {
                    this.myCreatingSem.decrementAndGet();
                }
            }
        }
        List<Object> list = result == null ? Collections.emptyList() : Collections.unmodifiableList(result);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/semantic/SemServiceImpl", "createSemElements"));
        }
        return list;
    }

    @Nullable
    public <T extends SemElement> List<T> getCachedSemElements(SemKey<T> key, @NotNull PsiElement psi) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/semantic/SemServiceImpl", "getCachedSemElements"));
        }
        return this._getCachedSemElements(key, false, psi);
    }

    @Nullable
    private <T extends SemElement> List<T> _getCachedSemElements(SemKey<T> key, boolean paranoid, PsiElement element) {
        SemCacheChunk chunk = this.obtainChunk(element);
        if (chunk == null) {
            return null;
        }
        List<SemElement> singleList = null;
        LinkedHashSet<SemElement> result = null;
        List inheritors = (List)this.myInheritors.get(key);
        for (int i = 0; i < inheritors.size(); ++i) {
            List<SemElement> cached = chunk.getSemElements((SemKey)inheritors.get(i));
            if (cached == null && paranoid) {
                return null;
            }
            if (cached == null || cached == Collections.emptyList()) continue;
            if (singleList == null) {
                singleList = cached;
                continue;
            }
            if (result == null) {
                result = new LinkedHashSet<SemElement>(singleList);
            }
            result.addAll(cached);
        }
        if (result == null) {
            if (singleList != null) {
                return singleList;
            }
            return Collections.emptyList();
        }
        return new ArrayList(result);
    }

    @Nullable
    private SemCacheChunk obtainChunk(@Nullable PsiElement root) {
        java.lang.ref.SoftReference ref = (java.lang.ref.SoftReference)this.myCache.get((Object)root);
        return (SemCacheChunk)SoftReference.dereference((Reference)ref);
    }

    public <T extends SemElement> void setCachedSemElement(SemKey<T> key, @NotNull PsiElement psi, @Nullable T semElement) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/semantic/SemServiceImpl", "setCachedSemElement"));
        }
        this.getOrCreateChunk(psi).putSemElements(key, ContainerUtil.createMaybeSingletonList(semElement));
    }

    public void clearCachedSemElements(@NotNull PsiElement psi) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/semantic/SemServiceImpl", "clearCachedSemElements"));
        }
        this.myCache.remove((Object)psi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SemCacheChunk getOrCreateChunk(PsiElement element) {
        SemCacheChunk chunk = this.obtainChunk(element);
        if (chunk == null) {
            ConcurrentWeakHashMap<PsiElement, java.lang.ref.SoftReference<SemCacheChunk>> concurrentWeakHashMap = this.myCache;
            synchronized (concurrentWeakHashMap) {
                chunk = this.obtainChunk(element);
                if (chunk == null) {
                    chunk = new SemCacheChunk();
                    this.myCache.put((Object)element, new java.lang.ref.SoftReference<SemCacheChunk>(chunk));
                }
            }
        }
        return chunk;
    }

    private static class SemCacheChunk {
        private final ConcurrentIntObjectMap<List<SemElement>> map = ContainerUtil.createConcurrentIntObjectMap();

        private SemCacheChunk() {
        }

        public List<SemElement> getSemElements(SemKey<?> key) {
            return (List)this.map.get(key.getUniqueId());
        }

        public void putSemElements(SemKey<?> key, List<SemElement> elements) {
            this.map.put(key.getUniqueId(), elements);
        }
    }
}

