/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.analysis.AnalysisScope;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SliceForwardUtil;
import com.intellij.slicer.SliceUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import gnu.trove.TObjectHashingStrategy;
import org.jetbrains.annotations.NotNull;

public class SliceUsage
extends UsageInfo2UsageAdapter {
    private final SliceUsage myParent;
    public final SliceAnalysisParams params;
    private final PsiSubstitutor mySubstitutor;
    protected final int indexNesting;
    @NotNull
    protected final String syntheticField;

    public SliceUsage(@NotNull PsiElement element, @NotNull SliceUsage parent, @NotNull PsiSubstitutor substitutor, int indexNesting, @NotNull String syntheticField) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/slicer/SliceUsage", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/slicer/SliceUsage", "<init>"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/slicer/SliceUsage", "<init>"));
        }
        if (syntheticField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syntheticField", "com/intellij/slicer/SliceUsage", "<init>"));
        }
        super(new UsageInfo(element));
        this.myParent = parent;
        this.mySubstitutor = substitutor;
        this.syntheticField = syntheticField;
        this.params = parent.params;
        assert (this.params != null);
        this.indexNesting = indexNesting;
    }

    private SliceUsage(@NotNull PsiElement element, @NotNull SliceAnalysisParams params) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/slicer/SliceUsage", "<init>"));
        }
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/slicer/SliceUsage", "<init>"));
        }
        super(new UsageInfo(element));
        this.myParent = null;
        this.params = params;
        this.mySubstitutor = PsiSubstitutor.EMPTY;
        this.indexNesting = 0;
        this.syntheticField = "";
    }

    @NotNull
    public static SliceUsage createRootUsage(@NotNull PsiElement element, @NotNull SliceAnalysisParams params) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/slicer/SliceUsage", "createRootUsage"));
        }
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/slicer/SliceUsage", "createRootUsage"));
        }
        SliceUsage sliceUsage = new SliceUsage(element, params);
        if (sliceUsage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceUsage", "createRootUsage"));
        }
        return sliceUsage;
    }

    public void processChildren(@NotNull Processor<SliceUsage> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/slicer/SliceUsage", "processChildren"));
        }
        final PsiElement element = (PsiElement)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiElement>(){

            public PsiElement compute() {
                return SliceUsage.this.getElement();
            }
        });
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        indicator.checkCanceled();
        CommonProcessors.UniqueProcessor uniqueProcessor = new CommonProcessors.UniqueProcessor(processor, (TObjectHashingStrategy)new TObjectHashingStrategy<SliceUsage>(){

            public int computeHashCode(SliceUsage object) {
                return object.getUsageInfo().hashCode();
            }

            public boolean equals(SliceUsage o1, SliceUsage o2) {
                return o1.getUsageInfo().equals((Object)o2.getUsageInfo());
            }
        });
        ApplicationManager.getApplication().runReadAction(new Runnable((Processor)uniqueProcessor){
            final /* synthetic */ Processor val$uniqueProcessor;
            {
                this.val$uniqueProcessor = processor;
            }

            @Override
            public void run() {
                if (SliceUsage.this.params.dataFlowToThis) {
                    SliceUtil.processUsagesFlownDownTo(element, (Processor<SliceUsage>)this.val$uniqueProcessor, SliceUsage.this, SliceUsage.this.mySubstitutor, SliceUsage.this.indexNesting, SliceUsage.this.syntheticField);
                } else {
                    SliceForwardUtil.processUsagesFlownFromThe(element, (Processor<SliceUsage>)this.val$uniqueProcessor, SliceUsage.this);
                }
            }
        });
    }

    public SliceUsage getParent() {
        return this.myParent;
    }

    @NotNull
    public AnalysisScope getScope() {
        AnalysisScope analysisScope = this.params.scope;
        if (analysisScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceUsage", "getScope"));
        }
        return analysisScope;
    }

    @NotNull
    SliceUsage copy() {
        PsiElement element = this.getUsageInfo().getElement();
        SliceUsage sliceUsage = this.getParent() == null ? SliceUsage.createRootUsage(element, this.params) : new SliceUsage(element, this.getParent(), this.mySubstitutor, this.indexNesting, this.syntheticField);
        if (sliceUsage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceUsage", "copy"));
        }
        return sliceUsage;
    }

    @NotNull
    public PsiSubstitutor getSubstitutor() {
        PsiSubstitutor psiSubstitutor = this.mySubstitutor;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceUsage", "getSubstitutor"));
        }
        return psiSubstitutor;
    }
}

