/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.JavaCompiledPattern;
import com.intellij.structuralsearch.impl.matcher.compiler.CompileContext;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.compiler.OptimizingSearchHelper;
import com.intellij.structuralsearch.impl.matcher.filters.BlockFilter;
import com.intellij.structuralsearch.impl.matcher.filters.ClassFilter;
import com.intellij.structuralsearch.impl.matcher.filters.CommentFilter;
import com.intellij.structuralsearch.impl.matcher.filters.ConstantFilter;
import com.intellij.structuralsearch.impl.matcher.filters.DeclarationFilter;
import com.intellij.structuralsearch.impl.matcher.filters.ExpressionFilter;
import com.intellij.structuralsearch.impl.matcher.filters.JavaDocFilter;
import com.intellij.structuralsearch.impl.matcher.filters.MethodFilter;
import com.intellij.structuralsearch.impl.matcher.filters.StatementFilter;
import com.intellij.structuralsearch.impl.matcher.filters.SymbolNodeFilter;
import com.intellij.structuralsearch.impl.matcher.filters.TypeFilter;
import com.intellij.structuralsearch.impl.matcher.filters.TypeParameterFilter;
import com.intellij.structuralsearch.impl.matcher.filters.TypedSymbolNodeFilter;
import com.intellij.structuralsearch.impl.matcher.filters.VariableFilter;
import com.intellij.structuralsearch.impl.matcher.handlers.DeclarationStatementHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.DocDataHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.ExpressionHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.StatementHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SymbolHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.TopLevelMatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.TypedSymbolHandler;
import com.intellij.structuralsearch.impl.matcher.iterators.DocValuesIterator;
import com.intellij.structuralsearch.impl.matcher.predicates.RegExpPredicate;
import com.intellij.structuralsearch.impl.matcher.strategies.CommentMatchingStrategy;
import com.intellij.structuralsearch.impl.matcher.strategies.ExprMatchingStrategy;
import com.intellij.structuralsearch.impl.matcher.strategies.JavaDocMatchingStrategy;
import com.intellij.structuralsearch.impl.matcher.strategies.MatchingStrategy;
import com.intellij.structuralsearch.impl.matcher.strategies.SymbolMatchingStrategy;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JavaCompilingVisitor
extends JavaRecursiveElementWalkingVisitor {
    private final GlobalCompilingVisitor myCompilingVisitor;
    @NonNls
    private static final String COMMENT = "\\s*(__\\$_\\w+)\\s*";
    private static final Pattern ourPattern = Pattern.compile("//\\s*(__\\$_\\w+)\\s*", 32);
    private static final Pattern ourPattern2 = Pattern.compile("/\\*\\s*(__\\$_\\w+)\\s*\\*/", 32);
    private static final Pattern ourPattern3 = Pattern.compile("/\\*\\*\\s*(__\\$_\\w+)\\s*\\*/", 32);

    public JavaCompilingVisitor(GlobalCompilingVisitor compilingVisitor) {
        this.myCompilingVisitor = compilingVisitor;
    }

    public void visitDocTag(PsiDocTag psiDocTag) {
        super.visitDocTag(psiDocTag);
        DocValuesIterator sons = new DocValuesIterator(psiDocTag.getFirstChild());
        while (((NodeIterator)sons).hasNext()) {
            this.myCompilingVisitor.setHandler(((NodeIterator)sons).current(), new DocDataHandler());
            ((NodeIterator)sons).advance();
        }
    }

    public void visitComment(PsiComment comment) {
        MatchingHandler handler;
        super.visitComment(comment);
        String text = comment.getText();
        Matcher matcher = ourPattern.matcher(text);
        boolean matches = false;
        if (!matcher.matches()) {
            matcher = ourPattern2.matcher(text);
            if (!matcher.matches()) {
                matcher = ourPattern3.matcher(text);
            } else {
                matches = true;
            }
        } else {
            matches = true;
        }
        if (matches || matcher.matches()) {
            RegExpPredicate predicate;
            String str = matcher.group(1);
            comment.putUserData(CompiledPattern.HANDLER_KEY, (Object)str);
            GlobalCompilingVisitor.setFilter(this.myCompilingVisitor.getContext().getPattern().getHandler((PsiElement)comment), CommentFilter.getInstance());
            SubstitutionHandler handler2 = (SubstitutionHandler)this.myCompilingVisitor.getContext().getPattern().getHandler(str);
            if (handler2 == null) {
                throw new MalformedPatternException();
            }
            if (handler2.getPredicate() != null) {
                ((RegExpPredicate)handler2.getPredicate()).setMultiline(true);
            }
            if (GlobalCompilingVisitor.isSuitablePredicate(predicate = MatchingHandler.getSimpleRegExpPredicate(handler2), handler2)) {
                this.myCompilingVisitor.processTokenizedName(predicate.getRegExp(), true, GlobalCompilingVisitor.OccurenceKind.COMMENT);
            }
            matches = true;
        }
        if (!matches && (handler = this.myCompilingVisitor.processPatternStringWithFragments(text, GlobalCompilingVisitor.OccurenceKind.COMMENT)) != null) {
            comment.putUserData(CompiledPattern.HANDLER_KEY, (Object)handler);
        }
    }

    public void visitLiteralExpression(PsiLiteralExpression expression) {
        MatchingHandler handler;
        String value = expression.getText();
        if (value.length() > 2 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"' && (handler = this.myCompilingVisitor.processPatternStringWithFragments(value, GlobalCompilingVisitor.OccurenceKind.LITERAL)) != null) {
            expression.putUserData(CompiledPattern.HANDLER_KEY, (Object)handler);
        }
        super.visitLiteralExpression(expression);
    }

    public void visitClassInitializer(PsiClassInitializer initializer) {
        MatchingHandler handler;
        super.visitClassInitializer(initializer);
        PsiStatement[] psiStatements = initializer.getBody().getStatements();
        if (psiStatements.length == 1 && psiStatements[0] instanceof PsiExpressionStatement && (handler = this.myCompilingVisitor.getContext().getPattern().getHandler((PsiElement)psiStatements[0])) instanceof SubstitutionHandler) {
            this.myCompilingVisitor.getContext().getPattern().setHandler((PsiElement)initializer, new SubstitutionHandler((SubstitutionHandler)handler));
        }
    }

    public void visitField(PsiField psiField) {
        super.visitField(psiField);
        CompiledPattern pattern = this.myCompilingVisitor.getContext().getPattern();
        MatchingHandler handler = pattern.getHandler((PsiElement)psiField);
        if (JavaCompilingVisitor.needsSupers((PsiElement)psiField, handler)) {
            assert (pattern instanceof JavaCompiledPattern);
            ((JavaCompiledPattern)pattern).setRequestsSuperFields(true);
        }
    }

    public void visitMethod(PsiMethod psiMethod) {
        super.visitMethod(psiMethod);
        CompiledPattern pattern = this.myCompilingVisitor.getContext().getPattern();
        MatchingHandler handler = pattern.getHandler((PsiElement)psiMethod);
        if (JavaCompilingVisitor.needsSupers((PsiElement)psiMethod, handler)) {
            assert (pattern instanceof JavaCompiledPattern);
            ((JavaCompiledPattern)pattern).setRequestsSuperMethods(true);
        }
        GlobalCompilingVisitor.setFilter(handler, MethodFilter.getInstance());
        JavaCompilingVisitor.handleReferenceText(psiMethod.getName(), this.myCompilingVisitor.getContext());
    }

    public void visitReferenceExpression(PsiReferenceExpression reference) {
        MatchingHandler handler;
        this.visitElement((PsiElement)reference);
        boolean typedVarProcessed = false;
        PsiElement referenceParent = reference.getParent();
        if (this.myCompilingVisitor.getContext().getPattern().isRealTypedVar((PsiElement)reference) && reference.getQualifierExpression() == null && !(referenceParent instanceof PsiExpressionStatement)) {
            handler = this.myCompilingVisitor.getContext().getPattern().getHandler((PsiElement)reference);
            GlobalCompilingVisitor.setFilter(handler, ExpressionFilter.getInstance());
            typedVarProcessed = true;
        }
        if (!(referenceParent instanceof PsiMethodCallExpression)) {
            this.handleReference((PsiJavaCodeReferenceElement)reference);
        }
        handler = this.myCompilingVisitor.getContext().getPattern().getHandler((PsiElement)reference);
        String referencedName = reference.getReferenceName();
        if (!typedVarProcessed && !(handler instanceof SubstitutionHandler)) {
            PsiElement resolve = reference.resolve();
            PsiElement referenceQualifier = reference.getQualifier();
            if (resolve instanceof PsiClass || resolve == null && (referencedName != null && Character.isUpperCase(referencedName.charAt(0)) || referenceQualifier == null)) {
                PsiExpression qualifier;
                boolean hasNoNestedSubstitutionHandlers = false;
                PsiReferenceExpression currentReference = reference;
                while ((qualifier = currentReference.getQualifierExpression()) != null) {
                    if (!(qualifier instanceof PsiReferenceExpression) || this.myCompilingVisitor.getContext().getPattern().getHandler((PsiElement)qualifier) instanceof SubstitutionHandler) {
                        hasNoNestedSubstitutionHandlers = true;
                        break;
                    }
                    currentReference = (PsiReferenceExpression)qualifier;
                }
                if (!hasNoNestedSubstitutionHandlers) {
                    this.createAndSetSubstitutionHandlerFromReference((PsiElement)reference, resolve != null ? ((PsiClass)resolve).getQualifiedName() : reference.getText(), referenceParent instanceof PsiExpression);
                }
            } else if (referenceQualifier == null || reference.getParent() instanceof PsiExpressionStatement) {
                // empty if block
            }
        }
    }

    public void visitMethodCallExpression(PsiMethodCallExpression expression) {
        this.handleReference((PsiJavaCodeReferenceElement)expression.getMethodExpression());
        super.visitMethodCallExpression(expression);
    }

    public void visitBlockStatement(PsiBlockStatement psiBlockStatement) {
        super.visitBlockStatement(psiBlockStatement);
        this.myCompilingVisitor.getContext().getPattern().getHandler((PsiElement)psiBlockStatement).setFilter(BlockFilter.getInstance());
    }

    public void visitVariable(PsiVariable psiVariable) {
        super.visitVariable(psiVariable);
        this.myCompilingVisitor.getContext().getPattern().getHandler((PsiElement)psiVariable).setFilter(VariableFilter.getInstance());
        JavaCompilingVisitor.handleReferenceText(psiVariable.getName(), this.myCompilingVisitor.getContext());
    }

    public void visitDeclarationStatement(PsiDeclarationStatement psiDeclarationStatement) {
        PsiJavaCodeReferenceElement reference;
        super.visitDeclarationStatement(psiDeclarationStatement);
        if (psiDeclarationStatement.getFirstChild() instanceof PsiTypeElement && (reference = ((PsiTypeElement)psiDeclarationStatement.getFirstChild()).getInnermostComponentReferenceElement()) != null && this.myCompilingVisitor.getContext().getPattern().isRealTypedVar(reference.getReferenceNameElement()) && reference.getParameterList().getTypeParameterElements().length > 0) {
            PsiTypeElement[] params;
            this.myCompilingVisitor.setHandler((PsiElement)psiDeclarationStatement, new TypedSymbolHandler());
            MatchingHandler handler = this.myCompilingVisitor.getContext().getPattern().getHandler((PsiElement)psiDeclarationStatement);
            handler.setFilter(TypedSymbolNodeFilter.getInstance());
            for (PsiTypeElement param : params = reference.getParameterList().getTypeParameterElements()) {
                if (param.getInnermostComponentReferenceElement() == null || !this.myCompilingVisitor.getContext().getPattern().isRealTypedVar(param.getInnermostComponentReferenceElement().getReferenceNameElement())) continue;
                this.myCompilingVisitor.getContext().getPattern().getHandler((PsiElement)param).setFilter(TypeParameterFilter.getInstance());
            }
            return;
        }
        DeclarationStatementHandler handler = new DeclarationStatementHandler();
        this.myCompilingVisitor.getContext().getPattern().setHandler((PsiElement)psiDeclarationStatement, handler);
        PsiElement previousNonWhiteSpace = psiDeclarationStatement.getPrevSibling();
        while (previousNonWhiteSpace instanceof PsiWhiteSpace) {
            previousNonWhiteSpace = previousNonWhiteSpace.getPrevSibling();
        }
        if (previousNonWhiteSpace instanceof PsiComment) {
            handler.setCommentHandler(this.myCompilingVisitor.getContext().getPattern().getHandler(previousNonWhiteSpace));
            this.myCompilingVisitor.getContext().getPattern().setHandler(previousNonWhiteSpace, handler);
        }
        handler.setFilter(DeclarationFilter.getInstance());
    }

    public void visitDocComment(PsiDocComment psiDocComment) {
        super.visitDocComment(psiDocComment);
        this.myCompilingVisitor.getContext().getPattern().getHandler((PsiElement)psiDocComment).setFilter(JavaDocFilter.getInstance());
    }

    public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
        super.visitReferenceElement(reference);
        if (reference.getParent() != null && reference.getParent().getParent() instanceof PsiClass) {
            GlobalCompilingVisitor.setFilter(this.myCompilingVisitor.getContext().getPattern().getHandler((PsiElement)reference), TypeFilter.getInstance());
        }
        this.handleReference(reference);
    }

    public void visitClass(PsiClass psiClass) {
        super.visitClass(psiClass);
        CompiledPattern pattern = this.myCompilingVisitor.getContext().getPattern();
        MatchingHandler handler = pattern.getHandler((PsiElement)psiClass);
        if (JavaCompilingVisitor.needsSupers((PsiElement)psiClass, handler)) {
            ((JavaCompiledPattern)pattern).setRequestsSuperInners(true);
        }
        JavaCompilingVisitor.handleReferenceText(psiClass.getName(), this.myCompilingVisitor.getContext());
        GlobalCompilingVisitor.setFilter(handler, ClassFilter.getInstance());
        boolean hasSubstitutionHandler = false;
        for (PsiElement element = psiClass.getFirstChild(); element != null; element = element.getNextSibling()) {
            MatchingHandler unmatchedSubstitutionHandler;
            if (!(element instanceof PsiTypeElement) || !(element.getNextSibling() instanceof PsiErrorElement) || (unmatchedSubstitutionHandler = pattern.getHandler(element)) == null) continue;
            psiClass.putUserData(JavaCompiledPattern.ALL_CLASS_CONTENT_VAR_NAME_KEY, (Object)pattern.getTypedVarString(element));
            hasSubstitutionHandler = true;
        }
        if (!hasSubstitutionHandler) {
            String name = "__class_unmatched__";
            psiClass.putUserData(JavaCompiledPattern.ALL_CLASS_CONTENT_VAR_NAME_KEY, (Object)name);
            MatchOptions options = this.myCompilingVisitor.getContext().getOptions();
            if (options.getVariableConstraint(name) == null) {
                pattern.createSubstitutionHandler(name, name, false, 0, Integer.MAX_VALUE, true);
                MatchVariableConstraint constraint = new MatchVariableConstraint(true);
                constraint.setName(name);
                constraint.setMinCount(0);
                constraint.setMaxCount(Integer.MAX_VALUE);
                options.addVariableConstraint(constraint);
            }
        }
    }

    private SubstitutionHandler createAndSetSubstitutionHandlerFromReference(PsiElement expr, String referenceText, boolean classQualifier) {
        SubstitutionHandler substitutionHandler = new SubstitutionHandler("__" + referenceText.replace('.', '_'), false, classQualifier ? 0 : 1, 1, false);
        substitutionHandler.setPredicate(new RegExpPredicate(referenceText.replaceAll("\\.", "\\\\."), true, null, false, false));
        this.myCompilingVisitor.getContext().getPattern().setHandler(expr, substitutionHandler);
        return substitutionHandler;
    }

    public void visitExpressionStatement(PsiExpressionStatement expr) {
        MatchingHandler exprHandler;
        this.myCompilingVisitor.handle((PsiElement)expr);
        super.visitExpressionStatement(expr);
        PsiElement child = expr.getLastChild();
        if (!(child instanceof PsiJavaToken) && !(child instanceof PsiComment)) {
            PsiElement reference = expr.getFirstChild();
            MatchingHandler referenceHandler = this.myCompilingVisitor.getContext().getPattern().getHandler(reference);
            if (referenceHandler instanceof SubstitutionHandler && reference instanceof PsiReferenceExpression) {
                this.myCompilingVisitor.getContext().getPattern().setHandler((PsiElement)expr, referenceHandler);
                referenceHandler.setFilter(SymbolNodeFilter.getInstance());
                this.myCompilingVisitor.setHandler((PsiElement)expr, new SymbolHandler((SubstitutionHandler)referenceHandler));
            } else if (reference instanceof PsiLiteralExpression) {
                ExpressionHandler handler = new ExpressionHandler();
                this.myCompilingVisitor.setHandler((PsiElement)expr, handler);
                handler.setFilter(ConstantFilter.getInstance());
            } else {
                ExpressionHandler handler = new ExpressionHandler();
                this.myCompilingVisitor.setHandler((PsiElement)expr, handler);
                handler.setFilter(ExpressionFilter.getInstance());
            }
        } else if (expr.getExpression() instanceof PsiReferenceExpression && this.myCompilingVisitor.getContext().getPattern().isRealTypedVar((PsiElement)expr.getExpression()) && (exprHandler = this.myCompilingVisitor.getContext().getPattern().getHandler((PsiElement)expr)) instanceof SubstitutionHandler) {
            SubstitutionHandler handler = (SubstitutionHandler)exprHandler;
            handler.setFilter(new StatementFilter());
            handler.setMatchHandler(new StatementHandler());
        }
    }

    public void visitElement(PsiElement element) {
        this.myCompilingVisitor.handle(element);
        super.visitElement(element);
    }

    private void handleReference(PsiJavaCodeReferenceElement reference) {
        JavaCompilingVisitor.handleReferenceText(reference.getReferenceName(), this.myCompilingVisitor.getContext());
    }

    private static void handleReferenceText(String refname, CompileContext compileContext) {
        if (refname == null) {
            return;
        }
        if (compileContext.getPattern().isTypedVar(refname)) {
            SubstitutionHandler handler = (SubstitutionHandler)compileContext.getPattern().getHandler(refname);
            RegExpPredicate predicate = MatchingHandler.getSimpleRegExpPredicate(handler);
            if (!GlobalCompilingVisitor.isSuitablePredicate(predicate, handler)) {
                return;
            }
            refname = predicate.getRegExp();
            if (handler.isStrictSubtype() || handler.isSubtype()) {
                OptimizingSearchHelper searchHelper = compileContext.getSearchHelper();
                if (JavaCompilingVisitor.addDescendantsOf(refname, handler.isSubtype(), searchHelper, compileContext)) {
                    searchHelper.endTransaction();
                }
                return;
            }
        }
        GlobalCompilingVisitor.addFilesToSearchForGivenWord(refname, true, GlobalCompilingVisitor.OccurenceKind.CODE, compileContext);
    }

    public static boolean addDescendantsOf(String refname, boolean subtype, OptimizingSearchHelper searchHelper, CompileContext context) {
        List<PsiClass> classes = JavaCompilingVisitor.buildDescendants(refname, subtype, searchHelper, context);
        for (PsiClass aClass : classes) {
            if (aClass instanceof PsiAnonymousClass) {
                searchHelper.addWordToSearchInCode(((PsiAnonymousClass)aClass).getBaseClassReference().getReferenceName());
                continue;
            }
            searchHelper.addWordToSearchInCode(aClass.getName());
        }
        return classes.size() > 0;
    }

    private static List<PsiClass> buildDescendants(String className, boolean includeSelf, OptimizingSearchHelper searchHelper, CompileContext context) {
        if (!searchHelper.doOptimizing()) {
            return Collections.emptyList();
        }
        SearchScope scope = context.getOptions().getScope();
        if (!(scope instanceof GlobalSearchScope)) {
            return Collections.emptyList();
        }
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)context.getProject());
        PsiClass[] classes = cache.getClassesByName(className, (GlobalSearchScope)scope);
        final ArrayList<PsiClass> results = new ArrayList<PsiClass>();
        PsiElementProcessor<PsiClass> processor = new PsiElementProcessor<PsiClass>(){

            public boolean execute(@NotNull PsiClass element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/structuralsearch/impl/matcher/compiler/JavaCompilingVisitor$1", "execute"));
                }
                results.add(element);
                return true;
            }
        };
        for (PsiClass aClass : classes) {
            ClassInheritorsSearch.search((PsiClass)aClass, (SearchScope)scope, (boolean)true).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)processor));
        }
        if (includeSelf) {
            Collections.addAll(results, classes);
        }
        return results;
    }

    public void visitCodeBlock(PsiCodeBlock block) {
        this.myCompilingVisitor.setCodeBlockLevel(this.myCompilingVisitor.getCodeBlockLevel() + 1);
        MatchingStrategy strategy = null;
        for (PsiElement el = block.getFirstChild(); el != null; el = el.getNextSibling()) {
            if (GlobalCompilingVisitor.getFilter().accepts(el)) {
                if (!(el instanceof PsiWhiteSpace)) continue;
                this.myCompilingVisitor.addLexicalNode(el);
                continue;
            }
            el.accept((PsiElementVisitor)this);
            if (this.myCompilingVisitor.getCodeBlockLevel() != 1) continue;
            MatchingStrategy newstrategy = this.findStrategy(el);
            MatchingHandler matchingHandler = this.myCompilingVisitor.getContext().getPattern().getHandler(el);
            this.myCompilingVisitor.getContext().getPattern().setHandler(el, new TopLevelMatchingHandler(matchingHandler));
            if (strategy == null || strategy instanceof JavaDocMatchingStrategy) {
                strategy = newstrategy;
                continue;
            }
            if (strategy.getClass() == newstrategy.getClass()) continue;
            if (!(strategy instanceof CommentMatchingStrategy)) {
                throw new UnsupportedPatternException(SSRBundle.message("different.strategies.for.top.level.nodes.error.message", new Object[0]));
            }
            strategy = newstrategy;
        }
        if (this.myCompilingVisitor.getCodeBlockLevel() == 1) {
            if (strategy == null) {
                strategy = ExprMatchingStrategy.getInstance();
            }
            this.myCompilingVisitor.getContext().getPattern().setStrategy(strategy);
        }
        this.myCompilingVisitor.setCodeBlockLevel(this.myCompilingVisitor.getCodeBlockLevel() - 1);
    }

    private MatchingStrategy findStrategy(PsiElement el) {
        MatchingHandler handler = this.myCompilingVisitor.getContext().getPattern().getHandler(el);
        if (handler.getFilter() instanceof SymbolNodeFilter || handler.getFilter() instanceof TypedSymbolNodeFilter) {
            return SymbolMatchingStrategy.getInstance();
        }
        if (el instanceof PsiDocComment) {
            return JavaDocMatchingStrategy.getInstance();
        }
        if (el instanceof PsiComment) {
            return CommentMatchingStrategy.getInstance();
        }
        return ExprMatchingStrategy.getInstance();
    }

    private static boolean needsSupers(PsiElement element, MatchingHandler handler) {
        if (element.getParent() instanceof PsiClass && handler instanceof SubstitutionHandler) {
            SubstitutionHandler handler2 = (SubstitutionHandler)handler;
            return handler2.isStrictSubtype() || handler2.isSubtype();
        }
        return false;
    }
}

