/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.utils.DfsUtil;
import com.intellij.vcs.log.graph.utils.Flags;
import com.intellij.vcs.log.graph.utils.impl.BitSetFlags;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ContainingBranchesGetter {
    @NotNull
    private final LinearGraph myPermanentGraph;
    @NotNull
    private final Set<Integer> myBranchNodeIndexes;
    @NotNull
    private final DfsUtil myDfsUtil;
    @NotNull
    private final Flags myTempFlags;

    public ContainingBranchesGetter(@NotNull LinearGraph permanentGraph, @NotNull Set<Integer> branchNodeIndexes) {
        if (permanentGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentGraph", "com/intellij/vcs/log/graph/impl/facade/ContainingBranchesGetter", "<init>"));
        }
        if (branchNodeIndexes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchNodeIndexes", "com/intellij/vcs/log/graph/impl/facade/ContainingBranchesGetter", "<init>"));
        }
        this.myDfsUtil = new DfsUtil();
        this.myPermanentGraph = permanentGraph;
        this.myBranchNodeIndexes = branchNodeIndexes;
        this.myTempFlags = new BitSetFlags(permanentGraph.nodesCount());
    }

    public Set<Integer> getBranchNodeIndexes(int nodeIndex) {
        final HashSet<Integer> result = new HashSet<Integer>();
        this.myTempFlags.setAll(false);
        this.myTempFlags.set(nodeIndex, true);
        this.checkAndAdd(nodeIndex, result);
        this.myDfsUtil.nodeDfsIterator(nodeIndex, new DfsUtil.NextNode(){

            @Override
            public int fun(int currentNode) {
                for (int upNode : ContainingBranchesGetter.this.myPermanentGraph.getUpNodes(currentNode)) {
                    if (ContainingBranchesGetter.this.myTempFlags.get(upNode)) continue;
                    ContainingBranchesGetter.this.myTempFlags.set(upNode, true);
                    ContainingBranchesGetter.this.checkAndAdd(upNode, result);
                    return upNode;
                }
                return -1;
            }
        });
        return result;
    }

    private void checkAndAdd(int nodeIndex, Set<Integer> result) {
        if (this.myBranchNodeIndexes.contains(nodeIndex)) {
            result.add(nodeIndex);
        }
    }
}

