/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SearchTextFieldWithStoredHistory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.VcsLogHashFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.data.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogFilterCollectionImpl;
import com.intellij.vcs.log.impl.VcsLogHashFilterImpl;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.filter.BranchFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.DateFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.FilterPopupComponent;
import com.intellij.vcs.log.ui.filter.MultipleValueFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.StructureFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.UserFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.VcsLogTextFilterImpl;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class VcsLogClassicFilterUi
implements VcsLogFilterUi {
    private static final Logger LOG = Logger.getInstance(VcsLogClassicFilterUi.class);
    private static final String HASH_PATTERN = "[a-fA-F0-9]{7,}";
    @NotNull
    private final SearchTextField myTextFilter;
    @NotNull
    private final VcsLogUiImpl myUi;
    @NotNull
    private final DefaultActionGroup myActionGroup;
    @NotNull
    private final BranchFilterPopupComponent myBranchFilterComponent;
    @NotNull
    private final UserFilterPopupComponent myUserFilterComponent;
    @NotNull
    private final DateFilterPopupComponent myDateFilterComponent;
    @NotNull
    private final StructureFilterPopupComponent myStructureFilterComponent;

    public VcsLogClassicFilterUi(@NotNull VcsLogUiImpl ui, @NotNull VcsLogDataHolder logDataHolder, @NotNull VcsLogUiProperties uiProperties, @NotNull VcsLogDataPack initialDataPack) {
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "<init>"));
        }
        if (logDataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logDataHolder", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "<init>"));
        }
        if (uiProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiProperties", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "<init>"));
        }
        if (initialDataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialDataPack", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "<init>"));
        }
        this.myUi = ui;
        this.myTextFilter = new SearchTextFieldWithStoredHistory("Vcs.Log.Text.Filter.History"){

            protected void onFieldCleared() {
                VcsLogClassicFilterUi.this.applyFilters();
            }
        };
        this.myTextFilter.getTextEditor().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VcsLogClassicFilterUi.this.applyFilters();
                VcsLogClassicFilterUi.this.myTextFilter.addCurrentTextToHistory();
            }
        });
        this.myBranchFilterComponent = new BranchFilterPopupComponent(this, initialDataPack, uiProperties);
        this.myUserFilterComponent = new UserFilterPopupComponent(this, logDataHolder, uiProperties);
        this.myDateFilterComponent = new DateFilterPopupComponent(this);
        this.myStructureFilterComponent = new StructureFilterPopupComponent(this, logDataHolder.getRoots());
        this.myActionGroup = new DefaultActionGroup();
        this.myActionGroup.add((AnAction)new TextFilterComponent(this.myTextFilter));
        this.myActionGroup.add((AnAction)new FilterActionComponent(this.myBranchFilterComponent));
        this.myActionGroup.add((AnAction)new FilterActionComponent(this.myUserFilterComponent));
        this.myActionGroup.add((AnAction)new FilterActionComponent(this.myDateFilterComponent));
        this.myActionGroup.add((AnAction)new FilterActionComponent(this.myStructureFilterComponent));
    }

    public void updateDataPack(@NotNull VcsLogDataPack dataPack) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "updateDataPack"));
        }
        this.myBranchFilterComponent.updateDataPack(dataPack);
    }

    @NotNull
    public ActionGroup getActionGroup() {
        DefaultActionGroup defaultActionGroup = this.myActionGroup;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "getActionGroup"));
        }
        return defaultActionGroup;
    }

    @NotNull
    public List<JComponent> getComponents() {
        List<JComponent> list = Arrays.asList(this.myTextFilter.getTextEditor(), this.myBranchFilterComponent, this.myUserFilterComponent, this.myDateFilterComponent, this.myStructureFilterComponent);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "getComponents"));
        }
        return list;
    }

    @NotNull
    public VcsLogFilterCollection getFilters() {
        Pair<VcsLogTextFilter, VcsLogHashFilter> filtersFromText = VcsLogClassicFilterUi.getFiltersFromTextArea(this.myTextFilter.getText().trim());
        VcsLogFilterCollectionImpl vcsLogFilterCollectionImpl = new VcsLogFilterCollectionImpl(this.myBranchFilterComponent.getFilter(), this.myUserFilterComponent.getFilter(), (VcsLogHashFilter)filtersFromText.second, this.myDateFilterComponent.getFilter(), (VcsLogTextFilter)filtersFromText.first, this.myStructureFilterComponent.getFilter());
        if (vcsLogFilterCollectionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "getFilters"));
        }
        return vcsLogFilterCollectionImpl;
    }

    @NotNull
    private static Pair<VcsLogTextFilter, VcsLogHashFilter> getFiltersFromTextArea(@NotNull String text) {
        VcsLogHashFilterImpl hashFilter;
        VcsLogTextFilterImpl textFilter;
        String word;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "getFiltersFromTextArea"));
        }
        if (text.isEmpty()) {
            Pair pair = Pair.empty();
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "getFiltersFromTextArea"));
            }
            return pair;
        }
        ArrayList hashes = ContainerUtil.newArrayList();
        Iterator i$ = StringUtil.split((String)text, (String)" ").iterator();
        while (i$.hasNext() && !StringUtil.isEmptyOrSpaces((String)(word = (String)i$.next())) && word.matches(HASH_PATTERN)) {
            hashes.add(word);
        }
        if (!hashes.isEmpty()) {
            textFilter = null;
            hashFilter = new VcsLogHashFilterImpl(hashes);
        } else {
            textFilter = new VcsLogTextFilterImpl(text);
            hashFilter = null;
        }
        Pair pair = Pair.create((Object)textFilter, (Object)hashFilter);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "getFiltersFromTextArea"));
        }
        return pair;
    }

    public void setFilter(@NotNull VcsLogFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/ui/filter/VcsLogClassicFilterUi", "setFilter"));
        }
        if (filter instanceof VcsLogBranchFilter) {
            Collection values = ((VcsLogBranchFilter)filter).getBranchNames();
            this.myBranchFilterComponent.apply(values, MultipleValueFilterPopupComponent.displayableText(values), MultipleValueFilterPopupComponent.tooltip(values));
        }
    }

    void applyFilters() {
        this.myUi.applyFiltersAndUpdateUi();
    }

    private static class FilterActionComponent
    extends DumbAwareAction
    implements CustomComponentAction {
        private final FilterPopupComponent myComponent;

        public FilterActionComponent(FilterPopupComponent component) {
            this.myComponent = component;
        }

        public JComponent createCustomComponent(Presentation presentation) {
            return this.myComponent;
        }

        public void actionPerformed(AnActionEvent e) {
        }
    }

    private static class TextFilterComponent
    extends DumbAwareAction
    implements CustomComponentAction {
        private final SearchTextField mySearchField;

        TextFilterComponent(SearchTextField searchField) {
            this.mySearchField = searchField;
        }

        public JComponent createCustomComponent(Presentation presentation) {
            JPanel panel = new JPanel();
            JLabel filterCaption = new JLabel("Filter:");
            filterCaption.setForeground(UIUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : UIUtil.getInactiveTextColor());
            panel.add(filterCaption);
            panel.add((Component)this.mySearchField);
            return panel;
        }

        public void actionPerformed(AnActionEvent e) {
        }
    }
}

