/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.data.VisiblePack;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.frame.VcsLogGraphTable;
import com.intellij.vcs.log.ui.render.RefPainter;
import com.intellij.vcs.log.ui.tables.GraphTableModel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DetailsPanel
extends JPanel
implements ListSelectionListener {
    private static final Logger LOG = Logger.getInstance((String)"Vcs.Log");
    private static final String STANDARD_LAYER = "Standard";
    private static final String MESSAGE_LAYER = "Message";
    @NotNull
    private final VcsLogDataHolder myLogDataHolder;
    @NotNull
    private final VcsLogGraphTable myGraphTable;
    @NotNull
    private final RefsPanel myRefsPanel;
    @NotNull
    private final DataPanel myHashAuthorPanel;
    @NotNull
    private final DataPanel myMessageDataPanel;
    @NotNull
    private final ContainingBranchesPanel myContainingBranchesPanel;
    @NotNull
    private final MessagePanel myMessagePanel;
    @NotNull
    private final JBLoadingPanel myLoadingPanel;
    @NotNull
    private VisiblePack myDataPack;

    DetailsPanel(@NotNull VcsLogDataHolder logDataHolder, @NotNull VcsLogGraphTable graphTable, @NotNull VcsLogColorManager colorManager, @NotNull VisiblePack initialDataPack) {
        if (logDataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logDataHolder", "com/intellij/vcs/log/ui/frame/DetailsPanel", "<init>"));
        }
        if (graphTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphTable", "com/intellij/vcs/log/ui/frame/DetailsPanel", "<init>"));
        }
        if (colorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorManager", "com/intellij/vcs/log/ui/frame/DetailsPanel", "<init>"));
        }
        if (initialDataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialDataPack", "com/intellij/vcs/log/ui/frame/DetailsPanel", "<init>"));
        }
        this.myLogDataHolder = logDataHolder;
        this.myGraphTable = graphTable;
        this.myDataPack = initialDataPack;
        this.myRefsPanel = new RefsPanel(colorManager);
        this.myHashAuthorPanel = new DataPanel(logDataHolder.getProject(), false);
        JBScrollPane scrollPane = new JBScrollPane(){

            public Border getBorder() {
                return this.getVerticalScrollBar().isVisible() ? super.getBorder() : null;
            }
        };
        this.myMessageDataPanel = new DataPanel(logDataHolder.getProject(), true, (JScrollPane)scrollPane){
            final /* synthetic */ JScrollPane val$scrollPane;
            {
                this.val$scrollPane = jScrollPane;
                super(x0, x1);
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                size.width = this.val$scrollPane.getViewport().getWidth() - 5;
                return size;
            }
        };
        scrollPane.setViewportView(this.myMessageDataPanel);
        this.myContainingBranchesPanel = new ContainingBranchesPanel();
        this.myMessagePanel = new MessagePanel();
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)logDataHolder, 300);
        NonOpaquePanel header = new NonOpaquePanel((LayoutManager)new BorderLayout());
        header.add((Component)this.myRefsPanel, "North");
        header.add((Component)this.myHashAuthorPanel, "South");
        this.myLoadingPanel.add((Component)header, (Object)"North");
        this.myLoadingPanel.add((Component)scrollPane, (Object)"Center");
        this.myLoadingPanel.add((Component)this.myContainingBranchesPanel, (Object)"South");
        this.myLoadingPanel.setOpaque(false);
        this.setLayout(new CardLayout());
        this.add((Component)this.myLoadingPanel, STANDARD_LAYER);
        this.add((Component)((Object)this.myMessagePanel), MESSAGE_LAYER);
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.showMessage("No commits selected");
    }

    @Override
    public Color getBackground() {
        return UIUtil.getTableBackground();
    }

    void updateDataPack(@NotNull VisiblePack dataPack) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/ui/frame/DetailsPanel", "updateDataPack"));
        }
        this.myDataPack = dataPack;
    }

    @Override
    public void valueChanged(@Nullable ListSelectionEvent notUsed) {
        int[] rows = this.myGraphTable.getSelectedRows();
        if (rows.length < 1) {
            this.showMessage("No commits selected");
        } else if (rows.length > 1) {
            this.showMessage("Several commits selected");
        } else {
            ((CardLayout)this.getLayout()).show(this, STANDARD_LAYER);
            int row = rows[0];
            GraphTableModel tableModel = (GraphTableModel)this.myGraphTable.getModel();
            Hash hash = tableModel.getHashAtRow(row);
            VcsFullCommitDetails commitData = (VcsFullCommitDetails)this.myLogDataHolder.getCommitDetailsGetter().getCommitData(row, tableModel);
            if (commitData == null || hash == null) {
                this.showMessage("No commits selected");
                return;
            }
            if (commitData instanceof LoadingDetails) {
                this.myLoadingPanel.startLoading();
                this.myHashAuthorPanel.setData(null);
                this.myMessageDataPanel.setData(null);
                this.myRefsPanel.setRefs(Collections.<VcsRef>emptyList());
            } else {
                this.myLoadingPanel.stopLoading();
                this.myHashAuthorPanel.setData(commitData);
                this.myMessageDataPanel.setData(commitData);
                this.myRefsPanel.setRefs(this.sortRefs(hash, commitData.getRoot()));
            }
            List<String> branches = null;
            if (!(commitData instanceof LoadingDetails)) {
                branches = this.myLogDataHolder.getContainingBranchesGetter().requestContainingBranches(commitData.getRoot(), hash);
            }
            this.myContainingBranchesPanel.setBranches(branches);
        }
    }

    private void showMessage(String text) {
        this.myLoadingPanel.stopLoading();
        ((CardLayout)this.getLayout()).show(this, MESSAGE_LAYER);
        this.myMessagePanel.setText(text);
    }

    @NotNull
    private List<VcsRef> sortRefs(@NotNull Hash hash, @NotNull VirtualFile root) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/ui/frame/DetailsPanel", "sortRefs"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/ui/frame/DetailsPanel", "sortRefs"));
        }
        Collection<VcsRef> refs = this.myDataPack.getRefsModel().refsToCommit(hash);
        List list = ContainerUtil.sorted(refs, (Comparator)this.myLogDataHolder.getLogProvider(root).getReferenceManager().getComparator());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/DetailsPanel", "sortRefs"));
        }
        return list;
    }

    private static class MessagePanel
    extends NonOpaquePanel {
        private final JLabel myLabel = new JLabel();

        MessagePanel() {
            super((LayoutManager)new BorderLayout());
            this.myLabel.setForeground(UIUtil.getInactiveTextColor());
            this.myLabel.setHorizontalAlignment(0);
            this.myLabel.setVerticalAlignment(0);
            this.add(this.myLabel);
        }

        void setText(String text) {
            this.myLabel.setText(text);
        }
    }

    private static class RefsPanel
    extends JPanel {
        @NotNull
        private final RefPainter myRefPainter;
        @NotNull
        private List<VcsRef> myRefs;

        RefsPanel(@NotNull VcsLogColorManager colorManager) {
            if (colorManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorManager", "com/intellij/vcs/log/ui/frame/DetailsPanel$RefsPanel", "<init>"));
            }
            this.myRefPainter = new RefPainter(colorManager, false);
            this.myRefs = Collections.emptyList();
            this.setPreferredSize(new Dimension(-1, 26));
            this.setOpaque(false);
        }

        @Override
        protected void paintComponent(Graphics g) {
            this.myRefPainter.draw((Graphics2D)g, this.myRefs, 0, this.getWidth());
        }

        void setRefs(@NotNull List<VcsRef> refs) {
            if (refs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/ui/frame/DetailsPanel$RefsPanel", "setRefs"));
            }
            this.myRefs = refs;
            this.setVisible(!this.myRefs.isEmpty());
            this.repaint();
        }
    }

    private static class ContainingBranchesPanel
    extends JPanel {
        private final JComponent myLoadingComponent;
        private final JTextField myBranchesList;

        ContainingBranchesPanel() {
            JBLabel label = new JBLabel("Contained in branches: "){

                public Font getFont() {
                    return UIUtil.getLabelFont().deriveFont(2);
                }
            };
            this.myLoadingComponent = new NonOpaquePanel((LayoutManager)new BorderLayout());
            this.myLoadingComponent.add((Component)new AsyncProcessIcon("Loading..."), "West");
            this.myLoadingComponent.add(Box.createHorizontalGlue(), "Center");
            this.myBranchesList = new JBTextField(""){
                private final Border gtkBorder;
                private final Border emptyBorder;
                {
                    this.gtkBorder = new LineBorder(UIUtil.getTextFieldBackground(), 3){

                        @Override
                        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                            this.lineColor = UIUtil.getTextFieldBackground();
                            super.paintBorder(c, g, x, y, width, height);
                        }
                    };
                    this.emptyBorder = IdeBorderFactory.createEmptyBorder();
                }

                public Border getBorder() {
                    return UIUtil.isUnderGTKLookAndFeel() ? this.gtkBorder : this.emptyBorder;
                }
            };
            this.myBranchesList.setOpaque(false);
            this.myBranchesList.setEditable(false);
            this.setOpaque(false);
            this.setLayout(new BorderLayout());
            this.add((Component)label, "West");
            this.add(Box.createHorizontalGlue(), "East");
        }

        void setBranches(@Nullable List<String> branches) {
            if (branches == null) {
                this.remove(this.myBranchesList);
                this.add((Component)this.myLoadingComponent, "Center");
            } else {
                this.remove(this.myLoadingComponent);
                this.myBranchesList.setText(StringUtil.join(branches, (String)", "));
                this.add((Component)this.myBranchesList, "Center");
            }
            this.revalidate();
            this.repaint();
        }
    }

    private static class DataPanel
    extends JEditorPane {
        @NotNull
        private final Project myProject;
        private final boolean myMessageMode;

        DataPanel(@NotNull Project project, boolean messageMode) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/ui/frame/DetailsPanel$DataPanel", "<init>"));
            }
            super("text/html", "");
            this.myMessageMode = messageMode;
            this.setEditable(false);
            this.myProject = project;
            this.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
            this.setOpaque(false);
            this.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        }

        void setData(@Nullable VcsFullCommitDetails commit) {
            if (commit == null) {
                this.setText("");
            } else {
                String body = this.myMessageMode ? this.getMessageText(commit) : ((Hash)commit.getId()).asString() + "<br/>" + DataPanel.getAuthorText(commit);
                this.setText("<html><head>" + UIUtil.getCssFontDeclaration((Font)UIUtil.getLabelFont()) + "</head><body>" + body + "</body></html>");
                this.setCaretPosition(0);
            }
            this.revalidate();
            this.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            int h = this.getFontMetrics(this.getFont()).getHeight();
            size.height = Math.max(size.height, this.myMessageMode ? 5 * h : 2 * h);
            return size;
        }

        private String getMessageText(VcsFullCommitDetails commit) {
            String fullMessage = commit.getFullMessage();
            int separator = fullMessage.indexOf("\n\n");
            String subject = separator > 0 ? fullMessage.substring(0, separator) : fullMessage;
            String description = fullMessage.substring(subject.length());
            return "<b>" + IssueLinkHtmlRenderer.formatTextWithLinks(this.myProject, subject) + "</b>" + IssueLinkHtmlRenderer.formatTextWithLinks(this.myProject, description);
        }

        private static String getAuthorText(VcsFullCommitDetails commit) {
            String authorText = commit.getAuthor().getName() + " at " + DateFormatUtil.formatDateTime((long)commit.getAuthorTime());
            if (!commit.getAuthor().equals(commit.getCommitter())) {
                String commitTime = commit.getAuthorTime() != commit.getCommitTime() ? " at " + DateFormatUtil.formatDateTime((long)commit.getCommitTime()) : "";
                authorText = authorText + " (committed by " + commit.getCommitter().getName() + commitTime + ")";
            } else if (commit.getAuthorTime() != commit.getCommitTime()) {
                authorText = authorText + " (committed at " + DateFormatUtil.formatDateTime((long)commit.getCommitTime()) + ")";
            }
            return authorText;
        }
    }
}

