/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.render;

import com.intellij.ui.JBColor;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.RoundRectangle2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefPainter {
    private static final int RECTANGLE_X_PADDING = 4;
    private static final int RECTANGLE_Y_PADDING = 3;
    private static final int REF_PADDING = 13;
    private static final int LABEL_PADDING = 3;
    private static final int FLAG_WIDTH = 8;
    private static final int FLAG_PADDING = 8;
    private static final int FLAG_TOP_INDENT = 2;
    private static final int ROUND_RADIUS = 5;
    public static final Font DEFAULT_FONT = new Font("Arial", 0, 12);
    private static final Color DEFAULT_FONT_COLOR = JBColor.BLACK;
    @NotNull
    private final VcsLogColorManager myColorManager;
    private final boolean myDrawMultiRepoIndicator;

    public RefPainter(@NotNull VcsLogColorManager manager, boolean drawMultiRepoIndicator) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/vcs/log/ui/render/RefPainter", "<init>"));
        }
        this.myColorManager = manager;
        this.myDrawMultiRepoIndicator = drawMultiRepoIndicator;
    }

    private double paddingStr(@NotNull String str, @NotNull FontRenderContext renderContext) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/vcs/log/ui/render/RefPainter", "paddingStr"));
        }
        if (renderContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderContext", "com/intellij/vcs/log/ui/render/RefPainter", "paddingStr"));
        }
        return RefPainter.getStringWidth(str, renderContext) + 13.0 + (double)this.flagWidth();
    }

    private static double getStringWidth(@NotNull String str, @NotNull FontRenderContext renderContext) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/vcs/log/ui/render/RefPainter", "getStringWidth"));
        }
        if (renderContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderContext", "com/intellij/vcs/log/ui/render/RefPainter", "getStringWidth"));
        }
        return DEFAULT_FONT.getStringBounds(str, renderContext).getWidth();
    }

    private int flagWidth() {
        return this.myColorManager.isMultipleRoots() && this.myDrawMultiRepoIndicator ? 16 : 0;
    }

    private static void drawText(@NotNull Graphics2D g2, @NotNull String str, int padding) {
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2", "com/intellij/vcs/log/ui/render/RefPainter", "drawText"));
        }
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/vcs/log/ui/render/RefPainter", "drawText"));
        }
        FontMetrics metrics = g2.getFontMetrics();
        g2.setColor(DEFAULT_FONT_COLOR);
        int x = padding + 6;
        int y = 11 + (metrics.getAscent() - metrics.getDescent()) / 2;
        g2.drawString(str, x, y);
    }

    private int draw(@NotNull Graphics2D g2, @NotNull VcsRef ref, int padding) {
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2", "com/intellij/vcs/log/ui/render/RefPainter", "draw"));
        }
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/vcs/log/ui/render/RefPainter", "draw"));
        }
        Rectangle rectangle = this.drawLabel(g2, ref.getName(), padding, ref.getType().getBackgroundColor(), this.myColorManager.getRootColor(ref.getRoot()));
        return rectangle.x;
    }

    private void drawRootIndicator(@NotNull Graphics2D g2, int x, int y, int height, @NotNull Color rootIndicatorColor) {
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2", "com/intellij/vcs/log/ui/render/RefPainter", "drawRootIndicator"));
        }
        if (rootIndicatorColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootIndicatorColor", "com/intellij/vcs/log/ui/render/RefPainter", "drawRootIndicator"));
        }
        g2.setColor(rootIndicatorColor);
        int x0 = x + 8;
        int xMid = x0 + 4;
        int xRight = x0 + 8;
        int y0 = y - 2;
        int yMid = y0 + 2 * height / 3 - 2;
        int yBottom = y0 + height - 4;
        Polygon polygon = new Polygon(new int[]{x0, xRight, xRight, xMid, x0}, new int[]{y0, y0, yMid, yBottom, yMid}, 5);
        g2.fillPolygon(polygon);
        g2.setColor(this.myColorManager.getReferenceBorderColor());
        g2.drawPolygon(polygon);
    }

    public int padding(@NotNull Collection<String> refs, FontMetrics fontMetrics) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/ui/render/RefPainter", "padding"));
        }
        int p = 0;
        for (String ref : refs) {
            XAndWidth xAndWidth = this.getXAndWidth(ref, 0, fontMetrics);
            p += xAndWidth.x + xAndWidth.width + 3;
        }
        if (p > 0) {
            p += 3;
        }
        return p;
    }

    public Map<Integer, VcsRef> draw(@NotNull Graphics2D g2, @NotNull Collection<VcsRef> refs, int startPadding, int maxWidth) {
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2", "com/intellij/vcs/log/ui/render/RefPainter", "draw"));
        }
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/ui/render/RefPainter", "draw"));
        }
        float currentPadding = startPadding;
        RefPainter.setupGraphics(g2);
        FontRenderContext renderContext = g2.getFontRenderContext();
        HashMap<Integer, VcsRef> positions = new HashMap<Integer, VcsRef>();
        for (VcsRef ref : refs) {
            int x = this.draw(g2, ref, (int)currentPadding);
            positions.put(x, ref);
            currentPadding = (float)((double)currentPadding + this.paddingStr(ref.getName(), renderContext));
            if (maxWidth <= 0 || x < maxWidth) continue;
            break;
        }
        return positions;
    }

    private static void setupGraphics(Graphics2D g2) {
        g2.setFont(DEFAULT_FONT);
        g2.setStroke(new BasicStroke(1.5f));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public void drawLabels(@NotNull Graphics2D g2, @NotNull Map<String, Color> labels, int startPadding) {
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2", "com/intellij/vcs/log/ui/render/RefPainter", "drawLabels"));
        }
        if (labels == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labels", "com/intellij/vcs/log/ui/render/RefPainter", "drawLabels"));
        }
        int padding = startPadding;
        for (Map.Entry<String, Color> entry : labels.entrySet()) {
            Rectangle rectangle = this.drawLabel(g2, entry.getKey(), padding, entry.getValue(), null);
            padding += rectangle.width + 3;
        }
    }

    private XAndWidth getXAndWidth(String label, int paddingX, FontMetrics metrics) {
        int x = paddingX + 6 - 4;
        int width = metrics.stringWidth(label) + 8 + this.flagWidth();
        return new XAndWidth(x, width);
    }

    public Rectangle drawLabel(@NotNull Graphics2D g2, @NotNull String label, int paddingX, @NotNull Color bgColor, @Nullable Color rootIndicatorColor) {
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2", "com/intellij/vcs/log/ui/render/RefPainter", "drawLabel"));
        }
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/intellij/vcs/log/ui/render/RefPainter", "drawLabel"));
        }
        if (bgColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bgColor", "com/intellij/vcs/log/ui/render/RefPainter", "drawLabel"));
        }
        RefPainter.setupGraphics(g2);
        FontMetrics metrics = g2.getFontMetrics();
        XAndWidth xAndWidth = this.getXAndWidth(label, paddingX, metrics);
        int x = xAndWidth.x;
        int width = xAndWidth.width;
        int y = 3;
        int height = 16;
        RoundRectangle2D.Double rectangle2D = new RoundRectangle2D.Double(x, y, width, height, 5.0, 5.0);
        g2.setColor(bgColor);
        g2.fill(rectangle2D);
        g2.setColor(this.myColorManager.getReferenceBorderColor());
        g2.draw(rectangle2D);
        g2.setColor((Color)JBColor.BLACK);
        RefPainter.drawText(g2, label, paddingX + this.flagWidth());
        if (rootIndicatorColor != null && this.myColorManager.isMultipleRoots() && this.myDrawMultiRepoIndicator) {
            this.drawRootIndicator(g2, paddingX, y, height, rootIndicatorColor);
        }
        return new Rectangle(x, y, width, height);
    }

    private static class XAndWidth {
        private final int x;
        private final int width;

        private XAndWidth(int x, int width) {
            this.x = x;
            this.width = width;
        }
    }
}

