/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorTextField;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.ui.XDebuggerEditorBase;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerMultilineEditor
extends XDebuggerEditorBase {
    private final JComponent myComponent;
    private final EditorTextField myEditorTextField;
    private XExpression myExpression;

    public XDebuggerMultilineEditor(Project project, XDebuggerEditorsProvider debuggerEditorsProvider, @Nullable @NonNls String historyId, @Nullable XSourcePosition sourcePosition, @NotNull XExpression text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/xdebugger/impl/ui/XDebuggerMultilineEditor", "<init>"));
        }
        super(project, debuggerEditorsProvider, EvaluationMode.CODE_FRAGMENT, historyId, sourcePosition);
        this.myExpression = XExpressionImpl.changeMode(text, this.getMode());
        this.myEditorTextField = new EditorTextField(this.createDocument(this.myExpression), project, debuggerEditorsProvider.getFileType()){

            @Override
            protected EditorEx createEditor() {
                EditorEx editor = super.createEditor();
                editor.setVerticalScrollbarVisible(true);
                return editor;
            }

            @Override
            protected boolean isOneLineMode() {
                return false;
            }
        };
        this.myEditorTextField.setFontInheritedFromLAF(false);
        this.myComponent = this.addChooseFactoryLabel((JComponent)((Object)this.myEditorTextField), true);
    }

    @Override
    public JComponent getComponent() {
        return this.myComponent;
    }

    @Override
    protected void doSetText(XExpression text) {
        this.myExpression = text;
        Language language = text.getLanguage();
        LanguageFileType fileType = language != null ? language.getAssociatedFileType() : this.getEditorsProvider().getFileType();
        this.myEditorTextField.setNewDocumentAndFileType((FileType)fileType, this.createDocument(text));
    }

    @Override
    public XExpression getExpression() {
        return this.getEditorsProvider().createExpression(this.getProject(), this.myEditorTextField.getDocument(), this.myExpression.getLanguage(), EvaluationMode.CODE_FRAGMENT);
    }

    @Override
    @Nullable
    public JComponent getPreferredFocusedComponent() {
        Editor editor = this.myEditorTextField.getEditor();
        return editor != null ? editor.getContentComponent() : null;
    }

    @Override
    @Nullable
    public Editor getEditor() {
        return this.myEditorTextField.getEditor();
    }

    @Override
    public void selectAll() {
        this.myEditorTextField.selectAll();
    }
}

