/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XNearestSourcePosition;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.frame.XVariablesView;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.HeadlessValueEvaluationCallback;
import com.intellij.xdebugger.impl.ui.tree.nodes.RestorableStateNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodePresentationConfigurator;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValuePresentationUtil;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueTextRendererImpl;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XValueNodeImpl
extends XValueContainerNode<XValue>
implements XValueNode,
XCompositeNode,
XValueNodePresentationConfigurator.ConfigurableXValueNode,
RestorableStateNode {
    public static final Comparator<XValueNodeImpl> COMPARATOR = new Comparator<XValueNodeImpl>(){

        @Override
        public int compare(XValueNodeImpl o1, XValueNodeImpl o2) {
            return StringUtil.naturalCompare((String)o1.getName(), (String)o2.getName());
        }
    };
    private final String myName;
    @Nullable
    private String myRawValue;
    private XFullValueEvaluator myFullValueEvaluator;
    private boolean myChanged;
    private XValuePresentation myValuePresentation;

    public XValueNodeImpl(XDebuggerTree tree, @Nullable XDebuggerTreeNode parent, String name, @NotNull XValue value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl", "<init>"));
        }
        super(tree, parent, value);
        this.myName = name;
        value.computePresentation((XValueNode)this, XValuePlace.TREE);
        if (!this.isComputed()) {
            if (this.myName != null) {
                this.myText.append(this.myName, XDebuggerUIConstants.VALUE_NAME_ATTRIBUTES);
                this.myText.append(" = ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
            this.myText.append(XDebuggerUIConstants.COLLECTING_DATA_MESSAGE, XDebuggerUIConstants.COLLECTING_DATA_HIGHLIGHT_ATTRIBUTES);
        }
    }

    public void setPresentation(@Nullable Icon icon, @NonNls @Nullable String type, @NonNls @NotNull String value, boolean hasChildren) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl", "setPresentation"));
        }
        XValueNodePresentationConfigurator.setPresentation(icon, type, value, hasChildren, this);
    }

    public void setPresentation(@Nullable Icon icon, @NonNls @Nullable String type, @NonNls @NotNull String separator, @NonNls @Nullable String value, boolean hasChildren) {
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl", "setPresentation"));
        }
        XValueNodePresentationConfigurator.setPresentation(icon, type, separator, value, hasChildren, (XValueNodePresentationConfigurator.ConfigurableXValueNode)this);
    }

    public void setPresentation(@Nullable Icon icon, @NonNls @Nullable String type, @NonNls @NotNull String value, @Nullable NotNullFunction<String, String> valuePresenter, boolean hasChildren) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl", "setPresentation"));
        }
        XValueNodePresentationConfigurator.setPresentation(icon, type, value, valuePresenter, hasChildren, (XValueNodePresentationConfigurator.ConfigurableXValueNode)this);
    }

    public void setPresentation(@Nullable Icon icon, @NotNull XValuePresentation presentation, boolean hasChildren) {
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl", "setPresentation"));
        }
        XValueNodePresentationConfigurator.setPresentation(icon, presentation, hasChildren, this);
    }

    public void setPresentation(@Nullable Icon icon, @NonNls @Nullable String type, @NonNls @NotNull String separator, @NonNls @NotNull String value, @Nullable NotNullFunction<String, String> valuePresenter, boolean hasChildren) {
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl", "setPresentation"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl", "setPresentation"));
        }
        XValueNodePresentationConfigurator.setPresentation(icon, type, separator, valuePresenter, hasChildren, (XValueNodePresentationConfigurator.ConfigurableXValueNode)this);
    }

    @Override
    public void applyPresentation(@Nullable Icon icon, @NotNull XValuePresentation valuePresentation, boolean hasChildren) {
        if (valuePresentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valuePresentation", "com/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl", "applyPresentation"));
        }
        this.setIcon(icon);
        this.myValuePresentation = valuePresentation;
        this.myRawValue = XValuePresentationUtil.computeValueText(valuePresentation);
        if (Registry.is((String)"ide.debugger.inline")) {
            this.updateInlineDebuggerData();
        }
        this.updateText();
        this.setLeaf(!hasChildren);
        this.fireNodeChanged();
        this.myTree.nodeLoaded(this, this.myName);
    }

    public void updateInlineDebuggerData() {
        try {
            XSourcePosition position;
            XDebugSession session = XDebugView.getSession((Component)((Object)this.getTree()));
            if (session != null && (position = session.getCurrentPosition()) != null) {
                final XInlineDebuggerDataCallback callback = new XInlineDebuggerDataCallback(){

                    public void computed(@NotNull VirtualFile file, @NotNull Document document, int line) {
                        if (file == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl$2", "computed"));
                        }
                        if (document == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl$2", "computed"));
                        }
                        Map map = (Map)XValueNodeImpl.this.myTree.getProject().getUserData(XVariablesView.DEBUG_VARIABLES);
                        Map timestamps = (Map)XValueNodeImpl.this.myTree.getProject().getUserData(XVariablesView.DEBUG_VARIABLES_TIMESTAMPS);
                        if (map == null || timestamps == null) {
                            return;
                        }
                        Pair key = Pair.create((Object)file, (Object)line);
                        LinkedHashSet<XValueNodeImpl> presentations = new LinkedHashSet<XValueNodeImpl>();
                        Set old = map.put(key, presentations);
                        timestamps.put(file, document.getModificationStamp());
                        presentations.add(XValueNodeImpl.this);
                        if (old != null) {
                            presentations.addAll(old);
                        }
                    }
                };
                if (((XValue)this.getValueContainer()).computeInlineDebuggerData(callback) == ThreeState.UNSURE) {
                    ((XValue)this.getValueContainer()).computeSourcePosition((XNavigatable)new XNearestSourcePosition(){

                        public void setSourcePosition(@Nullable XSourcePosition sourcePosition) {
                            Map map = (Map)XValueNodeImpl.this.myTree.getProject().getUserData(XVariablesView.DEBUG_VARIABLES);
                            Map timestamps = (Map)XValueNodeImpl.this.myTree.getProject().getUserData(XVariablesView.DEBUG_VARIABLES_TIMESTAMPS);
                            if (map == null || timestamps == null || sourcePosition == null) {
                                return;
                            }
                            VirtualFile file = sourcePosition.getFile();
                            Document doc = FileDocumentManager.getInstance().getDocument(file);
                            if (doc == null) {
                                return;
                            }
                            int line = sourcePosition.getLine();
                            callback.computed(file, doc, line);
                        }
                    });
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setFullValueEvaluator(final @NotNull XFullValueEvaluator fullValueEvaluator) {
        if (fullValueEvaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullValueEvaluator", "com/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl", "setFullValueEvaluator"));
        }
        AppUIUtil.invokeOnEdt(new Runnable(){

            @Override
            public void run() {
                XValueNodeImpl.this.myFullValueEvaluator = fullValueEvaluator;
                XValueNodeImpl.this.fireNodeChanged();
            }
        });
    }

    private void updateText() {
        ValueMarkup markup;
        this.myText.clear();
        XValueMarkers<?, ?> markers = this.myTree.getValueMarkers();
        if (markers != null && (markup = markers.getMarkup((XValue)this.myValueContainer)) != null) {
            this.myText.append("[" + markup.getText() + "] ", new SimpleTextAttributes(1, markup.getColor()));
        }
        this.appendName();
        XValueNodeImpl.buildText(this.myValuePresentation, (ColoredTextContainer)this.myText);
    }

    private void appendName() {
        if (!StringUtil.isEmpty((String)this.myName)) {
            SimpleTextAttributes attributes = this.myChanged ? XDebuggerUIConstants.CHANGED_VALUE_ATTRIBUTES : XDebuggerUIConstants.VALUE_NAME_ATTRIBUTES;
            XValuePresentationUtil.renderValue(this.myName, (ColoredTextContainer)this.myText, attributes, 100, null);
        }
    }

    public static void buildText(@NotNull XValuePresentation valuePresenter, @NotNull ColoredTextContainer text) {
        if (valuePresenter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valuePresenter", "com/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl", "buildText"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl", "buildText"));
        }
        XValueNodeImpl.buildText(valuePresenter, text, true);
    }

    public static void buildText(@NotNull XValuePresentation valuePresenter, @NotNull ColoredTextContainer text, boolean appendSeparator) {
        String type;
        if (valuePresenter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valuePresenter", "com/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl", "buildText"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl", "buildText"));
        }
        if (appendSeparator) {
            XValuePresentationUtil.appendSeparator(text, valuePresenter.getSeparator());
        }
        if ((type = valuePresenter.getType()) != null) {
            text.append("{" + type + "} ", XDebuggerUIConstants.TYPE_ATTRIBUTES);
        }
        valuePresenter.renderValue((XValuePresentation.XValueTextRenderer)new XValueTextRendererImpl(text));
    }

    @Override
    public void markChanged() {
        if (this.myChanged) {
            return;
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myChanged = true;
        if (this.myName != null && this.myValuePresentation != null) {
            this.updateText();
            this.fireNodeChanged();
        }
    }

    @Nullable
    public XFullValueEvaluator getFullValueEvaluator() {
        return this.myFullValueEvaluator;
    }

    @Override
    @Nullable
    protected XDebuggerTreeNodeHyperlink getLink() {
        if (this.myFullValueEvaluator != null) {
            return new XDebuggerTreeNodeHyperlink(this.myFullValueEvaluator.getLinkText()){

                public void onClick(MouseEvent event) {
                    if (XValueNodeImpl.this.myFullValueEvaluator.isShowValuePopup()) {
                        DebuggerUIUtil.showValuePopup(XValueNodeImpl.this.myFullValueEvaluator, event, XValueNodeImpl.this.myTree.getProject(), null);
                    } else {
                        new HeadlessValueEvaluationCallback(XValueNodeImpl.this).startFetchingValue(XValueNodeImpl.this.myFullValueEvaluator);
                    }
                    event.consume();
                }
            };
        }
        return null;
    }

    @Override
    @Nullable
    public String getName() {
        return this.myName;
    }

    @Nullable
    public XValuePresentation getValuePresentation() {
        return this.myValuePresentation;
    }

    @Override
    @Nullable
    public String getRawValue() {
        return this.myRawValue;
    }

    @Override
    public boolean isComputed() {
        return this.myValuePresentation != null;
    }

    public void setValueModificationStarted() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myRawValue = null;
        this.myText.clear();
        this.appendName();
        XValuePresentationUtil.appendSeparator((ColoredTextContainer)this.myText, this.myValuePresentation.getSeparator());
        this.myText.append(XDebuggerUIConstants.MODIFYING_VALUE_MESSAGE, XDebuggerUIConstants.MODIFYING_VALUE_HIGHLIGHT_ATTRIBUTES);
        this.setLeaf(true);
        this.fireNodeStructureChanged();
    }

    public String toString() {
        return this.getName();
    }
}

