/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.PsiManager;
import com.intellij.util.IncorrectOperationException;
import org.intellij.plugins.relaxNG.compact.RncTokenTypes;
import org.intellij.plugins.relaxNG.compact.psi.RncFileReference;
import org.intellij.plugins.relaxNG.compact.psi.util.RenameUtil;
import org.jetbrains.annotations.NotNull;

public class RncFileReferenceManipulator
extends AbstractElementManipulator<RncFileReference> {
    public RncFileReference handleContentChange(@NotNull RncFileReference element, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/plugins/relaxNG/RncFileReferenceManipulator", "handleContentChange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/intellij/plugins/relaxNG/RncFileReferenceManipulator", "handleContentChange"));
        }
        ASTNode node = element.getNode();
        assert (node != null);
        ASTNode literal = node.findChildByType(RncTokenTypes.LITERAL);
        if (literal != null) {
            assert (range.equals((Object)element.getReferenceRange()));
            PsiManager manager = element.getManager();
            ASTNode newChild = RenameUtil.createLiteralNode(manager, newContent);
            literal.getTreeParent().replaceChild(literal, newChild);
        }
        return element;
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull RncFileReference element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/plugins/relaxNG/RncFileReferenceManipulator", "getRangeInElement"));
        }
        TextRange textRange = element.getReferenceRange();
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/RncFileReferenceManipulator", "getRangeInElement"));
        }
        return textRange;
    }
}

