/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.XSourcePositionWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SourceInfo
extends XSourcePositionWrapper {
    private final String functionName;
    private final int column;

    @Nullable
    public static SourceInfo create(@Nullable String functionName, @Nullable XSourcePosition position, int column) {
        return position == null ? null : new SourceInfo(functionName, position, column);
    }

    private SourceInfo(@Nullable String functionName, @NotNull XSourcePosition position, int column) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "org/jetbrains/debugger/SourceInfo", "<init>"));
        }
        super(position);
        this.functionName = functionName;
        this.column = column;
    }

    @Nullable
    public String getFunctionName() {
        return this.functionName;
    }

    public int getColumn() {
        return this.column;
    }

    @NotNull
    public Navigatable createNavigatable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/debugger/SourceInfo", "createNavigatable"));
        }
        OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(project, this.myPosition.getFile(), this.myPosition.getLine(), this.column);
        if (openFileDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/SourceInfo", "createNavigatable"));
        }
        return openFileDescriptor;
    }
}

