/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.lang.manifest.highlighting;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.header.HeaderParser;
import org.jetbrains.lang.manifest.header.HeaderParserRepository;
import org.jetbrains.lang.manifest.psi.Header;

public class HeaderAnnotator
implements Annotator {
    private final HeaderParserRepository myRepository;

    public HeaderAnnotator(@NotNull HeaderParserRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/jetbrains/lang/manifest/highlighting/HeaderAnnotator", "<init>"));
        }
        this.myRepository = repository;
    }

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        Header header;
        HeaderParser headerParser;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/lang/manifest/highlighting/HeaderAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/lang/manifest/highlighting/HeaderAnnotator", "annotate"));
        }
        if (psiElement instanceof Header && (headerParser = this.myRepository.getHeaderParser((header = (Header)psiElement).getName())) != null) {
            headerParser.annotate(header, holder);
        }
    }
}

