/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.navigation.macros;

import com.android.navigation.ActivityState;
import com.android.navigation.Locator;
import com.android.navigation.MenuState;
import com.android.navigation.NavigationModel;
import com.android.navigation.Transition;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.navigation.NavigationView;
import com.android.tools.idea.editors.navigation.Utilities;
import com.android.tools.idea.editors.navigation.macros.FragmentEntry;
import com.android.tools.idea.editors.navigation.macros.Macros;
import com.android.tools.idea.editors.navigation.macros.MultiMatch;
import com.android.tools.idea.model.ManifestInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.dom.AndroidAttributeValue;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.Nullable;

public class Analyser {
    private static final Logger LOG = Logger.getInstance((String)("#" + Analyser.class.getName()));
    private static final String[] ID_PREFIXES = new String[]{"@+id/", "@android:id/"};
    private static final boolean DEBUG = false;
    private final Module myModule;
    private final Macros myMacros;

    public Analyser(Module module) {
        this.myModule = module;
        this.myMacros = Macros.getInstance(this.myModule.getProject());
    }

    public NavigationModel getNavigationModel(Configuration configuration) {
        NavigationModel result = new NavigationModel();
        this.deriveAllStatesAndTransitions(result, configuration);
        return result;
    }

    @Nullable
    private static String qualifyClassNameIfNecessary(@Nullable String packageName, String className) {
        if (className == null) {
            return null;
        }
        if (className.startsWith(".")) {
            if (packageName == null) {
                LOG.warn("Missing package name for unqualified class: " + className);
                return null;
            }
            return packageName + className;
        }
        return className;
    }

    @Nullable
    public static String unQuote(String s) {
        if (s.startsWith("\"") && s.endsWith("\"")) {
            return s.substring(1, s.length() - 1);
        }
        assert (false);
        return null;
    }

    public static void commit(Project project, @Nullable PsiFile file) {
        if (file == null) {
            return;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document document1 = documentManager.getDocument(file);
        if (document1 != null) {
            documentManager.commitDocument(document1);
        }
    }

    private static Set<String> readManifestFile(Project project) {
        Module[] modules;
        HashSet<String> result = new HashSet<String>();
        for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
            if (AndroidFacet.getInstance(module) == null) continue;
            ManifestInfo manifestInfo = ManifestInfo.get(module, false);
            String packageName = manifestInfo.getPackage();
            List<Activity> activities = manifestInfo.getActivities();
            for (Activity activity : activities) {
                AndroidAttributeValue<PsiClass> activityClass = activity.getActivityClass();
                String className = activityClass.getRawText();
                String qualifiedName = Analyser.qualifyClassNameIfNecessary(packageName, className);
                result.add(qualifiedName);
            }
        }
        return result;
    }

    private static ActivityState getActivityState(String className, Map<String, ActivityState> classNameToActivityState) {
        ActivityState result = classNameToActivityState.get(className);
        if (result == null) {
            result = new ActivityState(className);
            classNameToActivityState.put(className, result);
        }
        return result;
    }

    private static MenuState getMenuState(String menuName, Map<String, MenuState> menuNameToMenuState) {
        MenuState result = menuNameToMenuState.get(menuName);
        if (result == null) {
            result = new MenuState(menuName);
            menuNameToMenuState.put(menuName, result);
        }
        return result;
    }

    public <T extends PsiVariable> Map<T, Object> searchForVariableAssignments(@Nullable PsiElement input, final Class<T> variableType, final Evaluator evaluator) {
        final HashMap result = new HashMap();
        Analyser.search(input, evaluator, this.myMacros.createMacro("void assign(Object $lhs, Object $rhs) { $lhs = $rhs; }"), new Processor(){

            @Override
            public void process(MultiMatch.Bindings<PsiElement> exp) {
                PsiReferenceExpression ref;
                PsiElement resolvedValue;
                PsiElement lExpression = exp.get("$lhs");
                PsiElement rExpression = exp.get("$rhs");
                if (lExpression instanceof PsiReferenceExpression && rExpression instanceof PsiExpression && variableType.isInstance(resolvedValue = (ref = (PsiReferenceExpression)lExpression).resolve())) {
                    result.put((PsiVariable)resolvedValue, evaluator.evaluate((PsiExpression)rExpression));
                }
            }
        });
        return result;
    }

    public Map<PsiLocalVariable, Object> searchForVariableBindings(@Nullable PsiElement input, final Evaluator evaluator) {
        final HashMap<PsiLocalVariable, Object> result = new HashMap<PsiLocalVariable, Object>();
        if (input == null) {
            return result;
        }
        input.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitDeclarationStatement(PsiDeclarationStatement statement) {
                PsiElement[] declaredElements;
                super.visitDeclarationStatement(statement);
                for (PsiElement element : declaredElements = statement.getDeclaredElements()) {
                    if (!(element instanceof PsiLocalVariable)) continue;
                    PsiLocalVariable local = (PsiLocalVariable)element;
                    PsiExpression rExpression = local.getInitializer();
                    result.put(local, evaluator.evaluate(rExpression));
                }
            }
        });
        return result;
    }

    private Map<PsiField, Object> getFieldAssignmentsInOnCreate(PsiClass activityClass, Evaluator evaluator) {
        if (activityClass == null) {
            return Collections.emptyMap();
        }
        PsiMethod method = Utilities.findMethodBySignature(activityClass, "void onCreate(Bundle bundle)");
        if (method == null) {
            return Collections.emptyMap();
        }
        return this.searchForVariableAssignments((PsiElement)method.getBody(), PsiField.class, evaluator);
    }

    private Map<PsiLocalVariable, Object> getLocalVariableBindingsInOnViewCreated(PsiClass activityClass, Evaluator evaluator) {
        if (activityClass == null) {
            return Collections.emptyMap();
        }
        PsiMethod method = Utilities.findMethodBySignature(activityClass, "void onViewCreated(View view, Bundle bundle)");
        if (method == null) {
            return Collections.emptyMap();
        }
        return this.searchForVariableBindings((PsiElement)method.getBody(), evaluator);
    }

    private Evaluator getEvaluator(final Set<String> ids, final Set<String> tags, final Map<PsiField, Object> fieldValues, final Map<PsiLocalVariable, Object> localVariableValues) {
        return new Evaluator(){

            @Override
            @Nullable
            public Object evaluate(@Nullable PsiExpression exp) {
                if (exp == null) {
                    return null;
                }
                if (exp instanceof PsiLiteral) {
                    PsiLiteral literal = (PsiLiteral)exp;
                    return literal.getValue();
                }
                MultiMatch.Bindings<PsiElement> match1 = ((Analyser)Analyser.this).myMacros.findViewById.match((PsiElement)exp);
                if (match1 != null) {
                    String id = ((PsiElement)match1.bindings.get("$id")).getText();
                    return ids.contains(id) ? new Object() : null;
                }
                MultiMatch.Bindings<PsiElement> match2 = ((Analyser)Analyser.this).myMacros.findFragmentByTag.match((PsiElement)exp);
                if (match2 != null) {
                    String tag = Analyser.unQuote(((PsiElement)match2.bindings.get("$tag")).getText());
                    return tags.contains(tag) ? new Object() : null;
                }
                if (exp instanceof PsiTypeCastExpression) {
                    PsiTypeCastExpression castExp = (PsiTypeCastExpression)exp;
                    return this.evaluate(castExp.getOperand());
                }
                if (exp instanceof PsiBinaryExpression) {
                    PsiBinaryExpression binExp = (PsiBinaryExpression)exp;
                    IElementType op = binExp.getOperationSign().getTokenType();
                    Object lhs = this.evaluate(binExp.getLOperand());
                    Object rhs = this.evaluate(binExp.getROperand());
                    if (op == JavaTokenType.EQEQ) {
                        return lhs == rhs;
                    }
                    if (op == JavaTokenType.NE) {
                        return lhs != rhs;
                    }
                }
                if (exp instanceof PsiReferenceExpression) {
                    PsiReferenceExpression psiReferenceExpression = (PsiReferenceExpression)exp;
                    PsiElement resolved = psiReferenceExpression.resolve();
                    if (resolved instanceof PsiField) {
                        PsiField field = (PsiField)resolved;
                        return fieldValues.get(field);
                    }
                    if (resolved instanceof PsiLocalVariable) {
                        PsiLocalVariable localVariable = (PsiLocalVariable)resolved;
                        return localVariableValues.get(localVariable);
                    }
                }
                return null;
            }
        };
    }

    @Nullable
    private static String getQualifiedName(@Nullable PsiClass psiClass) {
        return psiClass == null ? null : psiClass.getQualifiedName();
    }

    private Evaluator getEvaluator(Configuration configuration, PsiClass activityClass, PsiClass activityOrFragmentClass, boolean isActivity) {
        Set<String> tags = Analyser.getTags(this.getXmlFile(configuration, Analyser.getQualifiedName(activityClass), true));
        Set<String> ids = Analyser.getIds(this.getXmlFile(configuration, Analyser.getQualifiedName(activityOrFragmentClass), isActivity));
        Map<PsiField, Object> noFields = Collections.emptyMap();
        Map<PsiLocalVariable, Object> noVars = Collections.emptyMap();
        Evaluator evaluator1 = this.getEvaluator(ids, tags, noFields, noVars);
        Map<PsiField, Object> fieldBindings = this.getFieldAssignmentsInOnCreate(activityOrFragmentClass, evaluator1);
        Evaluator evaluator2 = this.getEvaluator(ids, tags, fieldBindings, noVars);
        Map<PsiLocalVariable, Object> localVariableBindings = this.getLocalVariableBindingsInOnViewCreated(activityOrFragmentClass, evaluator2);
        return this.getEvaluator(ids, tags, fieldBindings, localVariableBindings);
    }

    @Nullable
    private XmlFile getXmlFile(Configuration configuration, @Nullable String className, boolean isActivity) {
        if (className == null) {
            return null;
        }
        String xmlFileName = Analyser.getXMLFileName(this.myModule, className, isActivity);
        if (xmlFileName == null) {
            return null;
        }
        return (XmlFile)NavigationView.getLayoutXmlFile(false, xmlFileName, configuration, this.myModule.getProject());
    }

    private void deriveTransitions(final NavigationModel model, final MiniModel miniModel, final ActivityState fromActivityState, String activityOrFragmentClassName, final Configuration configuration, boolean isActivity) {
        final PsiClass activityClass = Utilities.getPsiClass(this.myModule, fromActivityState.getClassName());
        final PsiClass activityOrFragmentClass = Utilities.getPsiClass(this.myModule, activityOrFragmentClassName);
        final Evaluator evaluator = this.getEvaluator(configuration, activityClass, activityOrFragmentClass, isActivity);
        if (activityOrFragmentClass == null) {
            LOG.info("Class " + activityOrFragmentClassName + " not found");
            return;
        }
        Analyser.search(activityOrFragmentClass, "boolean onCreateOptionsMenu(Menu menu)", "void macro(Object target, String id, Menu menu) { target.inflate(id, menu); }", new Processor(){

            @Override
            public void process(MultiMatch.Bindings<PsiElement> args) {
                String menuIdName = args.get("id").getLastChild().getText();
                final MenuState menu = Analyser.getMenuState(menuIdName, miniModel.menuNameToMenuState);
                Analyser.addTransition(model, new Transition("Press", new Locator(fromActivityState), new Locator(menu)));
                Analyser.search(activityOrFragmentClass, "boolean onPrepareOptionsMenu(Menu m)", ((Analyser)Analyser.this).myMacros.installMenuItemOnGetMenuItemAndLaunchActivityMacro, new Processor(){

                    @Override
                    public void process(MultiMatch.Bindings<PsiElement> args) {
                        String className = Analyser.getQualifiedName(args.get("$f", "activityClass").getFirstChild());
                        if (className != null) {
                            ActivityState activityState = Analyser.getActivityState(className, miniModel.classNameToActivityState);
                            String menuItemName = args.get("$menuItem", "$id").getLastChild().getText();
                            Analyser.addTransition(model, new Transition("Press", Locator.of(menu, menuItemName), new Locator(activityState)));
                        }
                    }
                });
            }
        });
        Analyser.search(activityOrFragmentClass, "void onCreate(Bundle b)", this.myMacros.installClickAndCallMacro, new Processor(){

            @Override
            public void process(MultiMatch.Bindings<PsiElement> args) {
                PsiElement $view = args.get("$view");
                MultiMatch.Bindings<PsiElement> bindings = ((Analyser)Analyser.this).myMacros.findViewById.match($view);
                if (bindings != null) {
                    String tag = bindings.get("$id").getText();
                    Analyser.search(args.get("$f"), evaluator, ((Analyser)Analyser.this).myMacros.createIntent, Analyser.createProcessor(tag, miniModel.classNameToActivityState, model, fromActivityState));
                }
            }
        });
        Analyser.search(activityOrFragmentClass, "void onViewCreated(View v, Bundle b)", this.myMacros.installItemClickAndCallMacro, new Processor(){

            @Override
            public void process(MultiMatch.Bindings<PsiElement> args) {
                PsiElement $listView = args.get("$listView");
                String viewName = $listView == null ? null : com.android.navigation.Utilities.getPropertyName(Analyser.removeTrailingParens($listView.getText()));
                Analyser.search(args.get("$f"), evaluator, ((Analyser)Analyser.this).myMacros.createIntent, Analyser.createProcessor(viewName, miniModel.classNameToActivityState, model, fromActivityState));
            }
        });
        PsiClassType superType = activityOrFragmentClass.getSuperTypes()[0];
        if (superType.getClassName().equals("ListFragment")) {
            Analyser.search(activityOrFragmentClass, "void onListItemClick(ListView listView, View view, int position, long id)", "void macro(Object f) { f.$(); }", new Processor(){

                @Override
                public void process(MultiMatch.Bindings<PsiElement> args) {
                    PsiElement exp = args.get("f");
                    if (exp instanceof PsiMethodCallExpression) {
                        PsiMethod implementation;
                        PsiMethodCallExpression call = (PsiMethodCallExpression)exp;
                        if (call.getFirstChild().getFirstChild().getText().equals("super")) {
                            return;
                        }
                        PsiMethod resolvedMethod = call.resolveMethod();
                        if (resolvedMethod != null && activityClass != null && (implementation = activityClass.findMethodBySignature(resolvedMethod, false)) != null) {
                            Evaluator evaluator = Analyser.this.getEvaluator(configuration, activityClass, activityClass, true);
                            Analyser.search((PsiElement)implementation.getBody(), evaluator, ((Analyser)Analyser.this).myMacros.createIntent, Analyser.createProcessor(null, miniModel.classNameToActivityState, model, fromActivityState));
                        }
                    }
                }
            });
        }
    }

    public NavigationModel deriveAllStatesAndTransitions(NavigationModel model, Configuration configuration) {
        Set<String> activityClassNames = Analyser.readManifestFile(this.myModule.getProject());
        MiniModel toDo = new MiniModel(Analyser.getActivityClassNameToActivityState(activityClassNames), new HashMap<String, MenuState>());
        MiniModel next = new MiniModel();
        MiniModel done = new MiniModel();
        while (!toDo.classNameToActivityState.isEmpty()) {
            for (ActivityState sourceActivity : toDo.classNameToActivityState.values()) {
                if (done.classNameToActivityState.containsKey(sourceActivity.getClassName())) continue;
                model.addState(sourceActivity);
                this.deriveTransitions(model, next, sourceActivity, sourceActivity.getClassName(), configuration, true);
                XmlFile layoutFile = this.getXmlFile(configuration, sourceActivity.getClassName(), true);
                List<FragmentEntry> fragments = Analyser.getFragmentEntries(layoutFile);
                List<FragmentEntry> fragmentList = sourceActivity.getFragments();
                fragmentList.clear();
                fragmentList.addAll(fragments);
                for (FragmentEntry fragment : fragments) {
                    this.deriveTransitions(model, next, sourceActivity, fragment.className, configuration, false);
                }
            }
            done.classNameToActivityState.putAll(toDo.classNameToActivityState);
            toDo = next;
            next = new MiniModel();
        }
        return model;
    }

    private static Processor createProcessor(final @Nullable String viewName, final Map<String, ActivityState> activities, final NavigationModel model, final ActivityState fromState) {
        return new Processor(){

            @Override
            public void process(MultiMatch.Bindings<PsiElement> args) {
                PsiElement activityClass = args.get("activityClass").getFirstChild();
                String qualifiedName = Analyser.getQualifiedName(activityClass);
                if (qualifiedName != null) {
                    ActivityState toState = Analyser.getActivityState(qualifiedName, activities);
                    Analyser.addTransition(model, new Transition("Press", Locator.of(fromState, viewName), new Locator(toState)));
                }
            }
        };
    }

    private static List<FragmentEntry> getFragmentEntries(@Nullable XmlFile psiFile) {
        final ArrayList<FragmentEntry> result = new ArrayList<FragmentEntry>();
        if (psiFile == null) {
            return result;
        }
        psiFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                super.visitXmlTag(tag);
                if (tag.getName().equals("fragment")) {
                    String fragmentTag = tag.getAttributeValue("android:tag");
                    String fragmentClassName = tag.getAttributeValue("android:name");
                    if (fragmentClassName != null) {
                        result.add(new FragmentEntry(fragmentClassName, fragmentTag));
                    }
                }
            }
        });
        return result;
    }

    private static String getPrefix(String idName) {
        for (String prefix : ID_PREFIXES) {
            if (!idName.startsWith(prefix)) continue;
            return prefix;
        }
        int firstSlash = idName.indexOf(47);
        String prefix = idName.substring(0, firstSlash + 1);
        LOG.warn("Unrecognized prefix: " + prefix + " in " + idName);
        return prefix;
    }

    private static Set<String> getIds(@Nullable XmlFile psiFile) {
        final HashSet<String> result = new HashSet<String>();
        if (psiFile == null) {
            return result;
        }
        psiFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                super.visitXmlTag(tag);
                String id = tag.getAttributeValue("android:id");
                if (id != null) {
                    result.add(id.substring(Analyser.getPrefix(id).length()));
                }
            }
        });
        return result;
    }

    private static Set<String> getTags(@Nullable XmlFile psiFile) {
        final HashSet<String> result = new HashSet<String>();
        if (psiFile == null) {
            return result;
        }
        psiFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                super.visitXmlTag(tag);
                String id = tag.getAttributeValue("android:tag");
                if (id != null) {
                    result.add(id);
                }
            }
        });
        return result;
    }

    private static String removeTrailingParens(String text) {
        return text.endsWith("()") ? text.substring(0, text.length() - 2) : text;
    }

    private static boolean addTransition(NavigationModel model, Transition transition) {
        return model.add(transition);
    }

    @Nullable
    private static String getQualifiedName(PsiElement element) {
        PsiTypeElement psiTypeElement;
        PsiType type1;
        if (element instanceof PsiTypeElement && (type1 = (psiTypeElement = (PsiTypeElement)element).getType()) instanceof PsiClassReferenceType) {
            PsiClassReferenceType type = (PsiClassReferenceType)type1;
            return Analyser.getQualifiedName(type.resolve());
        }
        return null;
    }

    private static Map<String, ActivityState> getActivityClassNameToActivityState(Set<String> activityClassNames) {
        HashMap<String, ActivityState> result = new HashMap<String, ActivityState>();
        for (String activityClassName : activityClassNames) {
            result.put(activityClassName, new ActivityState(activityClassName));
        }
        return result;
    }

    @Nullable
    public static String getXMLFileName(Module module, String controllerClassName, boolean isActivity) {
        MultiMatch.Bindings<PsiElement> exp = isActivity ? Analyser.match(module, controllerClassName, "void onCreate(Bundle bundle)", "void macro(Object $R, Object $id) { setContentView($R.layout.$id); }") : Analyser.match(module, controllerClassName, "View onCreateView(LayoutInflater li, ViewGroup vg, Bundle b)", "void macro(Object $inflater, Object $R, Object $id, Object $container) { $inflater.inflate($R.layout.$id, $container, false); }");
        if (exp == null) {
            return null;
        }
        return exp.get("$id").getText();
    }

    public static void search(@Nullable PsiElement input, final Evaluator evaluator, final MultiMatch matcher, final Processor processor) {
        if (input != null) {
            input.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                private void visitNullableExpression(@Nullable PsiExpression expression) {
                    if (expression != null) {
                        this.visitExpression(expression);
                    }
                }

                private void visitNullableStatement(@Nullable PsiStatement statement) {
                    if (statement != null) {
                        this.visitStatement(statement);
                    }
                }

                public void visitIfStatement(PsiIfStatement statement) {
                    PsiExpression condition = statement.getCondition();
                    this.visitNullableExpression(condition);
                    Object value = evaluator.evaluate(condition);
                    if (value != Boolean.FALSE) {
                        this.visitNullableStatement(statement.getThenBranch());
                    }
                    if (value != Boolean.TRUE) {
                        this.visitNullableStatement(statement.getElseBranch());
                    }
                }

                public void visitExpression(PsiExpression expression) {
                    super.visitExpression(expression);
                    MultiMatch.Bindings<PsiElement> exp = matcher.match((PsiElement)expression);
                    if (exp != null) {
                        processor.process(exp);
                    }
                }
            });
        }
    }

    public static void search(@Nullable PsiElement input, MultiMatch matcher, Processor processor) {
        Analyser.search(input, Evaluator.TRUE_OR_FALSE, matcher, processor);
    }

    public static List<MultiMatch.Bindings<PsiElement>> search(@Nullable PsiElement element, MultiMatch matcher) {
        final ArrayList<MultiMatch.Bindings<PsiElement>> results = new ArrayList<MultiMatch.Bindings<PsiElement>>();
        Analyser.search(element, matcher, new Processor(){

            @Override
            public void process(MultiMatch.Bindings<PsiElement> exp) {
                results.add(exp);
            }
        });
        return results;
    }

    private static void search(PsiClass clazz, String methodSignature, MultiMatch matcher, Processor processor) {
        PsiMethod method = Utilities.findMethodBySignature(clazz, methodSignature);
        if (method == null) {
            return;
        }
        Analyser.search((PsiElement)method.getBody(), matcher, processor);
    }

    private static void search(PsiClass clazz, String methodSignature, String matchMacro, Processor processor) {
        Analyser.search(clazz, methodSignature, new MultiMatch(Utilities.createMethodFromText(clazz, matchMacro)), processor);
    }

    @Nullable
    private static MultiMatch.Bindings<PsiElement> match(PsiClass clazz, String methodSignature, String matchMacro) {
        PsiMethod method = Utilities.findMethodBySignature(clazz, methodSignature);
        if (method == null) {
            return null;
        }
        MultiMatch matcher = new MultiMatch(Utilities.createMethodFromText(clazz, matchMacro));
        List<MultiMatch.Bindings<PsiElement>> results = Analyser.search((PsiElement)method.getBody(), matcher);
        if (results.size() != 1) {
            return null;
        }
        return results.get(0);
    }

    @Nullable
    public static MultiMatch.Bindings<PsiElement> match(Module module, String className, String methodSignature, String matchMacro) {
        PsiClass clazz = Utilities.getPsiClass(module, className);
        if (clazz == null) {
            LOG.warn("Couldn't find class: " + className);
            return null;
        }
        return Analyser.match(clazz, methodSignature, matchMacro);
    }

    public static List<String> findProperties(@Nullable PsiClass input) {
        if (input == null) {
            return Collections.emptyList();
        }
        final ArrayList<String> result = new ArrayList<String>();
        input.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitMethod(PsiMethod method) {
                super.visitMethod(method);
                if (method.getName().startsWith("get")) {
                    result.add(PropertyUtil.getPropertyName((PsiMethod)method));
                }
            }
        });
        return result;
    }

    public static abstract class Processor {
        public abstract void process(MultiMatch.Bindings<PsiElement> var1);
    }

    static class MiniModel {
        final Map<String, ActivityState> classNameToActivityState;
        final Map<String, MenuState> menuNameToMenuState;

        MiniModel(Map<String, ActivityState> classNameToActivityState, Map<String, MenuState> menuNameToMenuState) {
            this.classNameToActivityState = classNameToActivityState;
            this.menuNameToMenuState = menuNameToMenuState;
        }

        MiniModel() {
            this(new HashMap<String, ActivityState>(), new HashMap<String, MenuState>());
        }
    }

    public static abstract class Evaluator {
        public static final Evaluator TRUE_OR_FALSE = new Evaluator(){

            @Override
            @Nullable
            public Object evaluate(@Nullable PsiExpression expression) {
                return null;
            }
        };

        public abstract Object evaluate(@Nullable PsiExpression var1);
    }
}

