/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.compiler;

import com.android.tools.idea.gradle.compiler.AndroidGradleBuildConfiguration;
import com.android.tools.idea.gradle.invoker.GradleInvoker;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.sdk.DefaultSdks;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.compiler.server.BuildProcessParametersProvider;
import com.intellij.execution.configurations.CommandLineTokenizer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.KeyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.net.HttpConfigurable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class AndroidGradleBuildProcessParametersProvider
extends BuildProcessParametersProvider {
    @NotNull
    private final Project myProject;

    public AndroidGradleBuildProcessParametersProvider(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/compiler/AndroidGradleBuildProcessParametersProvider", "<init>"));
        }
        this.myProject = project;
    }

    @NotNull
    public List<String> getVMArguments() {
        if (!Projects.isBuildWithGradle(this.myProject)) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/compiler/AndroidGradleBuildProcessParametersProvider", "getVMArguments"));
            }
            return list;
        }
        ArrayList jvmArgs = Lists.newArrayList();
        AndroidGradleBuildConfiguration buildConfiguration = AndroidGradleBuildConfiguration.getInstance(this.myProject);
        AndroidGradleBuildProcessParametersProvider.populateJvmArgs(buildConfiguration, jvmArgs, this.myProject);
        GradleExecutionSettings executionSettings = GradleUtil.getGradleExecutionSettings(this.myProject);
        if (executionSettings != null) {
            this.populateJvmArgs(executionSettings, (List<String>)jvmArgs);
        }
        this.populateJvmArgs(BuildSettings.getInstance(this.myProject), (List<String>)jvmArgs);
        AndroidGradleBuildProcessParametersProvider.addHttpProxySettings(jvmArgs);
        ArrayList arrayList = jvmArgs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/compiler/AndroidGradleBuildProcessParametersProvider", "getVMArguments"));
        }
        return arrayList;
    }

    @VisibleForTesting
    static void populateJvmArgs(@NotNull AndroidGradleBuildConfiguration buildConfiguration, @NotNull List<String> jvmArgs, @NotNull Project project) {
        if (buildConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildConfiguration", "com/android/tools/idea/gradle/compiler/AndroidGradleBuildProcessParametersProvider", "populateJvmArgs"));
        }
        if (jvmArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmArgs", "com/android/tools/idea/gradle/compiler/AndroidGradleBuildProcessParametersProvider", "populateJvmArgs"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/compiler/AndroidGradleBuildProcessParametersProvider", "populateJvmArgs"));
        }
        jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.offline.mode", (boolean)GradleSettings.getInstance((Project)project).isOfflineWork()));
        jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.configuration.on.demand", (boolean)buildConfiguration.USE_CONFIGURATION_ON_DEMAND));
        String[] commandLineOptions = buildConfiguration.getCommandLineOptions();
        int optionCount = 0;
        for (String option : commandLineOptions) {
            String name = "com.android.studio.gradle.daemon.command.line.option." + optionCount++;
            jvmArgs.add(AndroidGradleSettings.createJvmArg((String)name, (String)option));
        }
    }

    @VisibleForTesting
    void populateJvmArgs(@NotNull GradleExecutionSettings executionSettings, @NotNull List<String> jvmArgs) {
        File javaHome;
        String serviceDirectory;
        if (executionSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executionSettings", "com/android/tools/idea/gradle/compiler/AndroidGradleBuildProcessParametersProvider", "populateJvmArgs"));
        }
        if (jvmArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmArgs", "com/android/tools/idea/gradle/compiler/AndroidGradleBuildProcessParametersProvider", "populateJvmArgs"));
        }
        String gradleHome = executionSettings.getGradleHome();
        if (gradleHome != null && !gradleHome.isEmpty()) {
            gradleHome = FileUtil.toSystemDependentName((String)gradleHome);
            jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.home.path", (String)gradleHome));
        }
        if ((serviceDirectory = executionSettings.getServiceDirectory()) != null && !serviceDirectory.isEmpty()) {
            serviceDirectory = FileUtil.toSystemDependentName((String)serviceDirectory);
            jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.service.dir.path", (String)serviceDirectory));
        }
        if ((javaHome = DefaultSdks.getDefaultJavaHome()) != null) {
            jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.java.home.path", (String)javaHome.getPath()));
        }
        String basePath = FileUtil.toSystemDependentName((String)this.myProject.getBasePath());
        jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.project.path", (String)basePath));
        boolean verboseProcessing = executionSettings.isVerboseProcessing();
        jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.use.verbose.logging", (boolean)verboseProcessing));
        String jvmOptions = executionSettings.getDaemonVmOptions();
        int jvmOptionCount = 0;
        if (jvmOptions != null && !jvmOptions.isEmpty()) {
            CommandLineTokenizer tokenizer = new CommandLineTokenizer(jvmOptions);
            while (tokenizer.hasMoreTokens()) {
                String name = "com.android.studio.gradle.daemon.jvm.option." + jvmOptionCount++;
                jvmArgs.add(AndroidGradleSettings.createJvmArg((String)name, (String)tokenizer.nextToken()));
            }
        }
    }

    private static void addHttpProxySettings(@NotNull List<String> jvmArgs) {
        if (jvmArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmArgs", "com/android/tools/idea/gradle/compiler/AndroidGradleBuildProcessParametersProvider", "addHttpProxySettings"));
        }
        List proxyProperties = HttpConfigurable.getJvmPropertiesList((boolean)false, null);
        AndroidGradleBuildProcessParametersProvider.populateHttpProxyProperties(jvmArgs, proxyProperties);
    }

    @VisibleForTesting
    static void populateHttpProxyProperties(List<String> jvmArgs, List<KeyValue<String, String>> properties) {
        int propertyCount = properties.size();
        for (int i = 0; i < propertyCount; ++i) {
            KeyValue<String, String> property = properties.get(i);
            String name = "com.android.studio.gradle.proxy.property." + i;
            String value = (String)property.getKey() + ":" + (String)property.getValue();
            jvmArgs.add(AndroidGradleSettings.createJvmArg((String)name, (String)value));
        }
    }

    private void populateJvmArgs(@NotNull BuildSettings buildSettings, @NotNull List<String> jvmArgs) {
        if (buildSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildSettings", "com/android/tools/idea/gradle/compiler/AndroidGradleBuildProcessParametersProvider", "populateJvmArgs"));
        }
        if (jvmArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmArgs", "com/android/tools/idea/gradle/compiler/AndroidGradleBuildProcessParametersProvider", "populateJvmArgs"));
        }
        BuildMode buildMode = buildSettings.getBuildMode();
        if (buildMode == null) {
            buildMode = BuildMode.DEFAULT_BUILD_MODE;
        }
        jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.build.mode", (String)buildMode.toString()));
        this.populateGradleTasksToInvoke(buildMode, jvmArgs);
    }

    @VisibleForTesting
    void populateGradleTasksToInvoke(@NotNull BuildMode buildMode, @NotNull List<String> jvmArgs) {
        if (buildMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildMode", "com/android/tools/idea/gradle/compiler/AndroidGradleBuildProcessParametersProvider", "populateGradleTasksToInvoke"));
        }
        if (jvmArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmArgs", "com/android/tools/idea/gradle/compiler/AndroidGradleBuildProcessParametersProvider", "populateGradleTasksToInvoke"));
        }
        if (buildMode == BuildMode.ASSEMBLE_TRANSLATE) {
            jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.gradle.tasks.0", (String)"assembleTranslate"));
            return;
        }
        BuildSettings buildSettings = BuildSettings.getInstance(this.myProject);
        Module[] modulesToBuild = buildSettings.getModulesToBuild();
        if (modulesToBuild == null || buildMode == BuildMode.ASSEMBLE && Projects.lastGradleSyncFailed(this.myProject)) {
            jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.gradle.tasks.0", (String)"assemble"));
            return;
        }
        GradleInvoker.TestCompileType testCompileType = GradleInvoker.getTestCompileType(buildSettings.getRunConfigurationTypeId());
        List<String> tasks = GradleInvoker.findTasksToExecute(modulesToBuild, buildMode, testCompileType);
        int taskCount = tasks.size();
        for (int i = 0; i < taskCount; ++i) {
            String name = "com.android.studio.gradle.gradle.tasks." + i;
            jvmArgs.add(AndroidGradleSettings.createJvmArg((String)name, (String)tasks.get(i)));
        }
    }
}

